/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.calculation.vm.scalar;

public class ScalarLisp {
  char[] inp;
  int ix;
  StringBuffer outp;

  public String getAsXML(String inp) {
    this.inp = inp.toCharArray();
    ix = 0;
    outp = new StringBuffer();
    outp.append(HeaderFooter.header);
    getAsXML0();
    outp.append(HeaderFooter.footer);
    return outp.toString();
  }

  private void getAsXML0() {
    skip();
    if (inp[ix] == '(') {
      ++ix;
      outp.append("<scalarExpression>\n");
      outp.append("    <list>\n");

      // compile operator 
      skip();
      outp.append("        <opr>\n");
      outp.append("            <scalarOpr>");
      while (!isStopSymbol(inp[ix])) {
        outp.append(inp[ix]);
        ++ix;
      }
      outp.append("</scalarOpr>\n");
      outp.append("        </opr>\n");

      // compile argument list 
      skip();
      outp.append("        <args>\n");
      while (inp[ix] != ')') {
        if (isNumber(inp[ix])) {
          // compile numbers
          outp.append("            <const>\n");
          outp.append("                <scalarConst>\n");
          outp.append("                    <value>");
          while (!isStopSymbol(inp[ix])) {
            outp.append(inp[ix]);
            ++ix;
          }
          outp.append("</value>\n");
          outp.append("                </scalarConst>\n");
          outp.append("            </const>\n");
        }
        else if (isVar(inp[ix])) {
          // compile variable
          outp.append("            <var>\n");
          outp.append("                <scalarVar>");
          while (!isStopSymbol(inp[ix])) {
            outp.append(inp[ix]);
            ++ix;
          }
          outp.append("</scalarVar>\n");
          outp.append("            </var>\n");
        }
        else if (inp[ix] == '(') {
          // compile expression
          getAsXML0();
        }
        skip();
      }
      ++ix;
      outp.append("        </args>\n");

      outp.append("    </list>\n");
      outp.append("</scalarExpression>\n");
    }
  }

  private boolean isNumber(char test) {
    switch (test) {
      case '-' :
      case '+' :
      case '.' :
      case '0' :
      case '1' :
      case '2' :
      case '3' :
      case '4' :
      case '5' :
      case '6' :
      case '7' :
      case '8' :
      case '9' :
        return true;
    }
    return false;
  }

  private boolean isVar(char test) {
    return test >= 'a' && test <= 'z';
  }

  private boolean isStopSymbol(char test) {
    if(test == ' ')
      return true;
    if(test == ')')
      return true;
    return false;
  }

  private void skip() {
    while (inp[ix] == ' ') {
      ++ix;
    }
  }
}
