/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.calculation.tutorial.shape;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;

import kandid.calculation.VectorCalculation;
import kandid.soup.TutorialCircleGene;
import kandid.soup.TutorialShapeChromosome;

/**
 * @author thomas jourdan
 *
 */
public class TutorialShapeCalculation extends VectorCalculation {
  private boolean ready;

  /* (non-Javadoc)
   * @see kandid.calculation.Calculation#calculate(boolean, java.lang.String)
   */
  public void calculate(boolean paintOnScreen, String exportFilename) {
    // get chromosome
    TutorialShapeChromosome shapeChromosome = (TutorialShapeChromosome) chromosome;
    // initialize transformation without border
    initTransformation(0.0);
    // get the background color and fill the whole canvas
    Color background =
      new Color(shapeChromosome.getColor().getRed(),
                shapeChromosome.getColor().getGreen(),
                shapeChromosome.getColor().getBlue());
    g2d.setColor(background);
    g2d.fillRect(0, 0, canvasSize.width, canvasSize.height);

    List<TutorialCircleGene> allShapes = shapeChromosome.getAllShapes();
    for (Iterator<TutorialCircleGene> shapeIter = allShapes.iterator(); shapeIter.hasNext();) {
      Object element = shapeIter.next();
      if (element instanceof TutorialCircleGene) {
        TutorialCircleGene shape = (TutorialCircleGene) element;
        // get the fill color
        Color fillcolor = new Color(shape.getColor().getRed(),
                                    shape.getColor().getGreen(),
                                    shape.getColor().getBlue());
        g2d.setColor(fillcolor);
        // get transparence and map to Graphic2D alpha composite class
        float alpha = (float)(double)shape.getTransparency().getValue();
        AlphaComposite ac = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, alpha);
        g2d.setComposite(ac);
        // get position and transform
        transform(shape.getX().getValue(), shape.getY().getValue());
        int x1 = xp;
        int y1 = yp;
        // transform the radius and fill it
        transform(0.5*shape.getRadius().getValue(), 0.5*shape.getRadius().getValue());
        int r1 = xp;
        // fill circle
        g2d.fillOval(x1+r1, y1+r1, r1, r1);
      }
    }

    // image is complete
    ready = true;
  }

  /* (non-Javadoc)
   * @see kandid.calculation.Calculation#getPercent()
   */
  public int getPercent() {
    // -1 disables the percentage display, that's Ok for the first step.
    return -1;
  }

  /* (non-Javadoc)
   * @see kandid.calculation.Calculation#getReady()
   */
  public boolean getReady() {
    return ready;
  }

  /* (non-Javadoc)
   * @see kandid.calculation.Calculation#getBackgroundColor()
   */
  public boolean hasWhiteBackground() {
    // false means black background
    return false;
  }

}
