// This file was generated by the sdlexport.xsl style sheet.
// Any modifications to this file will be lost upon recompilation of the style sheet or the source schema.
package kandid.calculation.bridge.povray;
import kandid.soup.ExprSdlArgsListGene;
import kandid.soup.ExprSdlConstGene;
import kandid.soup.ExprSdlListGene;
import kandid.soup.ExprSdlOprBase;
import kandid.soup.ExprSdlOprGene;
import kandid.soup.ExprSdlVarBase;
import kandid.soup.ExprSdlVarGene;
import kandid.soup.SdlExpressionGene;
public class SdlExport {
public SdlExport() {
}
/**
* generateSDLFunction.
* @param sdlExpressionGene
*/
public StringBuffer generateSDLFunction(ExprSdlListGene exprSdlListGene) {
StringBuffer sdl = new StringBuffer();
sdl.append("function(x,y,z) { ");
sdl.append(compile0(exprSdlListGene));
sdl.append(" }");
return sdl;
}
/**
* Method compile0.
* @param sdlExpressionGene
*/
private StringBuffer compile0(ExprSdlListGene exprSdlListGene) {
StringBuffer sdl = new StringBuffer();
sdl.append("(");
ExprSdlOprGene opr = exprSdlListGene.getOpr();
ExprSdlArgsListGene args = exprSdlListGene.getArgs();
java.util.List argsList = args.getVarOrConstOrSdlExpression();
int argsLen = argsList.size();
assert argsLen > 0 : "argument list to short " + argsLen;
if (false) {
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.ADD)) {
// operator chain with varaible number of arguments
for (int ax = 0; ax < argsLen; ax++) {
sdl.append(compileElement(argsList.get(ax)));
if(ax+1 < argsLen)
sdl.append("+");
}
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.MULT)) {
// operator chain with varaible number of arguments
for (int ax = 0; ax < argsLen; ax++) {
sdl.append(compileElement(argsList.get(ax)));
if(ax+1 < argsLen)
sdl.append("*");
}
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.SUB)) {
// operator chain with varaible number of arguments
for (int ax = 0; ax < argsLen; ax++) {
sdl.append(compileElement(argsList.get(ax)));
if(ax+1 < argsLen)
sdl.append("-");
}
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.DIV)) {
// operator chain with varaible number of arguments
for (int ax = 0; ax < argsLen; ax++) {
sdl.append(compileElement(argsList.get(ax)));
if(ax+1 < argsLen)
sdl.append("/");
}
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.MAX)) {
// function with varaible number of arguments
sdl.append("max(");
for (int ax = 0; ax < argsLen; ax++) {
sdl.append(compileElement(argsList.get(ax)));
if(ax+1 < argsLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.MIN)) {
// function with varaible number of arguments
sdl.append("min(");
for (int ax = 0; ax < argsLen; ax++) {
sdl.append(compileElement(argsList.get(ax)));
if(ax+1 < argsLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.MOD)) {
// function with 2 of arguments
int fixedLen = 2;
sdl.append("mod(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.NOISE)) {
// function with 3 of arguments
int fixedLen = 3;
sdl.append("f_noise3d(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.SNOISE)) {
// function with 3 of arguments
int fixedLen = 3;
sdl.append("f_snoise3d(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.ATANQ)) {
// function with 2 of arguments
int fixedLen = 2;
sdl.append("atan2(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.POW)) {
// function with 2 of arguments
int fixedLen = 2;
sdl.append("pow(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.SQRT)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("sqrt(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.POW)) {
// function with 2 of arguments
int fixedLen = 2;
sdl.append("pow(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.ABS)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("abs(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.ACOS)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("acos(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.ACOSH)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("acosh(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.ASIN)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("asin(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.ASINH)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("asinh(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.ATAN)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("atan(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.ATANH)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("atanh(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.CEIL)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("ceil(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.COS)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("cos(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.COSH)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("cosh(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.DEGREES)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("degrees(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.EXP)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("exp(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.FLOOR)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("floor(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.LN)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("ln(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.LOG)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("log(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.RADIANS)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("radians(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.SIN)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("sin(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.SINH)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("sinh(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.SQRT)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("sqrt(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.TAN)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("tan(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else if(opr.getSdlOpr().equals(ExprSdlOprBase.TANH)) {
// function with 1 of arguments
int fixedLen = 1;
sdl.append("tanh(");
for (int ax = 0; ax < fixedLen; ax++) {
sdl.append(compileElement(argsList.get(ax % argsList.size())));
if(ax+1 < fixedLen)
sdl.append(",");
}
sdl.append(")");
}
else {
assert false : "invalid operator " + opr.getSdlOpr();
}
sdl.append(")");
return sdl;
}
/**
* @param obj
*/
private StringBuffer compileElement(Object obj) {
StringBuffer sdl = new StringBuffer();
if (obj instanceof ExprSdlVarGene) {
ExprSdlVarGene var = (ExprSdlVarGene) obj;
if (var.getSdlVar().equals(ExprSdlVarBase.X)) {
sdl.append(" x");
}
else if (var.getSdlVar().equals(ExprSdlVarBase.Y)) {
sdl.append(" y");
}
else if (var.getSdlVar().equals(ExprSdlVarBase.Z)) {
sdl.append(" z");
}
}
else if (obj instanceof ExprSdlConstGene) {
ExprSdlConstGene aConst = (ExprSdlConstGene) obj;
sdl.append(" " + aConst.getSdlConst().getValue());
}
else if (obj instanceof SdlExpressionGene) {
SdlExpressionGene sdlExpressionArg = (SdlExpressionGene) obj;
sdl.append(compile0(sdlExpressionArg.getList()));
}
else {
assert false : "invalid object generating SDL expression" + obj.getClass().getName();
}
return sdl;
}
}
