/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.calculation.bridge.flame;

import java.awt.Dimension;
import java.util.Iterator;
import java.util.List;

import javax.swing.JOptionPane;

import kandid.Kandid;
import kandid.calculation.bridge.BridgeBase;
import kandid.calculation.bridge.BatchJob;
import kandid.soup.ChromosomeType;
import kandid.soup.FlameIfsChromosome;
import kandid.soup.FlameTransformationGene;

/**
 * @author thomas jourdan
 *
 */
public class FlameJob extends BatchJob {

  private final static String scriptExtension = ".flam3";

//!!  private String templateHead = 
//        "<test>\n"
//      + "<flame time=\"0\" palette=\"{2,number,#}\" size=\"{0,number,#} {1,number,#}\" center=\"0 0\" scale=\"{9}\" zoom=\"{7}\" oversample=\"1\" filter=\"{8}\" quality=\"2\" batches=\"10\" background=\"0 0 0\" brightness=\"{3}\" gamma=\"{4}\" vibrancy=\"{5}\" hue=\"{6}\">\n";
//      
//  private String templateXForm = 
//        "   <xform weight=\"{0}\" color=\"{24}\" var=\"{7} {8} {9} {10} {11} {12} {13} {14} {15} {16} {17} {18} {19} {20} {21} {22} {23}\" coefs=\"{1} {2} {3} {4} {5} {6}\"/>\n";
//      
//  private String templateTail = 
//        "</flame>\n"
//      + "</test>\n";
      
  /* (non-Javadoc)
   * @see kandid.calculation.newbridge.BatchJob#createJob(kandid.soup.ChromosomeType, java.awt.Dimension, java.lang.String)
   */
  public void createJob(ChromosomeType chromosome, Dimension canvasSize, boolean preview, String exportFilename, String imageFormat) {
    this.canvasSize = canvasSize;
    this.preview = preview;
    this.imageFormat = imageFormat;
//!!    this.exportFilename = exportFilename;
    doExport = exportFilename != null;
    expextedExitCode = 1;
    errorMessage = new StringBuffer();
    childProgram = getProgramName();
    String ident = chromosome.getIdent() + (preview ? "__p" : "__f");
    if(doExport) {
      scriptFileName = exportFilename + scriptExtension;
      imageFileName = exportFilename +  "." + imageFormat;
    }
    else {
      scriptFileName = Kandid.scratchFolder + "/" + ident + scriptExtension;
      imageFileName = Kandid.scratchFolder + "/" + ident +  "." + imageFormat;
    }
    script = expandScript(chromosome);
    comandline = buildCommand();
    environment = buildEnvironment();
    
    if(firstUsage) {
      firstUsage = false;
      tryExecute();
    }
  }

  protected String expandScript(ChromosomeType chromosome) {
    FlameIfsChromosome flameIfsChromosome = (FlameIfsChromosome)chromosome;
//!!    Object[] argumentsHead = {
//      /* {0} */ new Integer(canvasSize.width / (preview ? BridgeBase.previewScale : 1)),
//      /* {1} */ new Integer(canvasSize.height / (preview ? BridgeBase.previewScale : 1)),
//      /* {2} */ new Integer(flameIfsChromosome.getPalette().getValue()),
//      /* {3} */ new Double(flameIfsChromosome.getBrightness().getValue()),
//      /* {4} */ new Double(flameIfsChromosome.getGamma().getValue()),
//      /* {5} */ new Double(flameIfsChromosome.getVibrancy().getValue()),
//      /* {6} */ new Double(flameIfsChromosome.getHue().getValue()),
//      /* {7} */ new Double((flameIfsChromosome.getZoom().getValue())),
//      /* {8} */ new Double(flameIfsChromosome.getFilter().getValue()),
//      /* {9} */ new Double(100*((double)canvasSize.width / (double)1024) / (preview ? (double)BridgeBase.previewScale : 1.0)),
//     };
//    String script = MessageFormat.format(templateHead, argumentsHead);
    String quality = preview ? " quality=\"2\"" : " quality=\"20\""; 
    String script = 
          "<test>\n" +
          "<flame time=\"0\"" +
          " palette=\"" + flameIfsChromosome.getPalette().getValue() + "\"" +
          " size=\"" + (canvasSize.width / (preview ? BridgeBase.previewScale : 1)) + " " + (canvasSize.height / (preview ? BridgeBase.previewScale : 1)) + "\"" +
          " center=\"0 0\"" +
          " scale=\"" + (100*((double)canvasSize.width / (double)1024) / (preview ? (double)BridgeBase.previewScale : 1.0)) + "\"" +
          " zoom=\"" + flameIfsChromosome.getZoom().getValue() + "\"" +
          " oversample=\"1\"" +
          " filter=\"" + flameIfsChromosome.getFilter().getValue() +"\"" +
          quality +
          " batches=\"10\"" +
          " background=\"0 0 0\"" +
          " brightness=\"" + flameIfsChromosome.getBrightness().getValue() +"\"" +
          " gamma=\"" + flameIfsChromosome.getGamma().getValue() + "\"" +
          " vibrancy=\"" + flameIfsChromosome.getVibrancy().getValue() + "\"" +
          " hue=\"" + flameIfsChromosome.getHue().getValue() + "\">\n";
    
    List<FlameTransformationGene> flameTransformationList = flameIfsChromosome.getFlameTransformation();
    for (Iterator<FlameTransformationGene> iter = flameTransformationList.iterator(); iter.hasNext();) {
      FlameTransformationGene flameTransformation = iter.next();
//      Object[] argumentsXForm = {
//        /* {0} */ new Double(flameTransformation.getWeight().getValue()),
//        /* {1} */ new Double(flameTransformation.getTa().getValue()),
//        /* {2} */ new Double(flameTransformation.getTd().getValue()),
//        /* {3} */ new Double(flameTransformation.getTb().getValue()),
//        /* {4} */ new Double(flameTransformation.getTe().getValue()),
//        /* {5} */ new Double(flameTransformation.getTc().getValue()),
//        /* {6} */ new Double(flameTransformation.getTf().getValue()),
//        /* {7} */ new Double(flameTransformation.getLinearEnabled().isValue() ? flameTransformation.getLinearVariation().getValue() : 0.0),
//        /* {8} */ new Double(flameTransformation.getSinusoidalEnabled().isValue() ? flameTransformation.getSinusoidalVariation().getValue() : 0.0),
//        /* {9} */ new Double(flameTransformation.getSphericalEnabled().isValue() ? flameTransformation.getSphericalVariation().getValue() : 0.0),
//        /* {10} */ new Double(flameTransformation.getSwirlEnabled().isValue() ? flameTransformation.getSwirlVariation().getValue() : 0.0),
//        /* {11} */ new Double(flameTransformation.getHorseshoeEnabled().isValue() ? flameTransformation.getHorseshoeVariation().getValue() : 0.0),
//        /* {12} */ new Double(flameTransformation.getPolarEnabled().isValue() ? flameTransformation.getPolarVariation().getValue() : 0.0),
//        /* {13} */ new Double(flameTransformation.getFoldedHandkerchiefEnabled().isValue() ? flameTransformation.getFoldedHandkerchiefVariation().getValue() : 0.0),
//        /* {14} */ new Double(flameTransformation.getHeartEnabled().isValue() ? flameTransformation.getHeartVariation().getValue() : 0.0),
//        /* {15} */ new Double(flameTransformation.getDiscEnabled().isValue() ? flameTransformation.getDiscVariation().getValue() : 0.0),
//        /* {16} */ new Double(flameTransformation.getSpiralEnabled().isValue() ? flameTransformation.getSpiralVariation().getValue() : 0.0),
//        /* {17} */ new Double(flameTransformation.getHyperbolicEnabled().isValue() ? flameTransformation.getHyperbolicVariation().getValue() : 0.0),
//        /* {18} */ new Double(flameTransformation.getDiamondEnabled().isValue() ? flameTransformation.getDiamondVariation().getValue() : 0.0),
//        /* {19} */ new Double(flameTransformation.getExEnabled().isValue() ? flameTransformation.getExVariation().getValue() : 0.0),
//        /* {20} */ new Double(flameTransformation.getJuliaEnabled().isValue() ? flameTransformation.getJuliaVariation().getValue() : 0.0),
//        /* {21} */ new Double(flameTransformation.getBentEnabled().isValue() ? flameTransformation.getBentVariation().getValue() : 0.0),
//        /* {22} */ new Double(flameTransformation.getFisheyeEnabled().isValue() ? flameTransformation.getFisheyeVariation().getValue() : 0.0),
//        /* {23} */ new Double(flameTransformation.getPopcornEnabled().isValue() ? flameTransformation.getPopcornVariation().getValue() : 0.0),
//        /* {24} */ new Double(flameTransformation.getColorindex().getValue()),
//       };
//      script += MessageFormat.format(templateXForm, argumentsXForm);
      script += "   <xform weight=\""+ flameTransformation.getWeight().getValue() + "\"" +
        " color=\"" + flameTransformation.getColorindex().getValue() + "\"" +
        " var=\"" +
                  " " + (flameTransformation.getLinearEnabled().isValue() ? flameTransformation.getLinearVariation().getValue() : 0.0) +
                  " " + (flameTransformation.getSinusoidalEnabled().isValue() ? flameTransformation.getSinusoidalVariation().getValue() : 0.0) +
                  " " + (flameTransformation.getSphericalEnabled().isValue() ? flameTransformation.getSphericalVariation().getValue() : 0.0) +
                  " " + (flameTransformation.getSwirlEnabled().isValue() ? flameTransformation.getSwirlVariation().getValue() : 0.0) +
                  " " + (flameTransformation.getHorseshoeEnabled().isValue() ? flameTransformation.getHorseshoeVariation().getValue() : 0.0) +
                  " " + (flameTransformation.getPolarEnabled().isValue() ? flameTransformation.getPolarVariation().getValue() : 0.0) +
                  " " + (flameTransformation.getFoldedHandkerchiefEnabled().isValue() ? flameTransformation.getFoldedHandkerchiefVariation().getValue() : 0.0) +
                  " " + (flameTransformation.getHeartEnabled().isValue() ? flameTransformation.getHeartVariation().getValue() : 0.0) +
                  " " + (flameTransformation.getDiscEnabled().isValue() ? flameTransformation.getDiscVariation().getValue() : 0.0) +
                  " " + (flameTransformation.getSpiralEnabled().isValue() ? flameTransformation.getSpiralVariation().getValue() : 0.0) +
                  " " + (flameTransformation.getHyperbolicEnabled().isValue() ? flameTransformation.getHyperbolicVariation().getValue() : 0.0) +
                  " " + (flameTransformation.getDiamondEnabled().isValue() ? flameTransformation.getDiamondVariation().getValue() : 0.0) +
                  " " + (flameTransformation.getExEnabled().isValue() ? flameTransformation.getExVariation().getValue() : 0.0) +
                  " " + (flameTransformation.getJuliaEnabled().isValue() ? flameTransformation.getJuliaVariation().getValue() : 0.0) +
                  " " + (flameTransformation.getBentEnabled().isValue() ? flameTransformation.getBentVariation().getValue() : 0.0) +
                  " " + (flameTransformation.getFisheyeEnabled().isValue() ? flameTransformation.getFisheyeVariation().getValue() : 0.0) +
                  " " + (flameTransformation.getPopcornEnabled().isValue() ? flameTransformation.getPopcornVariation().getValue() : 0.0) +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
                  " 0.0" +
        "\" coefs=\"" + flameTransformation.getTa().getValue() + 
                 " " + flameTransformation.getTd().getValue() +
                 " " + flameTransformation.getTb().getValue() + 
                 " " + flameTransformation.getTe().getValue() + 
                 " " + flameTransformation.getTc().getValue() + 
                 " " + flameTransformation.getTf().getValue() + "\"/>\n";
    }
    script += "</flame>\n";
    script += "</test>\n";
    return script;
  }
  
  protected String[] buildEnvironment() {
    // set up environment variables
    String[] envp = new String[3];
    envp[0] = "in=" + scriptFileName;
    envp[1] = "out=" + imageFileName;
    envp[2] = "format=" + imageFormat;
    return envp;
  }


  /* (non-Javadoc)
   * @see kandid.calculation.bridge.Bridge#buildCommand(kandid.soup.ChromosomeType, java.lang.String)
   */
  protected String[] buildCommand() {
    String[] command = new String[1];
    command[0] = childProgram;
    return command;
  }

  /* (non-Javadoc)
   * @see kandid.calculation.newbridge.BatchJob#getScriptExtension()
   */
  protected String getScriptExtension() {
    return scriptExtension;
  }

  protected String getProgramName() {
    // set up command
    return "flam3-render";
  }

  protected void showExecError() {
    if ((showExecError & 1) == 0) {
      showExecError = 1;
      JOptionPane.showMessageDialog(
        Kandid.getFrame(),
"<HTML>'"
+ getProgramName()
+ "' not found."
+ "<br>"
+ "<br>'FLAM3 - cosmic recursive fractal flames' from Scott Draves is required."
+ "<br>"
+ "<br>You can get this software and its dependencies as a Debian package."
+ "<br><b>flam3-utils.deb</b>"
+ "<br>"
+ "<br>The genetic engine inside Kandid can be used as a front end to evolve flame images."
+ "<br>Flame acts, behind the scene, as an compiler reading parameter files, generated by Kandid, "
+ "<br>producing images. It is not necessary to edit the parameter files by hand nor starting qosmix "
+ "<br>manually."
+ "<br>From the users view there is no distinction between the build in and the external calculations."
+ "<br>"
+ "<br>The integration of flam3-render (version 3.1.1+ds2-2+b4) and Kandid (version 1.1.0) was developed under "
+ "<br>Debian 13 Trixie using openjdk (version 21.0.8 2025-07-15.)"
+ "<br>"
+ "<br>https://flam3.com/"
+ "<br>https://github.com/scottdraves/flam3"
+  "<br>",
   
        "FLAM3, additional software reqiered",
        JOptionPane.ERROR_MESSAGE);
    }
  }

}
