/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.calculation.bridge.flame;

import java.awt.Color;
import java.awt.Image;

import kandid.Kandid;
import kandid.calculation.bridge.BatchJob;
import kandid.calculation.bridge.FileBridge;
import kandid.calculation.bridge.PixelBridgeCalculation;
import kandid.util.Debug;

/**
 * @author thomas jourdan
 *
 */
public class FlameCalculation extends PixelBridgeCalculation {

  /**
   * Calculate image for display.
   */
  public void calculateView() {
    synchronized (this) {
      if(!aborted && runCount < 2) {
        FlameJob flameJob = null;
        try {
          ++runCount;
          flameJob = new FlameJob();
          flameJob.createJob(chromosome, canvasSize, runCount == 1, null, "png");
          if (Debug.enabled) System.out.println("FlameCalculation.calculate(): " + flameJob.imageFileName + " " + Debug.currentTime());
          bbridge = new FileBridge(flameJob);
          bbridge.execute();
          bbridge.waitFor();
          if(flameJob.state == BatchJob.stateReady) {
            Image image = bbridge.getImage();;
            if(image != null)
              bufAwtImg.getGraphics().drawImage(image, 0,0, Color.BLACK, Kandid.getFrame());
          }
          bbridge.cleanUp();
        }
        catch (Exception exc) {
          if(flameJob != null)
            System.err.println(flameJob.imageFileName);
          Debug.stackTrace(exc);
        }
        ready = runCount >= 2;
      }
      bbridge = null;
    }
  }

  /**
     * Calculate image for file export.
     * @param exportFilename
     */
  public void calculateExport(String exportFilename) {
    FlameJob flameJob = new FlameJob();
    flameJob.createJob(chromosome, canvasSize, false, exportFilename, "png");
    if (Debug.enabled) System.out.println("FlameCalculation.calculateExport(): " + flameJob.imageFileName + " " + Debug.currentTime());
    bbridge = new FileBridge(flameJob);
    bbridge.execute();
    bbridge.waitFor();
    bbridge = null;
    ready = true;
  }

}
