/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.calculation.bridge;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import kandid.Kandid;
import kandid.calculation.bridge.povray.TargaStreamReader;
import kandid.util.Debug;

/**
 * @author thomas jourdan
 *
 */
public class StreamBridge extends BridgeBase implements Bridge {
  /**
   * @param batchJob
   */
  public StreamBridge(BatchJob batchJob) {
    super(batchJob);
  }

  /**
   * Wait until the external program is ready or destroied.
   */
  public boolean recieve(Graphics graphics) {
    if (Debug.enabled && !(batchJob.state == BatchJob.stateRunning || batchJob.state == BatchJob.stateReady || batchJob.state == BatchJob.stateDestroied)) {
      System.err.println("waitFor() wrong state = " + batchJob.state + " " + batchJob.imageFileName);
      Debug.stackTrace(new Exception("" + Debug.currentTime()));
    }
    if (batchJob.state == BatchJob.stateReady) {
      graphics.drawImage(batchJob.importedImage, 0,0, Color.BLACK, Kandid.getFrame());
    }
    else if (batchJob.state == BatchJob.stateRunning) {
      try {
        synchronized (batchJob.incrementReady) {
          batchJob.incrementReady.wait();
          // part of the rendering is ready.
          graphics.drawImage(batchJob.importedImage, 0,0, Color.BLACK, Kandid.getFrame());
        }
      }
      catch (InterruptedException exc) {
        //!!Debug.stackTrace(exc);
        if (Debug.enabled)
          System.out.println("calculateExternal interrupted");
      }
    }
    if (Debug.enabled) System.out.println("recieve " + batchJob.state + ": " + batchJob.imageFileName +  " " + Debug.currentTime());
    return batchJob.state == BatchJob.stateReady || batchJob.state == BatchJob.stateDestroied;
  }

  /* (non-Javadoc)
   * @see kandid.calculation.newbridge.NewBridge#getImage()
   */
  public BufferedImage getImage() throws IOException {
    BufferedImage importedImage = null;
    return importedImage;
  }

  /**
   * Delete scratch files.
   */
  public void cleanUp() {
    if (!batchJob.doExport) {
      if (!Debug.enabled) {
        (new File(batchJob.scriptFileName)).delete();
      }
    }
  }
  /* (non-Javadoc)
   * @see kandid.calculation.newbridge.BridgeBase#execute()
   */
  public synchronized void execute() {
    super.execute();
    (new TargaStreamReader(childProcess, batchJob)).start();
  }

}
