/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.calculation.bridge;

import kandid.calculation.PixelCalculation;

import kandid.colorator.Colorator;
import kandid.soup.ChromosomeType;

/**
 * @author thomas jourdan
 *
 */
public abstract class PixelBridgeCalculation extends PixelCalculation {

  protected boolean ready;
  protected int runCount;
  protected Bridge bbridge;

  /* For documentation please see super class VectorCalculation. */
  public boolean reject(ChromosomeType chromosome) {
    ready = false;
    return false;
  }

  /* For documentation please see super class VectorCalculation. */
  public void setChromosome(ChromosomeType chromosome, Colorator colorator) {
    super.setChromosome(chromosome, colorator);
    runCount = 0;
    ready = false;
  }

  public void calculate(boolean paintOnScreen, String exportFilename) {
    if (paintOnScreen)
      calculateView();
    else
      calculateExport(exportFilename);
  }

  /**
   * Calculate image for display.
   */
  protected abstract void calculateView();

  /**
   * Calculate image for file export.
   * @param exportFilename
   */
  public abstract void calculateExport(String exportFilename);

  /* (non-Javadoc)
   * @see kandid.calculation.Calculation#getPercent()
   */
  public int getPercent() {
    return -1;
  }

  /* (non-Javadoc)
   * @see kandid.calculation.Calculation#getReady()
   */
  public boolean getReady() {
    return ready || aborted;
  }

  /* (non-Javadoc)
   * @see kandid.calculation.Calculation#getBackgroundColor()
   */
  public boolean hasWhiteBackground() {
    return false;
  }

  public void setAborted(boolean aborted) {
    super.setAborted(aborted);
    this.aborted = aborted;
    if (runCount < 2)
      runCount = 2;
    if (bbridge != null) {
      bbridge.destroy();
    }
  }

}
