/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.calculation.affineifs;

import java.awt.*;
import kandid.colorator.*;
import kandid.soup.ChromosomeType;

/**
 * Class AffineIFSsymColorCalculation
 * @author thomas jourdan
 */
public class AffineIfsSymmColorCalculation extends AffineIfsSymmCalculation implements Cloneable {

  /* For documentation please see super class IterationCalculation. */
  public void setChromosome(ChromosomeType chromosome, Colorator colorator) {
    super.setChromosome(chromosome, colorator);
//!!    prepareMatcher((AffineIFS)chromosome);
//!!    prepareWeight(chromosome, colorator);
  }

  /* For documentation please see super class Calculation. */
  public void activateCanvas(Component viewComponent, Dimension canvasSize, boolean zoomMode) {
    super.activateCanvas(viewComponent, canvasSize, zoomMode);
    prepareWeight();
  }
  
  /* For documentation please see super class IterationCalculation. */
  public void calculate(boolean paintOnScreen, String doExport) {
    calculateWeight(paintOnScreen);
  }
  
  /**
   * black background.
   * @return 0
   */
  public boolean hasWhiteBackground() {
    return false;
  }

}

