/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid.calculation.affineifs;

import kandid.soup.AffineIfsChromosome;
import kandid.soup.AffineIfsSymmChromosome;

/**
 * Class IFSCalculation
 * @author thomas jourdan
 */
public class AffineIfsSymmCalculation extends AffineIfsCalculation implements Cloneable {
  int symmetry;
  boolean Dn;

  /**
   * @see kandid.calculation.affineifs.AffineIfsCalculation#prepareMatcher(AffineIfsChromosome)
   */
  protected void prepareMatcher(AffineIfsChromosome ifsChromosome) {
    super.prepareMatcher(ifsChromosome);
    symmetry = ((AffineIfsSymmChromosome)ifsChromosome).getSymmetry().getValue();
    Dn = ((AffineIfsSymmChromosome)ifsChromosome).getDn().isValue();
  }

  /**
   * Calculates the next step for this iteration.
   * Results can be fond in member variable yw and xw.
   */
  protected void iterate() {
    super.iterate();
    if (symmetry > 0) {
      double angel  = 2.0 * Math.PI * (double)(rand.nextInt(symmetry)) / (double)symmetry;
      double cosinus = Math.cos(angel);
      double sinus   = Math.sin(angel);
      double x2 = cosinus * xw - sinus * yw;
      double y2 = sinus * xw + cosinus * yw;
      xw = x2;
      if (Dn && rand.nextBoolean()) {
        yw = -y2;
      }
      else {
        yw = y2;
      }
    }
  }
  
  /**
   * white background.
   * @return 0xffffff
   */
  public boolean hasWhiteBackground() {
    return true;
  }

}

