/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;

import kandid.util.Debug;


/**
 * @author thomas jourdan
 *
 */
//public class PopulationPreview extends JPanel {
public class PopulationPreview {
  public final static int populationPreviweWidth = 430;

  public static JList createPreviewList(JList list, java.util.ArrayList filelist) {
    final ImageListModel ilm = new ImageListModel(filelist);
    list.setModel(ilm);
    list.setCellRenderer(new ImageCellRenderer());
    list.setSelectedIndex(0);
    list.setVisibleRowCount(4);
    ListSelectionModel lsm = list.getSelectionModel();
    lsm.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    return list;
  }
  
  static class ImageListModel extends DefaultComboBoxModel {
    private static final long serialVersionUID = 1L;

    public ImageListModel(java.util.ArrayList filelist) {
      Icon icon;
      for (int i = 0; i < filelist.size(); i++) {
        Hashtable result = new Hashtable();
        // label
        int fnPos = ((String)filelist.get(i)).lastIndexOf('/');
        if(fnPos >= 0) {
          String label = ((String)filelist.get(i)).substring(fnPos+1);
          result.put("label", label);
        }
        else {
          result.put("label", filelist.get(i));
        }
        // path and filename
        result.put("filename", filelist.get(i));
        // preview icon
        BufferedImage imageIcon = null;
        try {
//          int exPos = filelist[i].lastIndexOf('.');
//          if(exPos >= 0) {
//            File imageInFile = new File(filelist[i].substring(0, exPos+1) + "png");
//            if(imageInFile.exists())
//              imageIcon = javax.imageio.ImageIO.read(imageInFile);
//          }
            File imageInFile = new File(((String)filelist.get(i)) + ".png");
            if(imageInFile.exists())
              imageIcon = javax.imageio.ImageIO.read(imageInFile);
        }
        catch (IOException exc) {
          Debug.stackTrace(exc);
        }
        icon = new PreviewIcon((String)result.get("label"), imageIcon);
        result.put("icon", icon);
        addElement(result);
      }
    }
  }
  
  static class ImageCellRenderer implements ListCellRenderer {
    private JLabel renderer;
    
    public ImageCellRenderer() {
      renderer = new JLabel();
      renderer.setOpaque(true);
    }
    
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
      if (value == null) {
        renderer.setText("");
        renderer.setIcon(null);
      }
      else {
        Hashtable hashtable = (Hashtable)value;
        renderer.setIcon((Icon)hashtable.get("icon"));
      }
      renderer.setBackground(isSelected ? Color.ORANGE : SystemColor.WHITE);
      renderer.setForeground(isSelected ? SystemColor.textHighlightText : SystemColor.textText);
      return renderer;
    }
  }
  
  static class PreviewIcon implements Icon {
    private BufferedImage imageIcon;
    private String label;
    private final static AlphaComposite acFill = AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.75F);
    private final static AlphaComposite acText = AlphaComposite.getInstance(AlphaComposite.SRC, 1.0F);
    
    public PreviewIcon(String label, BufferedImage imageIcon) {
      this.label = label;
      this.imageIcon = imageIcon;
    }
    
    public void paintIcon(Component c, Graphics g, int x, int y) {
      Graphics2D g2d = (Graphics2D) g;
      if(imageIcon != null) {
        int xp = (getIconWidth()-imageIcon.getWidth()) / 2;
        if(xp < 1)
          xp = 1;
        int yp = (getIconHeight()-imageIcon.getHeight()) / 2;
        if(yp < 1)
          yp = 1;
        g2d.drawImage(imageIcon, xp, yp, Color.BLACK, null);
      }
      
      g2d.setComposite(acFill);
      g2d.setColor(Color.WHITE);
      g2d.fillRect(2, getIconHeight()-17, getIconWidth()-4, 14);
      
      g2d.setComposite(acText);
      g2d.setColor(SystemColor.infoText);
      g2d.drawString(label, 4, getIconHeight()-6);
      
      g2d.setColor(Color.BLACK);
      g2d.drawLine(0, getIconHeight()-1, getIconWidth(), getIconHeight()-1);
    }
    
    public int getIconWidth() {
      return populationPreviweWidth + 6;
    }
    
    public int getIconHeight() {
      return ((3 * populationPreviweWidth) / 4) + 6;
    }
  }
}
