/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

import kandid.pond.ui.IlPool;
import kandid.preference.ui.IlPreference;
import kandid.util.*;

/**
 * Class PoolFrame
 * @author thomas jourdan
 */
public class PopulationFrame extends JFrame implements WindowListener {
  private static final long serialVersionUID = 1L;
  OrganismPanel[] organismPanel;
  BorderLayout    borderLayout1            = new BorderLayout();
  JPanel          populationPanel          = new JPanel();
  JToolBar        toolBar                  = new JToolBar();
  JButton         randomButton             = new JButton();
  JButton         duplicateButton          = new JButton();
  JButton         undoButton               = new JButton();
  JButton         storeButton              = new JButton();
  JButton         cloneButton              = new JButton();
  JButton         environmentButton        = new JButton();
  JButton         sexualReproductionButton = new JButton();
  JToggleButton   logToggleButton          = new JToggleButton();
  JToggleButton   poolToggleButton         = new JToggleButton();
  JButton         preferencesButton        = new JButton();
  JButton         copyleftButton        = new JButton();
  JCheckBox       inheritFormCheckBox      = new JCheckBox();
  JCheckBox       inheritColorCheckBox     = new JCheckBox();

  PopulationController populationController = new PopulationController();

  /**
   * Constructor PoolFrame
   */
  public PopulationFrame() {
    try {
      jbInit();
      addWindowListener(this);
      setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
    }
    catch (Throwable exc) {
      Debug.stackTrace(exc);
    }
  }

  /**
   * Method jbInit
   *
   * @throws Exception
   */
  private void jbInit() throws Exception {
    this.getContentPane().setLayout(borderLayout1);
    randomButton.setMargin(new Insets(0, 0, 0, 0));
    randomButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        randomButton_actionPerformed(e);
      }
    });
    randomButton.setIcon(IconLoader.randomImageIcon);
    randomButton.setToolTipText("generate random next generation");
    duplicateButton.setMargin(new Insets(0, 0, 0, 0));
    duplicateButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        duplicateButton_actionPerformed(e);
      }
    });
    duplicateButton.setIcon(IconLoader.duplicateImageIcon);
    duplicateButton.setToolTipText("duplicate population");
    undoButton.setMargin(new Insets(0, 0, 0, 0));
    undoButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        undoButton_actionPerformed(e);
      }
    });
    undoButton.setIcon(IconLoader.undoImageIcon);
    undoButton.setToolTipText("undo last generation step");

    storeButton.setMargin(new Insets(0, 0, 0, 0));
    storeButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        storeButton_actionPerformed(e);
      }
    });
    storeButton.setIcon(IconLoader.storeImageIcon);
      storeButton.setToolTipText("store population");

    cloneButton.setMargin(new Insets(0, 0, 0, 0));
    cloneButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        cloneButton_actionPerformed(e);
      }
    });
    cloneButton.setIcon(IconLoader.cloneImageIcon);
    cloneButton.setToolTipText("generate next generation with clones");
    environmentButton.setMargin(new Insets(0, 0, 0, 0));
    environmentButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        environmentButton_actionPerformed(e);
      }
    });
    environmentButton.setIcon(IconLoader.environmentImageIcon);
    environmentButton.setToolTipText("edit environment");
    sexualReproductionButton.setIcon(IconLoader.createImageIcon);
    sexualReproductionButton.setMargin(new Insets(0, 0, 0, 0));
    sexualReproductionButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        sexualReproductionButton_actionPerformed(e);
      }
    });
    sexualReproductionButton.setToolTipText("generate next generation with sexual reproduction");
    logToggleButton.setIcon(IconLoader.logImageIcon);
    logToggleButton.setMargin(new Insets(0, 0, 0, 0));
    logToggleButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        logToggleButton_actionPerformed(e);
      }
    });
    logToggleButton.setToolTipText("display logbook");
    
    poolToggleButton.setIcon(IconLoader.poolImageIcon);
    poolToggleButton.setMargin(new Insets(0, 0, 0, 0));
    poolToggleButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        poolToggleButton_actionPerformed(e);
      }
    });
    poolToggleButton.setToolTipText("display gen pool");
    
    preferencesButton.setIcon(IconLoader.preferencesImageIcon);
    preferencesButton.setMargin(new Insets(0, 0, 0, 0));
    preferencesButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        preferencesButton_actionPerformed(e);
      }
    });
    preferencesButton.setToolTipText("edit preferences");
       
    copyleftButton.setIcon(IconLoader.copyleftImageIcon);
    copyleftButton.setMargin(new Insets(0, 0, 0, 0));
    copyleftButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        copyleftButton_actionPerformed(e);
      }
    });
    copyleftButton.setToolTipText("copyright");
    
    inheritFormCheckBox.setText("");
    inheritFormCheckBox.setToolTipText("inherit form");
    inheritFormCheckBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        inheritFormCheckBox_actionPerformed(e);
      }
    });
    inheritFormCheckBox.setFont(new java.awt.Font("Dialog", 0, 9));

    inheritColorCheckBox.setText("");
    inheritColorCheckBox.setToolTipText("inherit color");
    inheritColorCheckBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        inheritColorCheckBox_actionPerformed(e);
      }
    });
    inheritColorCheckBox.setFont(new java.awt.Font("Dialog", 0, 9));

//    JPanel inheritPanel = new JPanel();
////!!    inheritPanel.setLayout(new GridLayout(2, 1, 1, 1));
//    inheritPanel.setLayout(new BorderLayout());
//    inheritPanel.setBackground(Color.ORANGE);
//    inheritPanel.add(inheritFormCheckBox, BorderLayout.NORTH);
//    inheritPanel.add(inheritColorCheckBox, BorderLayout.CENTER);
    
    toolBar.setOrientation(JToolBar.VERTICAL);
//!!    toolBar.setMargin(new Insets(0, 0, 0, 0));
    this.getContentPane().add(populationPanel, BorderLayout.CENTER);
    this.getContentPane().add(toolBar, BorderLayout.WEST);
    toolBar.add(sexualReproductionButton, null);
    toolBar.add(cloneButton, null);
    toolBar.add(randomButton, null);

    toolBar.add(new JToolBar.Separator());
    toolBar.add(inheritFormCheckBox);
    JLabel formLabel = new JLabel("form");
    formLabel.setFont(new java.awt.Font("Dialog", 0, 10));
    toolBar.add(formLabel);

    toolBar.add(new JToolBar.Separator());
    toolBar.add(inheritColorCheckBox);
    JLabel colorLabel = new JLabel("color");
    colorLabel.setFont(new java.awt.Font("Dialog", 0, 10));
    toolBar.add(colorLabel);

    toolBar.add(new JToolBar.Separator());
    toolBar.add(undoButton, null);
    
    toolBar.add(new JToolBar.Separator());
    toolBar.add(environmentButton, null);

    toolBar.add(new JToolBar.Separator());
    toolBar.add(duplicateButton, null);
    toolBar.add(storeButton, null);

    toolBar.add(new JToolBar.Separator());
    toolBar.add(logToggleButton, null);

    toolBar.add(new JToolBar.Separator());
    toolBar.add(poolToggleButton, null);
    toolBar.add(preferencesButton, null);

    toolBar.add(new JToolBar.Separator());
    toolBar.add(copyleftButton, null);
  }

  /**
   * Method setInherit.
   * @param inheritCalculation
   * @param inheritColorator
   */
  public void setInheritCalculation(boolean inheritCalculation, boolean simpleColorator) {
    if(simpleColorator) {
      inheritFormCheckBox.setSelected(true);
      inheritFormCheckBox.setEnabled(false);
    }
    else {
      inheritFormCheckBox.setSelected(inheritCalculation);
      inheritFormCheckBox.setEnabled(true);
    }
  }

  /**
   * Method setInherit.
   * @param inheritCalculation
   * @param inheritColorator
   */
  public void setInheritColorator(boolean inheritColorator, boolean simpleColorator) {
    if(simpleColorator) {
      inheritColorCheckBox.setSelected(true);
      inheritColorCheckBox.setEnabled(false);
    }
    else {
      inheritColorCheckBox.setSelected(inheritColorator);
      inheritColorCheckBox.setEnabled(true);
    }
  }

  /**
   * Method prepare
   *
   * @param typeName
   * @param calculationName
   * @param coloratorName
   * @param nRows
   * @param nCols
   */
  public void prepare(String typeName, String calculationName, String coloratorName, int nRows, int nCols) {
    populationController.prepare(typeName, calculationName, coloratorName, nRows, nCols, this);
  }

  /**
   * Method prepare
   *
   * @param typeName
   * @param calculationName
   * @param coloratorName
   * @param populationName
   */
  public void prepare(String typeName, String populationName) {
//!!    setTitle(typeName + " Population");
    populationController.prepare(typeName, populationName, this);
  }

  /**
   * Method start
   *
   * @param createNew
   */
  public void start(boolean createNew) {
//!!    populationController.start(createNew);
    if (createNew)
      populationController.randomReproduction(createNew);
    else
      populationController.start(createNew);
  }

  /**
   * Method stop
   */
  public void stop() {
    populationController.stop();
  }

  /**
   * Method inheritFormCheckBox_actionPerformed.
   * @param e
   */
  private void inheritFormCheckBox_actionPerformed(ActionEvent e) {
    try {
      populationController.getPopulation().setInheritCalculation(inheritFormCheckBox.isSelected());
    } catch (Throwable exc) {
      Debug.stackTrace(exc);
    }
  }


  /**
   * Method inheritColorCheckBox_actionPerformed.
   * @param e
   */
  private void inheritColorCheckBox_actionPerformed(ActionEvent e) {
    try {
      populationController.getPopulation().setInheritColorator(inheritColorCheckBox.isSelected());
    } catch (Throwable exc) {
      Debug.stackTrace(exc);
    }
  }


  /**
   * Method sexualReproductionButton_actionPerformed
   *
   * @param e
   */
  void sexualReproductionButton_actionPerformed(ActionEvent e) {
    try {
      populationController.sexualReproduction();
    } catch (Throwable exc) {
      Debug.stackTrace(exc);
    }
  }

  /**
   * Method cloneButton_actionPerformed
   *
   * @param e
   */
  void cloneButton_actionPerformed(ActionEvent e) {
    try {
      populationController.cloneReproduction();
    } catch (Throwable exc) {
      Debug.stackTrace(exc);
    }
  }

  /**
   * Method environmentButton_actionPerformed
   *
   * @param e
   */
  void environmentButton_actionPerformed(ActionEvent e) {
    try {
      populationController.editEnvironment();
    } catch (Throwable exc) {
      Debug.stackTrace(exc);
    }
  }

  /**
   * Method storeButton_actionPerformed
   *
   * @param e
   */
  void storeButton_actionPerformed(ActionEvent e) {
    try {
      populationController.store();
    } catch (Throwable exc) {
      Debug.stackTrace(exc);
    }
  }

  /**
   * Method undoButton_actionPerformed
   *
   * @param e
   */
  void undoButton_actionPerformed(ActionEvent e) {
    try {
      populationController.undo();
    } catch (Throwable exc) {
      Debug.stackTrace(exc);
    }
  }

  /**
   * Method randomButton_actionPerformed
   *
   * @param e
   */
  void randomButton_actionPerformed(ActionEvent e) {
    try {
      populationController.randomReproduction(false);
    } catch (Throwable exc) {
      Debug.stackTrace(exc);
    }
  }

  /**
   * Method duplicateButton_actionPerformed
   *
   * @param e
   */
  void duplicateButton_actionPerformed(ActionEvent e) {
    try {
      PopulationFrame populationFrame = new PopulationFrame();
      populationFrame.populationController.prepare(populationController, populationFrame);
      populationFrame.pack();
      Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
      populationFrame.setLocation((d.width - populationFrame.getSize().width) / 2, (d.height - populationFrame.getSize().height) / 2);
      populationFrame.setVisible(true);
      populationFrame.start(false);
    } catch (Throwable exc) {
      Debug.stackTrace(exc);
    }
  }

  /**
   * Method logToggleButton_actionPerformed
   *
   * @param e
   */
  void logToggleButton_actionPerformed(ActionEvent e) {
    try {
      Console.setVisible(logToggleButton.isSelected());
    } catch (Throwable exc) {
      Debug.stackTrace(exc);
    }
  }

  /**
   * Method logToggleButton_actionPerformed
   *
   * @param e
   */
  void poolToggleButton_actionPerformed(ActionEvent e) {
    try {
//    PoolController.setVisible(poolToggleButton.isSelected());
      IlPool.getInstance().setVisible(poolToggleButton.isSelected());
//
//      PoolFrame poolFrame = new PoolFrame();
//      poolFrame.pack();
//      poolFrame.show();
    } catch (Throwable exc) {
      Debug.stackTrace(exc);
    }
  }

  /**
   * Method preferencesButton_actionPerformed
   *
   * @param e
   */
  void preferencesButton_actionPerformed(ActionEvent e) {
    IlPreference.showInstance(0, this);
  }

  // implements WindowListener
  public void windowOpened(WindowEvent evt) {
  }
  
  /**
   * Method copyleftButton_actionPerformed
   *
   * @param e
   */
  void copyleftButton_actionPerformed(ActionEvent e) {
    IlCopyleft.showInstance();
  }

  public void windowClosing(WindowEvent evt) {
    Object[] options = {"Store population",
                        "Discard population",
                        "Cancel"};
    int co = JOptionPane.showOptionDialog(this,
                                          "Population will be closed.",
                                          "Kandid",
                                          JOptionPane.YES_NO_CANCEL_OPTION,
                                          JOptionPane.QUESTION_MESSAGE,
                                          null,
                                          options,
                                          options[0]);
    switch(co) {
      case 0:
        storeButton_actionPerformed(null);
        populationController.quit();
        dispose();
        break;
      case 1:
        populationController.quit();
        dispose();
        break;
      default:
        break;
    }
  }
  
  public void windowClosed(WindowEvent evt) {
  }
  
  public void windowIconified(WindowEvent evt) {
  }
  
  public void windowDeiconified(WindowEvent evt) {
  }
  
  public void windowActivated(WindowEvent evt) {
    populationController.windowActivated();
  }
  
  public void windowDeactivated(WindowEvent evt) {
  }

}

