/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import kandid.catalog.*;
import kandid.util.Debug;

public class IntroWizard extends javax.swing.JPanel {
  private static final long serialVersionUID = 1L;

  private static ImageIcon openImageIcon;
  private static ImageIcon rewindImageIcon;
  
  private CatalogType catalog;
  private String typeName = "";
  private String calculationName = "";
  private String coloratorName = "";
  private int nofColorators = 0;
  private int nRows = 3;
  private int nCols = 4;
  private JButton[][] typeButton;

  /** Creates new form IntroWizard */
  public IntroWizard() throws JAXBException {
    initComponents();

    JAXBContext jc = JAXBContext.newInstance("kandid.catalog");
    Unmarshaller u = jc.createUnmarshaller();
    javax.xml.bind.JAXBElement uo = (JAXBElement) u.unmarshal(getClass().getResourceAsStream("/kandid/catalog/catalog.xml"));
    catalog = (kandid.catalog.CatalogType) uo.getValue();
    int gridRows = catalog.getGridRows();
    int gridCols = catalog.getGridCols();
    java.util.List<CalculationType> calculationList = catalog.getCalculation();
    typeButton = new JButton[gridRows][gridCols];

    GridBagConstraints gridBagConstraintsH1 = new GridBagConstraints();
    gridBagConstraintsH1.anchor = GridBagConstraints.EAST;
    gridBagConstraintsH1.gridx = 0;
    gridBagConstraintsH1.gridy = 0;
    gridBagConstraintsH1.gridwidth = 4;
    step1Panel.add(new JLabel(new javax.swing.ImageIcon(getClass().getResource("/img/hline.png"))), gridBagConstraintsH1);
    GridBagConstraints gridBagConstraintsH2 = new GridBagConstraints();
    gridBagConstraintsH2.anchor = GridBagConstraints.EAST;
    gridBagConstraintsH2.gridx = 0;
    gridBagConstraintsH2.gridy = 5;
    gridBagConstraintsH2.gridwidth = 4;
    step1Panel.add(new JLabel(new javax.swing.ImageIcon(getClass().getResource("/img/hline.png"))), gridBagConstraintsH2);
    GridBagConstraints gridBagConstraintsH3 = new GridBagConstraints();
    gridBagConstraintsH3.anchor = GridBagConstraints.EAST;
    gridBagConstraintsH3.gridx = 0;
    gridBagConstraintsH3.gridy = 8;
    gridBagConstraintsH3.gridwidth = 4;
    step1Panel.add(new JLabel(new javax.swing.ImageIcon(getClass().getResource("/img/hline.png"))), gridBagConstraintsH3);

    GridBagConstraints gridBagConstraintsL1 = new GridBagConstraints();
    gridBagConstraintsL1.anchor = GridBagConstraints.NORTHEAST;
    gridBagConstraintsL1.gridx = 0;
    gridBagConstraintsL1.gridy = 1;
    gridBagConstraintsL1.gridheight = 4;
    step1Panel.add(new JLabel(new javax.swing.ImageIcon(getClass().getResource("/img/evolvParameter.png"))), gridBagConstraintsL1);
    GridBagConstraints gridBagConstraintsL2 = new GridBagConstraints();
    gridBagConstraintsL2.anchor = GridBagConstraints.NORTHEAST;
    gridBagConstraintsL2.gridx = 0;
    gridBagConstraintsL2.gridy = 6;
    gridBagConstraintsL2.gridheight = 2;
    step1Panel.add(new JLabel(new javax.swing.ImageIcon(getClass().getResource("/img/evolvCode.png"))), gridBagConstraintsL2);
    GridBagConstraints gridBagConstraintsL3 = new GridBagConstraints();
    gridBagConstraintsL3.anchor = GridBagConstraints.NORTHEAST;
    gridBagConstraintsL3.gridx = 0;
    gridBagConstraintsL3.gridy = 9;
    gridBagConstraintsL3.gridheight = 2;
    step1Panel.add(new JLabel(new javax.swing.ImageIcon(getClass().getResource("/img/evolvExternals.png"))), gridBagConstraintsL3);

    for (Iterator<CalculationType> iter = calculationList.iterator(); iter.hasNext();) {
      CalculationType type = iter.next();
      int xPos = type.getIcon().getGridX();
      int yPos = type.getIcon().getGridY();
      typeButton[yPos][xPos] = new javax.swing.JButton();
      typeButton[yPos][xPos].setActionCommand(type.getName());
      typeButton[yPos][xPos].setToolTipText(type.getTooltip());
      typeButton[yPos][xPos].setIcon(new javax.swing.ImageIcon(getClass().getResource(type.getIcon().getUrl())));
      typeButton[yPos][xPos].addActionListener(new TypeSelect());
      GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
      gridBagConstraints1.gridx = xPos + 1;
      if(yPos < 4) {
        gridBagConstraints1.gridy = yPos + 1;
      }
      else if(yPos < 6) {
        gridBagConstraints1.gridy = yPos + 2;
      }
      else {
        gridBagConstraints1.gridy = yPos + 3;
      }
      gridBagConstraints1.gridheight = 1;
      gridBagConstraints1.gridwidth = 1;
      step1Panel.add(typeButton[yPos][xPos], gridBagConstraints1);
    }
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  private void initComponents() { //GEN-BEGIN:initComponents
    controlPanel = new javax.swing.JPanel();
    rewindButton = new javax.swing.JButton();
    choicePanel = new javax.swing.JPanel();
    card1Panel = new javax.swing.JPanel();
    headline1Panel = new javax.swing.JPanel();
    //    step1Label = new javax.swing.JLabel();
    //    text1Label = new javax.swing.JLabel();
    step1Panel = new javax.swing.JPanel();
    card4Panel = new javax.swing.JPanel();
    headline4Panel = new javax.swing.JPanel();
    //    step4Label = new javax.swing.JLabel();
    //    text4Label = new javax.swing.JLabel();
    step4Panel = new javax.swing.JPanel();
    newButton = new javax.swing.JButton();
    existingButton = new javax.swing.JButton();
    card2Panel = new javax.swing.JPanel();
    headline2Panel = new javax.swing.JPanel();
    //    step2Label = new javax.swing.JLabel();
    //    text2Label = new javax.swing.JLabel();
    step2Panel = new javax.swing.JPanel();
    bwButton = new javax.swing.JButton();
    grayButton = new javax.swing.JButton();
    rgbButton = new javax.swing.JButton();
    lutButton = new javax.swing.JButton();
    gradButton = new javax.swing.JButton();
    hsbButton = new javax.swing.JButton();
    transLutButton = new javax.swing.JButton();
    card3Panel = new javax.swing.JPanel();
    headline3Panel = new javax.swing.JPanel();
    //    step3Label = new javax.swing.JLabel();
    //    text3Label = new javax.swing.JLabel();
    step3Panel = new javax.swing.JPanel();
    pop10x7Button = new javax.swing.JButton();
    pop4x3Button = new javax.swing.JButton();
    pop6x4Button = new javax.swing.JButton();
    pop8x5Button = new javax.swing.JButton();
    card5Panel = new javax.swing.JPanel();
    headline5Panel = new javax.swing.JPanel();
    //    step5Label = new javax.swing.JLabel();
    //    text5Label = new javax.swing.JLabel();
    step5Panel = new javax.swing.JPanel();
    loadButton = new javax.swing.JButton();
    jScrollPane1 = new javax.swing.JScrollPane();
    loadList = new javax.swing.JList();
    newFilterCheckBox = new JCheckBox();

    setLayout(new java.awt.BorderLayout());

    controlPanel.setLayout(new java.awt.BorderLayout());

    if (rewindImageIcon == null)
      rewindImageIcon = Kandid.getInstance().createImageIcon("rewind.png", null);
    rewindButton.setIcon(rewindImageIcon);
    rewindButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        backButtonActionPerformed(evt);
      }
    });

    controlPanel.add(rewindButton, java.awt.BorderLayout.EAST);

    add(controlPanel, java.awt.BorderLayout.SOUTH);

    choicePanel.setLayout(new java.awt.CardLayout());

    card1Panel.setLayout(new java.awt.BorderLayout());

    //    headline1Panel.setLayout(new java.awt.GridLayout(2, 1));

    headline1Panel.add(new JLabel(new javax.swing.ImageIcon(getClass().getResource("/img/step1.png"))));
    //    step1Label.setText("<html><b>&nbsp;&nbsp;&nbsp;Step 1</b></html>");
    //    headline1Panel.add(step1Label);
    //
    //    text1Label.setText("<html><b>&nbsp;&nbsp;&nbsp;Select type of population.</b></html>");
    //    headline1Panel.add(text1Label);

    card1Panel.add(headline1Panel, java.awt.BorderLayout.NORTH);

    step1Panel.setLayout(new java.awt.GridBagLayout());

    card1Panel.add(step1Panel, java.awt.BorderLayout.CENTER);

    choicePanel.add(card1Panel, "card1");

    card4Panel.setLayout(new java.awt.BorderLayout());

    //    headline4Panel.setLayout(new java.awt.GridLayout(2, 1));

    headline4Panel.add(new JLabel(new javax.swing.ImageIcon(getClass().getResource("/img/step2.png"))));
    //    step4Label.setText("<html><b>&nbsp;&nbsp;&nbsp;Step 2</b></html>");
    //    headline4Panel.add(step4Label);
    //
    //    text4Label.setText("<html><b>&nbsp;&nbsp;&nbsp;Start a new population or load an existing one.</b></html>");
    //    headline4Panel.add(text4Label);

    card4Panel.add(headline4Panel, java.awt.BorderLayout.NORTH);

    step4Panel.setLayout(new java.awt.GridBagLayout());
    java.awt.GridBagConstraints gridBagConstraints2;

    newButton.setText("<html>New Population</html>");
    newButton.setToolTipText("start with a new population");
    newButton.setMaximumSize(new java.awt.Dimension(98, 74));
    newButton.setMinimumSize(new java.awt.Dimension(98, 74));
    newButton.setPreferredSize(new java.awt.Dimension(98, 74));
    newButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        newButtonActionPerformed(evt);
      }
    });

    gridBagConstraints2 = new java.awt.GridBagConstraints();
    gridBagConstraints2.gridx = 0;
    gridBagConstraints2.gridy = 0;
    gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
    step4Panel.add(newButton, gridBagConstraints2);

    existingButton.setText("<html>Open existing population</html>");
    existingButton.setToolTipText("load existing population");
    existingButton.setMaximumSize(new java.awt.Dimension(98, 74));
    existingButton.setMinimumSize(new java.awt.Dimension(98, 74));
    existingButton.setPreferredSize(new java.awt.Dimension(98, 74));
    existingButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        existingButtonActionPerformed(evt);
      }
    });

    gridBagConstraints2 = new java.awt.GridBagConstraints();
    gridBagConstraints2.gridx = 0;
    gridBagConstraints2.gridy = 1;
    gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
    step4Panel.add(existingButton, gridBagConstraints2);

    card4Panel.add(step4Panel, java.awt.BorderLayout.CENTER);

    choicePanel.add(card4Panel, "card4");

    card2Panel.setLayout(new java.awt.BorderLayout());

    //    headline2Panel.setLayout(new java.awt.GridLayout(2, 1));

    headline2Panel.add(new JLabel(new javax.swing.ImageIcon(getClass().getResource("/img/step3.png"))));
    //    step2Label.setText("<html><b>&nbsp;&nbsp;&nbsp;Step 3</b></html>");
    //    headline2Panel.add(step2Label);
    //
    //    text2Label.setText("<html><b>&nbsp;&nbsp;&nbsp;Select color model.</b></html>");
    //    headline2Panel.add(text2Label);

    card2Panel.add(headline2Panel, java.awt.BorderLayout.NORTH);

    step2Panel.setLayout(new java.awt.GridBagLayout());
    java.awt.GridBagConstraints gridBagConstraints3;

    bwButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/bwColorator.png")));
    bwButton.setToolTipText("black and white");
    bwButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        bwButtonActionPerformed(evt);
      }
    });
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 0;
    gridBagConstraints3.gridy = 0;
    gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
    step2Panel.add(bwButton, gridBagConstraints3);

    grayButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/grayColorator.png")));
    grayButton.setToolTipText("gray scale");
    grayButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        grayButtonActionPerformed(evt);
      }
    });
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 1;
    gridBagConstraints3.gridy = 0;
    gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
    step2Panel.add(grayButton, gridBagConstraints3);

    rgbButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/rgbColorator.png")));
    rgbButton.setToolTipText("red, green, blue");
    rgbButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        rgbButtonActionPerformed(evt);
      }
    });
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 2;
    gridBagConstraints3.gridy = 0;
    gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
    step2Panel.add(rgbButton, gridBagConstraints3);

    lutButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/lutColorator.png")));
    lutButton.setToolTipText("look up table");
    lutButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        lutButtonActionPerformed(evt);
      }
    });
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 0;
    gridBagConstraints3.gridy = 1;
    gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
    step2Panel.add(lutButton, gridBagConstraints3);

    gradButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/gradientColorator.png")));
    gradButton.setToolTipText("color gradient");
    gradButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        gradButtonActionPerformed(evt);
      }
    });
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 1;
    gridBagConstraints3.gridy = 1;
    gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
    step2Panel.add(gradButton, gridBagConstraints3);

    hsbButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/hsbColorator.png")));
    hsbButton.setToolTipText("hue, saturation, brightness");
    hsbButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        hsbButtonActionPerformed(evt);
      }
    });
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 2;
    gridBagConstraints3.gridy = 1;
    gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
    step2Panel.add(hsbButton, gridBagConstraints3);

    card2Panel.add(step2Panel, java.awt.BorderLayout.CENTER);

    transLutButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/transparentLutColorator.png")));
    transLutButton.setToolTipText("look up table, transparent");
    transLutButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        transLutButtonActionPerformed(evt);
      }
    });
    gridBagConstraints3 = new java.awt.GridBagConstraints();
    gridBagConstraints3.gridx = 0;
    gridBagConstraints3.gridy = 2;
    gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
    step2Panel.add(transLutButton, gridBagConstraints3);

    card2Panel.add(step2Panel, java.awt.BorderLayout.CENTER);

    choicePanel.add(card2Panel, "card2");

    card3Panel.setLayout(new java.awt.BorderLayout());

    //    headline3Panel.setLayout(new java.awt.GridLayout(2, 1));

    headline3Panel.add(new JLabel(new javax.swing.ImageIcon(getClass().getResource("/img/step4.png"))));
    //    step3Label.setText("<html><b>&nbsp;&nbsp;&nbsp;Step 4</b></html>");
    //    headline3Panel.add(step3Label);
    //
    //    text3Label.setText("<html><b>&nbsp;&nbsp;&nbsp;Select size of population.</b></html>");
    //    headline3Panel.add(text3Label);

    card3Panel.add(headline3Panel, java.awt.BorderLayout.NORTH);

    step3Panel.setLayout(new java.awt.GridBagLayout());
    java.awt.GridBagConstraints gridBagConstraints4;

    pop10x7Button.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/square.png")));
    pop10x7Button.setText("<html><center><b>10x7</b></center></html>");
    pop10x7Button.setToolTipText("population with 70 images, needs 1280x960 screen resolution");
    pop10x7Button.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
    pop10x7Button.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        pop10x7ButtonActionPerformed(evt);
      }
    });

    gridBagConstraints4 = new java.awt.GridBagConstraints();
    gridBagConstraints4.gridx = 3;
    gridBagConstraints4.gridy = 0;
    gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
    step3Panel.add(pop10x7Button, gridBagConstraints4);

    pop4x3Button.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/square.png")));
    pop4x3Button.setText("<html><center><b>4x3</b></center></html>");
    pop4x3Button.setToolTipText("population with 12 images");
    pop4x3Button.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
    pop4x3Button.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        pop4x3ButtonActionPerformed(evt);
      }
    });

    gridBagConstraints4 = new java.awt.GridBagConstraints();
    gridBagConstraints4.gridx = 0;
    gridBagConstraints4.gridy = 0;
    gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
    step3Panel.add(pop4x3Button, gridBagConstraints4);

    pop6x4Button.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/square.png")));
    pop6x4Button.setText("<html><center><b>6x4</b></center></html>");
    pop6x4Button.setToolTipText("population with 24 images");
    pop6x4Button.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
    pop6x4Button.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        pop6x4ButtonActionPerformed(evt);
      }
    });

    gridBagConstraints4 = new java.awt.GridBagConstraints();
    gridBagConstraints4.gridx = 1;
    gridBagConstraints4.gridy = 0;
    gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
    step3Panel.add(pop6x4Button, gridBagConstraints4);

    pop8x5Button.setIcon(new javax.swing.ImageIcon(getClass().getResource("/img/square.png")));
    pop8x5Button.setText("<html><center><b>8x5</b></center></html>");
    pop8x5Button.setToolTipText("population with 40 images, needs 1024x768 screen resolution");
    pop8x5Button.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
    pop8x5Button.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        pop8x5ButtonActionPerformed(evt);
      }
    });

    gridBagConstraints4 = new java.awt.GridBagConstraints();
    gridBagConstraints4.gridx = 2;
    gridBagConstraints4.gridy = 0;
    gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
    step3Panel.add(pop8x5Button, gridBagConstraints4);

    card3Panel.add(step3Panel, java.awt.BorderLayout.CENTER);

    choicePanel.add(card3Panel, "card3");

    card5Panel.setLayout(new java.awt.BorderLayout());

    //    headline5Panel.setLayout(new java.awt.GridLayout(2, 1));

    headline5Panel.add(new JLabel(new javax.swing.ImageIcon(getClass().getResource("/img/step3load.png"))));
    //    step5Label.setText("<html><b>&nbsp;&nbsp;&nbsp;Step 3</b></html>");
    //    headline5Panel.add(step5Label);
    //
    //    text5Label.setText("<html><b>&nbsp;&nbsp;&nbsp;Select population.</b></html>");
    //    headline5Panel.add(text5Label);

    card5Panel.add(headline5Panel, java.awt.BorderLayout.NORTH);

    step5Panel.setLayout(new java.awt.GridBagLayout());
    java.awt.GridBagConstraints gridBagConstraints5;

    if (openImageIcon == null)
      openImageIcon = Kandid.getInstance().createImageIcon("open.png", null);
    loadButton.setIcon(openImageIcon);
    loadButton.setText("Open");
    loadButton.setEnabled(false);
    loadButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        loadButtonActionPerformed(evt);
      }
    });

    gridBagConstraints5 = new java.awt.GridBagConstraints();
    gridBagConstraints5.gridx = 3;
    gridBagConstraints5.gridy = 5;
    gridBagConstraints5.anchor = java.awt.GridBagConstraints.EAST;
    step5Panel.add(loadButton, gridBagConstraints5);

    newFilterCheckBox.setText("Only new versions");
    newFilterCheckBox.setSelected(true);
    newFilterCheckBox.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        newFilterCheckBoxActionPerformed(evt);
      }
    });

    gridBagConstraints5 = new java.awt.GridBagConstraints();
    gridBagConstraints5.gridx = 1;
    gridBagConstraints5.gridy = 5;
    gridBagConstraints5.anchor = java.awt.GridBagConstraints.EAST;
    step5Panel.add(newFilterCheckBox, gridBagConstraints5);

    jScrollPane1.setVerticalScrollBarPolicy(javax.swing.JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
    jScrollPane1.setMinimumSize(new java.awt.Dimension(455, 550));
    jScrollPane1.setPreferredSize(new java.awt.Dimension(455, 550));
    loadList.setFont(new java.awt.Font("Dialog", 0, 12));
    loadList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
      public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
        loadListValueChanged(evt);
      }
    });

    loadList.addMouseListener(new java.awt.event.MouseAdapter() {
      public void mouseClicked(java.awt.event.MouseEvent evt) {
        loadListMouseClicked(evt);
      }
    });

    jScrollPane1.setViewportView(loadList);

    gridBagConstraints5 = new java.awt.GridBagConstraints();
    gridBagConstraints5.gridx = 0;
    gridBagConstraints5.gridy = 0;
    gridBagConstraints5.gridwidth = java.awt.GridBagConstraints.REMAINDER;
    gridBagConstraints5.gridheight = 5;
    gridBagConstraints5.fill = java.awt.GridBagConstraints.BOTH;
    step5Panel.add(jScrollPane1, gridBagConstraints5);

    card5Panel.add(step5Panel, java.awt.BorderLayout.CENTER);

    choicePanel.add(card5Panel, "card5");

    add(choicePanel, java.awt.BorderLayout.CENTER);

  } //GEN-END:initComponents

  /**
   * @param evt
   */
  private void newFilterCheckBoxActionPerformed(ActionEvent evt) {
    createPreviewList();
  }

  private void loadListValueChanged(javax.swing.event.ListSelectionEvent evt) { //GEN-FIRST:event_loadListValueChanged
    loadButton.setEnabled(loadList.getSelectedValue() != null);
  } //GEN-LAST:event_loadListValueChanged

  private void loadListMouseClicked(java.awt.event.MouseEvent evt) { //GEN-FIRST:event_loadListMouseClicked
  } //GEN-LAST:event_loadListMouseClicked

  private void loadButtonActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_loadButtonActionPerformed
    showPool(false, (String) ((Hashtable)loadList.getSelectedValue()).get("filename"));
  } //GEN-LAST:event_loadButtonActionPerformed

  private void newButtonActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_newButtonActionPerformed
    if (nofColorators == 1) {
      ((java.awt.CardLayout) choicePanel.getLayout()).show(choicePanel, "card3");
    }
    else {
      ((java.awt.CardLayout) choicePanel.getLayout()).show(choicePanel, "card2");
    }
  } //GEN-LAST:event_newButtonActionPerformed

  private void existingButtonActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_existingButtonActionPerformed
     ((java.awt.CardLayout) choicePanel.getLayout()).last(choicePanel);
  } //GEN-LAST:event_existingButtonActionPerformed

  private void bwButtonActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_bwButtonActionPerformed
    coloratorName = "kandid.colorator.BlackWhiteColorator";
    ((java.awt.CardLayout) choicePanel.getLayout()).next(choicePanel);
  } //GEN-LAST:event_bwButtonActionPerformed

  private void grayButtonActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_grayButtonActionPerformed
    coloratorName = "kandid.colorator.GrayColorator";
    ((java.awt.CardLayout) choicePanel.getLayout()).next(choicePanel);
  } //GEN-LAST:event_grayButtonActionPerformed

  private void rgbButtonActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_rgbButtonActionPerformed
    coloratorName = "kandid.colorator.RGBColorator";
    ((java.awt.CardLayout) choicePanel.getLayout()).next(choicePanel);
  } //GEN-LAST:event_rgbButtonActionPerformed

  private void lutButtonActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_rgbButtonActionPerformed
    coloratorName = "kandid.colorator.LookUpTableColorator";
    ((java.awt.CardLayout) choicePanel.getLayout()).next(choicePanel);
  } //GEN-LAST:event_rgbButtonActionPerformed

  private void gradButtonActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_rgbButtonActionPerformed
    coloratorName = "kandid.colorator.GradientColorator";
    ((java.awt.CardLayout) choicePanel.getLayout()).next(choicePanel);
  } //GEN-LAST:event_rgbButtonActionPerformed

  private void hsbButtonActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_rgbButtonActionPerformed
    coloratorName = "kandid.colorator.HsbFrequenceColorator";
    ((java.awt.CardLayout) choicePanel.getLayout()).next(choicePanel);
  } //GEN-LAST:event_rgbButtonActionPerformed

  private void transLutButtonActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_rgbButtonActionPerformed
    coloratorName = "kandid.colorator.TransparentLookUpTableColorator";
    ((java.awt.CardLayout) choicePanel.getLayout()).next(choicePanel);
  } //GEN-LAST:event_rgbButtonActionPerformed

  private void pop10x7ButtonActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_pop10x7ButtonActionPerformed
    nRows = 7;
    nCols = 10;
    showPool(true, null);
  } //GEN-LAST:event_pop10x7ButtonActionPerformed

  private void pop4x3ButtonActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_pop4x3ButtonActionPerformed
    nRows = 3;
    nCols = 4;
    showPool(true, null);
  } //GEN-LAST:event_pop4x3ButtonActionPerformed

  private void pop6x4ButtonActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_pop6x4ButtonActionPerformed
    nRows = 4;
    nCols = 6;
    showPool(true, null);
  } //GEN-LAST:event_pop6x4ButtonActionPerformed

  private void pop8x5ButtonActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_pop8x5ButtonActionPerformed
    nRows = 5;
    nCols = 8;
    showPool(true, null);
  } //GEN-LAST:event_pop8x5ButtonActionPerformed

  private void backButtonActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_backButtonActionPerformed
     ((java.awt.CardLayout) choicePanel.getLayout()).first(choicePanel);
  } //GEN-LAST:event_backButtonActionPerformed

  //!!  public void typeSelectPerformed(java.awt.event.ActionEvent evt) {
  //!!  }

  /**
   * Method showPool
   *
   * @param createNew
   * @param populationName
   */
  void showPool(boolean createNew, String populationFileName) {
    try {
      ((java.awt.CardLayout) choicePanel.getLayout()).first(choicePanel);
      PopulationFrame populationFrame = new PopulationFrame();
      if (createNew) {
        mapCalculation();
        populationFrame.prepare(typeName, calculationName, coloratorName, nRows, nCols);
      }
      else {
        populationFrame.prepare(typeName, populationFileName);
      }
      populationFrame.pack();
      Dimension d = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
      populationFrame.setLocation(
        (d.width - populationFrame.getSize().width) / 2,
        (d.height - populationFrame.getSize().height) / 2);
      populationFrame.setVisible(true);
      populationFrame.start(createNew);
//      // TODO GUI first
//      try {
//        Thread.sleep(1000);
//      }
//      catch (InterruptedException exc) {
//      }
//      populationFrame.repaint();
    }
    catch (Throwable exc) {
      Debug.stackTrace(exc);
    }
  }

  /**
   * Method mapCalculation.
   */
  private void mapCalculation() {
    java.util.List calculationList = catalog.getCalculation();
    for (Iterator iterCalculation = calculationList.iterator(); iterCalculation.hasNext();) {
      CalculationType calculation = (CalculationType) iterCalculation.next();
      if (calculation.getName().equals(typeName)) {
        java.util.List modelList = calculation.getModel();
        for (Iterator iterModel = modelList.iterator(); iterModel.hasNext();) {
          ModelType model = (ModelType) iterModel.next();
          if (coloratorName.equals(model.getColoratorClass())) {
            calculationName = model.getCalculationClass();
            break;
          }
        }
      }
    }
  }

  private class TypeSelect implements ActionListener {

    /**
     * @see java.awt.event.ActionListener#actionPerformed(ActionEvent)
     */
    public void actionPerformed(ActionEvent evt) {
      typeName = evt.getActionCommand();
      nofColorators = 0;
      java.util.List calculationList = catalog.getCalculation();
      for (Iterator iterCalculation = calculationList.iterator(); iterCalculation.hasNext();) {
        CalculationType calculation = (CalculationType) iterCalculation.next();
        if (calculation.getName().equals(typeName)) {
          bwButton.setEnabled(false);
          grayButton.setEnabled(false);
          rgbButton.setEnabled(false);
          lutButton.setEnabled(false);
          gradButton.setEnabled(false);
          hsbButton.setEnabled(false);
          transLutButton.setEnabled(false);
          java.util.List modelList = calculation.getModel();
          for (Iterator iterModel = modelList.iterator(); iterModel.hasNext();) {
            ModelType model = (ModelType) iterModel.next();
            if (model.getColoratorClass().equals("kandid.colorator.BlackWhiteColorator")) {
              bwButton.setEnabled(true);
              coloratorName = model.getColoratorClass();
              ++nofColorators;
            }
            else if (model.getColoratorClass().equals("kandid.colorator.GrayColorator")) {
              grayButton.setEnabled(true);
              coloratorName = model.getColoratorClass();
              ++nofColorators;
            }
            else if (model.getColoratorClass().equals("kandid.colorator.RGBColorator")) {
              rgbButton.setEnabled(true);
              coloratorName = model.getColoratorClass();
              ++nofColorators;
            }
            else if (model.getColoratorClass().equals("kandid.colorator.LookUpTableColorator")) {
              lutButton.setEnabled(true);
              coloratorName = model.getColoratorClass();
              ++nofColorators;
            }
            else if (model.getColoratorClass().equals("kandid.colorator.GradientColorator")) {
              gradButton.setEnabled(true);
              coloratorName = model.getColoratorClass();
              ++nofColorators;
            }
            else if (model.getColoratorClass().equals("kandid.colorator.HsbFrequenceColorator")) {
              hsbButton.setEnabled(true);
              coloratorName = model.getColoratorClass();
              ++nofColorators;
            }
            else if (model.getColoratorClass().equals("kandid.colorator.TransparentLookUpTableColorator")) {
              transLutButton.setEnabled(true);
              coloratorName = model.getColoratorClass();
              ++nofColorators;
            }
          }
          break;
        }
      }
      JList previewList = createPreviewList();
      if (previewList != null) {
        ((java.awt.CardLayout) choicePanel.getLayout()).next(choicePanel);
      }
      else {
        loadList.setListData(new String[0]);
        if (nofColorators == 1) {
          ((java.awt.CardLayout) choicePanel.getLayout()).show(choicePanel, "card3");
        }
        else {
          ((java.awt.CardLayout) choicePanel.getLayout()).show(choicePanel, "card2");
        }
      }
    }
  }

  private JList createPreviewList() {
    JList previewList = null;
    ArrayList  fileList = kandid.extensions.FileList.createImageList("./filebase", typeName, ".kpop");
    boolean useFilter = newFilterCheckBox.isSelected();
    if (fileList != null && fileList.size() > 0) {
      if(useFilter && fileList.size() > 1) {
        ArrayList  reducedList =new ArrayList();
        reducedList.add(fileList.get(0));
        int ix = 1;
        while(ix < fileList.size()) {
          if(isDifferent(fileList.get(ix), reducedList.get(reducedList.size()-1))) {
            reducedList.add(fileList.get(ix));
          }
          ++ix;
        }
        fileList = reducedList;
      }
      return PopulationPreview.createPreviewList(loadList, fileList);
    }
    return previewList;
  }
  
  private boolean isDifferent(Object pattern1, Object pattern2)
  {
    try {
      String s1 = (String)pattern1;
      String p1 = s1.substring(0, s1.lastIndexOf('_'));
      String s2 = (String)pattern2;
      String p2 = s2.substring(0, s2.lastIndexOf('_'));
      return !p1.equals(p2);
    } catch (Exception exc) {
      Debug.stackTrace(exc);
    }
    return true;
  }
  
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JPanel controlPanel;
  private javax.swing.JButton rewindButton;
  private javax.swing.JPanel choicePanel;
  private javax.swing.JPanel card1Panel;
  private javax.swing.JPanel headline1Panel;
  //  private javax.swing.JLabel step1Label;
  //  private javax.swing.JLabel text1Label;
  private javax.swing.JPanel step1Panel;
  private javax.swing.JPanel card4Panel;
  private javax.swing.JPanel headline4Panel;
  //  private javax.swing.JLabel step4Label;
  //  private javax.swing.JLabel text4Label;
  private javax.swing.JPanel step4Panel;
  private javax.swing.JButton newButton;
  private javax.swing.JButton existingButton;
  private javax.swing.JPanel card2Panel;
  private javax.swing.JPanel headline2Panel;
  //  private javax.swing.JLabel step2Label;
  //  private javax.swing.JLabel text2Label;
  private javax.swing.JPanel step2Panel;
  private javax.swing.JButton bwButton;
  private javax.swing.JButton grayButton;
  private javax.swing.JButton rgbButton;
  private javax.swing.JButton lutButton;
  private javax.swing.JButton gradButton;
  private javax.swing.JButton hsbButton;
  private javax.swing.JButton transLutButton;
  private javax.swing.JPanel card3Panel;
  private javax.swing.JPanel headline3Panel;
  //  private javax.swing.JLabel step3Label;
  //  private javax.swing.JLabel text3Label;
  private javax.swing.JPanel step3Panel;
  private javax.swing.JButton pop10x7Button;
  private javax.swing.JButton pop4x3Button;
  private javax.swing.JButton pop6x4Button;
  private javax.swing.JButton pop8x5Button;
  private javax.swing.JPanel card5Panel;
  private javax.swing.JPanel headline5Panel;
  //  private javax.swing.JLabel step5Label;
  //  private javax.swing.JLabel text5Label;
  private javax.swing.JPanel step5Panel;
  private javax.swing.JButton loadButton;
  private javax.swing.JScrollPane jScrollPane1;
  private javax.swing.JList loadList;
  private JCheckBox newFilterCheckBox;
  // End of variables declaration//GEN-END:variables

}
