/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid;

import kandid.calculation.*;
import kandid.soup.RatingBase;
import kandid.util.*;

/**
 * Class Fitness
 * @author thomas jourdan
 */
public class Fitness implements Cloneable {
  public boolean best;
  public boolean parent1;
  public boolean parent2;
  public boolean abort;

  /**
   * Method clone
   *
   * @return
   */
  public Object clone() {
    Fitness fitness = null;
    try {
      fitness = (Fitness)super.clone();
    } catch (CloneNotSupportedException exc) {
      Debug.stackTrace(exc);
    }
    return fitness;
  }

  /**
   * Method setRating.
   * @param rating
   */
  public void setRating(RatingBase rating) {
    if(rating.equals(RatingBase.ABORT)) {
      command(Calculation.cmdSetAbort);
    }
    else if(rating.equals(RatingBase.BEST)) {
      command(Calculation.cmdSetBest);
    }
    else if(rating.equals(RatingBase.PARENT_1)) {
      command(Calculation.cmdSetParent1);
    }
    else if(rating.equals(RatingBase.PARENT_2)) {
      command(Calculation.cmdSetParent2);
    }
  }
        
  /**
   * Method command
   *
   * @param cmd
   */
  public void command(int cmd) {
    switch (cmd) {
      case Calculation.cmdSetBest:
        best  = true;
        abort = parent1 = parent2 = false;
        break;
      case Calculation.cmdResetBest:
        best = false;
        break;
      case Calculation.cmdSetAbort:
        abort = true;
        best  = parent1 = parent2 = false;
        break;
      case Calculation.cmdResetAbort:
        abort = false;
        break;
      case Calculation.cmdSetParent1:
        parent1 = true;
        best    = abort = parent2 = false;
        break;
      case Calculation.cmdResetParent1:
        parent1 = false;
        break;
      case Calculation.cmdSetParent2:
        parent2 = true;
        best    = abort = parent1 = false;
        break;
      case Calculation.cmdResetParent2:
        parent2 = false;
        break;
      case Calculation.cmdResetParent:
        best = parent1 = parent2 = false;
        break;
      default:
        if(Debug.enabled) assert false: "can't process command " + cmd;
    }
  }

  /**
   * Method paramString
   *
   * @return
   */
  protected String paramString() {
    return " best=" + best + " abort=" + abort + " parent1=" + parent1 + " parent2=" + parent2;
  }

  /**
   * Method toString
   *
   * @return
   */
  public String toString() {
    return getClass().getName() + "[" + paramString() + "]";
  }
}

