/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid;

import kandid.util.CentralRandomizer;

public class Environment {
  private double        mutationRate = 0.05;
  private double        mergeRate = 0.1;
  private double        scaleFactor = 0.05;
  private boolean       source1;
  private int           switchCounter;

  /**
   * Returns the mutationRate.
   * @return double
   */
  public double getMutationRate() {
    return mutationRate;
  }

  /**
   * Sets the mutationRate.
   * @param mutationRate The mutationRate to set
   */
  public void setMutationRate(double mutationRate) {
    if(mutationRate > 1.0) {
      mutationRate = 1.0;
    }
    else if(mutationRate < 0.0) {
      mutationRate = 0.0;
    }
    this.mutationRate = mutationRate;
  }

  /**
   * Returns the mergeRate.
   * @return double
   */
  public double getMergeRate() {
    return mergeRate;
  }

  /**
   * Sets the mergeRate.
   * @param mergeRate The mergeRate to set
   */
  public void setMergeRate(double mergeRate) {
    if(mergeRate > 1.0) {
      mergeRate = 1.0;
    }
    else if(mergeRate < 0.0) {
      mergeRate = 0.0;
    }
    this.mergeRate = mergeRate;
  }

  /**
   * Returns the scaleFactor.
   * @return double
   */
  public double getScaleFactor() {
    return scaleFactor;
  }

  /**
   * Sets the scaleFactor.
   * @param scaleFactor The scaleFactor to set
   */
  public void setScaleFactor(double scaleFactor) {
    this.scaleFactor = scaleFactor;
  }

  /**
   * Determines if chromosome 1 or chromosome 2 is the source during merging of two chromosomes.
   * Call this function only once per gene.
   * @return true if genes should be copied from chromosome 1;
   */
  public boolean isSource1() {
    if(CentralRandomizer.getDouble(1.0) < mergeRate) {
      source1 = !source1;
      ++switchCounter;
    }
    return source1;
  }

  /**
   * Determines if chromosome 1 or chromosome 2 is the source during merging of two chromosomes.
   * Use this method while merging lists with different size.
   * @return true if genes should be copied from chromosome 1;
   */
  public boolean isSource1(int length1, int length2) {
    if(length1 > length2 && source1) {
    }
    else if(length1 > length2 && !source1) {
      source1 = true;
      ++switchCounter;
    }
    if(length1 < length2 && source1) {
      source1 = false;
      ++switchCounter;
    }
    else if(length1 < length2 && !source1) {
    }
    return source1;
  }

  /**
   * Sets chromosome 1 to be the actual source.
   * This function needs to be called before merging is started.
   * @param source1 The source1 to set
   */
  public void setSource1(boolean source1) {
    this.source1 = source1;
    switchCounter = 0;
  }

  /**
   * Returns how often the source is switch from one chromosome to the other chromosom during merging.
   * @return int
   */
  public int getSwitchCounter() {
    return switchCounter;
  }

}
