/*
 * Simplified version of class org.xnap.gui.ConsolePane
 * 
 *  XNap - A P2P framework and client.
 *
 *  See the file AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//package org.xnap.gui;
package kandid;

import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;

/**
 * This class provides a simple text console that can be used for logging.
 */
public class ConsolePane extends JScrollPane {

  /**
   * 
   */
  private static final long serialVersionUID = 1L;
  private JTextArea jta;
  private boolean crop = true;

  public ConsolePane(boolean crop) {
    this.crop = crop;

    jta = new JTextArea();
    jta.setLineWrap(false);
    jta.setWrapStyleWord(true);
    jta.setCaretColor(java.awt.Color.red);
    jta.setSelectedTextColor(java.awt.Color.red);
    jta.setEditable(false);
    jta.setBorder(new EmptyBorder(5, 5, 5, 5));

    setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
    setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);

    setViewportView(jta);
  }

  public ConsolePane() {
    this(true);
  }

  /**
   * Appends <code>text</code> to the console.
   */
  public void append(String text) {
    jta.append(text);

    if (crop) {
      //remove some lines at the top and leave maxConsoleLines
      int i = jta.getLineCount() - 100;
      if (i > 0) {
        try {
          int endoffset = jta.getLineEndOffset(i);
          jta.replaceRange(null, 0, endoffset);
        } catch (BadLocationException e) {
        }
      }
    }

    jta.setCaretPosition(jta.getDocument().getEndPosition().getOffset() - 1);
  }

  /**
   * Sets the text of the console to <code>newValue</code>.
   */
  public void setText(String newValue) {
    jta.setText(newValue);
  }

}