/*
 * Copyright (C) 2002 - 2025 Thomas Jourdan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package kandid;

import kandid.util.*;

/**
 * Class Console
 * 
 * @author thomas jourdan
 */
public class Console {
  private static ConsoleFrame logFrame;
  private static ConsolePane consolePane;
  private static Object mutex = new Object();

  /**
   * Method init
   */
  private static void init() {
    if (consolePane == null) {
      consolePane = new ConsolePane(true);
      logFrame = new ConsoleFrame(consolePane);
      logFrame.setTitle("Logbook");
      logFrame.pack();
      logFrame.setSize(980, 300);
    }
  }

  /**
   * Method setVisible
   * 
   * @param visible
   */
  public static void setVisible(boolean visible) {
    init();
    logFrame.setVisible(visible);
  }

  /**
   * Method hide
   */
  public static void hide() {
    init();
    logFrame.setVisible(false);
  }

  /**
   * Method clear
   */
  public static void clear() {
    synchronized (mutex) {
      init();
      consolePane.setText("");
    }
  }

  /**
   * Method println
   * 
   * @param msg
   */
  public static void append(String msg) {
    if (Debug.enabled)
      System.out.println(msg);
    synchronized (mutex) {
      init();
      consolePane.append(msg + "\n");
    }
  }

}

