/*
 * Decompiled with CFR 0.152.
 */
package kandid.util;

import java.awt.image.BufferedImage;
import kandid.colorator.ColorF32;
import kandid.colorator.Colorator;

public class Weight {
    private int[][] weight;
    private int xSize;
    private int ySize;
    protected Colorator colorator;

    public Weight(int xs, int ys, Colorator colorator) {
        this.colorator = colorator;
        this.xSize = xs;
        this.ySize = ys;
        this.weight = new int[this.xSize][this.ySize];
    }

    public void inc(int xp, int yp) {
        try {
            int[] nArray = this.weight[xp];
            int n = yp;
            nArray[n] = nArray[n] + 1;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public int at(int xp, int yp) {
        try {
            return this.weight[xp][yp];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
    }

    public int getMax() {
        int max = 0;
        try {
            int dx = 0;
            while (dx < this.xSize) {
                int dy = 0;
                while (dy < this.ySize) {
                    if (this.weight[dx][dy] > max) {
                        max = this.weight[dx][dy];
                    }
                    ++dy;
                }
                ++dx;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return max;
    }

    public void toImage(BufferedImage bufImg) {
        double max = this.getMax();
        ColorF32 cout = new ColorF32();
        try {
            int dx = 0;
            while (dx < this.xSize) {
                int dy = 0;
                while (dy < this.ySize) {
                    this.colorator.getColor((double)this.weight[dx][dy] / max, cout);
                    bufImg.setRGB(dx, dy, ColorF32.toRGB8(cout));
                    ++dy;
                }
                ++dx;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void toImageLog(BufferedImage bufImg, ColorF32[][] bufColorF32Img) {
        double log_max = Math.log(this.getMax());
        try {
            int dx = 0;
            while (dx < this.xSize) {
                int dy = 0;
                while (dy < this.ySize) {
                    int pixelWeight = this.weight[dx][dy];
                    if (pixelWeight <= 0) {
                        bufImg.setRGB(dx, dy, 0);
                    } else {
                        ColorF32 colorF32 = new ColorF32();
                        this.colorator.getColor(Math.log(this.weight[dx][dy]) / log_max, colorF32);
                        bufImg.setRGB(dx, dy, ColorF32.toRGB8(colorF32));
                        ColorF32.copy(colorF32, bufColorF32Img[dy][dx]);
                    }
                    ++dy;
                }
                ++dx;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
    }
}

