/*
 * Decompiled with CFR 0.152.
 */
package kandid.util;

import java.io.CharArrayWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import kandid.util.Debug;

public class Util {
    public static int powerOf2(int exponent) {
        int result = 1;
        while (exponent > 0) {
            result *= 2;
            --exponent;
        }
        return result;
    }

    public static double[] polar2matrix(double in1, double in2, double in3, double in4, double in5, double in6) {
        double[] result = new double[6];
        double grad2rad = Math.PI / 180;
        double i3 = in3;
        double i4 = in4;
        double i5 = in5;
        double i6 = in6;
        result[0] = i5 * Math.cos(Math.PI / 180 * i3);
        result[1] = -i6 * Math.sin(Math.PI / 180 * i4);
        result[2] = i5 * Math.sin(Math.PI / 180 * i3);
        result[3] = i6 * Math.cos(Math.PI / 180 * i4);
        result[4] = in1;
        result[5] = in2;
        return result;
    }

    public static int parseInt(String value) {
        if ((value = value.trim()).startsWith("0x")) {
            return Integer.parseInt(value.substring(2), 16);
        }
        return Integer.parseInt(value, 10);
    }

    public static long parseLong(String value) {
        if ((value = value.trim()).startsWith("0x")) {
            return Long.parseLong(value.substring(2), 16);
        }
        return Long.parseLong(value, 10);
    }

    public static double parseDouble(String value) {
        value = value.trim();
        return Double.parseDouble(value);
    }

    public static boolean parseBoolean(String value) {
        if ((value = value.trim()).startsWith("t")) {
            return true;
        }
        if (value.startsWith("T")) {
            return true;
        }
        return value.startsWith("1");
    }

    public static String toHexString(int value, int minLength) {
        StringBuffer ret = new StringBuffer(Integer.toHexString(value));
        while (ret.length() < minLength) {
            ret.insert(0, '0');
        }
        return ret.toString();
    }

    public static String getNiceTypeName(String typeName) {
        int pos = typeName.lastIndexOf(46);
        if (pos >= 0) {
            return typeName.substring(pos + 1);
        }
        return "";
    }

    public static double step(double p1, double p2) {
        if (p2 > p1) {
            return 1.0;
        }
        return 0.0;
    }

    public static double clamp(double p1) {
        if (p1 < 0.0) {
            return 0.0;
        }
        if (p1 > 1.0) {
            return 1.0;
        }
        return p1;
    }

    public static double bias(double p1, double p2) {
        return Math.pow(Math.abs(p2), Math.log(Math.abs(p1)) / -0.693147181);
    }

    public static String marshalToString(Object model, JAXBContext jc) {
        try {
            CharArrayWriter arrayWriter = new CharArrayWriter();
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal(model, (Writer)arrayWriter);
            arrayWriter.close();
            return arrayWriter.toString();
        }
        catch (JAXBException je) {
            Debug.stackTrace(je);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return "";
    }
}

