/*
 * Decompiled with CFR 0.152.
 */
package kandid.util;

import junit.framework.TestCase;
import kandid.calculation.lsys.LsysD0LCalculationTest;
import kandid.util.NetworkHelper;

public class NetworkHelperTest
extends TestCase {
    public void testConvertToAscii() {
        byte[] bin = new byte[1];
        NetworkHelperTest.assertEquals((String)"00", (String)NetworkHelper.convertToAscii(bin));
        bin = new byte[]{-128};
        NetworkHelperTest.assertEquals((String)"80", (String)NetworkHelper.convertToAscii(bin));
        bin = new byte[]{1};
        NetworkHelperTest.assertEquals((String)"01", (String)NetworkHelper.convertToAscii(bin));
        bin = new byte[]{127};
        NetworkHelperTest.assertEquals((String)"7f", (String)NetworkHelper.convertToAscii(bin));
        bin = new byte[]{-1};
        NetworkHelperTest.assertEquals((String)"ff", (String)NetworkHelper.convertToAscii(bin));
        byte[] byArray = new byte[5];
        byArray[0] = -1;
        byArray[1] = 127;
        byArray[2] = 1;
        byArray[3] = -128;
        bin = byArray;
        NetworkHelperTest.assertEquals((String)"ff7f018000", (String)NetworkHelper.convertToAscii(bin));
    }

    public void testConvertToBinary() {
        byte[] byArray = new byte[5];
        byArray[0] = -1;
        byArray[1] = 127;
        byArray[2] = 1;
        byArray[3] = -128;
        byte[] expextedBin = byArray;
        byte[] calculatedBin = NetworkHelper.convertToBinary("ff7f018000");
        NetworkHelperTest.assertEquals((int)expextedBin.length, (int)calculatedBin.length);
        int ix = 0;
        while (ix < expextedBin.length) {
            NetworkHelperTest.assertEquals((byte)expextedBin[ix], (byte)calculatedBin[ix]);
            ++ix;
        }
    }

    public void testCompress() {
        String[] predecessor = new String[]{"F"};
        String[] successor = new String[]{"FF-[-F+F+F]+[+F-F-F]"};
        String production = LsysD0LCalculationTest.buildProduction("F", predecessor, successor, 2);
        byte[] comp = NetworkHelper.compress(production);
        NetworkHelperTest.assertTrue((comp.length < production.length() ? 1 : 0) != 0);
        NetworkHelperTest.assertEquals((String)production, (String)NetworkHelper.expand(comp));
    }

    public void testSetHTTPProxy() {
        boolean httpEnabled = true;
        String host = "192.168.100.111";
        int port = 3001;
        String nonProxyHosts = "localhost";
        String username = "";
        String password = "";
        NetworkHelper.setHTTPProxy(httpEnabled, host, port, nonProxyHosts, username, password);
        NetworkHelperTest.assertEquals((String)"192.168.100.111", (String)System.getProperties().getProperty("http.proxyHost"));
        NetworkHelperTest.assertEquals((String)"3001", (String)System.getProperties().getProperty("http.proxyPort"));
        NetworkHelperTest.assertEquals((String)"localhost", (String)System.getProperties().getProperty("http.nonProxyHosts"));
        httpEnabled = false;
        host = "";
        port = 80;
        username = "";
        password = "";
        nonProxyHosts = "";
        NetworkHelper.setHTTPProxy(httpEnabled, host, port, nonProxyHosts, username, password);
        NetworkHelperTest.assertEquals(null, (String)System.getProperties().getProperty("http.proxyHost"));
        NetworkHelperTest.assertEquals(null, (String)System.getProperties().getProperty("http.proxyPort"));
        NetworkHelperTest.assertEquals(null, (String)System.getProperties().getProperty("http.nonProxyHosts"));
    }
}

