/*
 * Decompiled with CFR 0.152.
 */
package kandid.util;

public class Complex {
    public double re;
    public double im;

    public Complex(double re, double im) {
        this.re = re;
        this.im = im;
    }

    public boolean equals(Object o) {
        if (o instanceof Complex) {
            Complex x = (Complex)o;
            return x.re == this.re && x.im == this.im;
        }
        return false;
    }

    public static Complex conj(Complex x) {
        return new Complex(x.re, -x.im);
    }

    public static Complex add(Complex x, Complex y) {
        return new Complex(x.re + y.re, x.im + y.im);
    }

    public static Complex add(Complex x, double y) {
        return new Complex(x.re + y, x.im);
    }

    public static Complex add(double x, Complex y) {
        return new Complex(x + y.re, y.im);
    }

    public static Complex subtract(Complex x, Complex y) {
        return new Complex(x.re - y.re, x.im - y.im);
    }

    public static Complex subtract(Complex x, double y) {
        return new Complex(x.re - y, x.im);
    }

    public static Complex subtract(double x, Complex y) {
        return new Complex(x - y.re, -y.im);
    }

    public static Complex multiply(Complex x, Complex y) {
        return new Complex(x.re * y.re - x.im * y.im, x.re * y.im + x.im * y.re);
    }

    public static Complex multiply(Complex x, double y) {
        return new Complex(x.re * y, x.im * y);
    }

    public static Complex multiply(double x, Complex y) {
        return new Complex(x * y.re, x * y.im);
    }

    public static double real(Complex x) {
        return x.re;
    }

    public static double imag(Complex x) {
        return x.im;
    }

    public static double abs(Complex x) {
        return Complex.hypot(x.re, x.im);
    }

    public static double norm(Complex x) {
        return x.re * x.re + x.im * x.im;
    }

    public static double arg(Complex x) {
        return Math.atan2(x.im, x.re);
    }

    public static Complex polar(double r, double t) {
        return new Complex(r * Math.cos(t), r * Math.sin(t));
    }

    public static Complex divide(Complex x, Complex y) {
        double den = Math.abs(y.re) + Math.abs(y.im);
        if (den == 0.0) {
            return new Complex(0.0, 0.0);
        }
        double xrden = x.re / den;
        double xiden = x.im / den;
        double yrden = y.re / den;
        double yiden = y.im / den;
        double nrm = yrden * yrden + yiden * yiden;
        return new Complex((xrden * yrden + xiden * yiden) / nrm, (xiden * yrden - xrden * yiden) / nrm);
    }

    public static Complex divide(double x, Complex y) {
        double den = Complex.norm(y);
        if (den == 0.0) {
            return new Complex(0.0, 0.0);
        }
        return new Complex(x * y.re / den, -(x * y.im) / den);
    }

    public static Complex divide(Complex x, double y) {
        if (y == 0.0) {
            return new Complex(0.0, 0.0);
        }
        return new Complex(x.re / y, x.im / y);
    }

    public static Complex exp(Complex x) {
        double r = Math.exp(x.re);
        return new Complex(r * Math.cos(x.im), r * Math.sin(x.im));
    }

    public static Complex cosh(Complex x) {
        return new Complex(Math.cos(x.im) * Complex.cosh(x.re), Math.sin(x.im) * Complex.sinh(x.re));
    }

    public static Complex sinh(Complex x) {
        return new Complex(Math.cos(x.im) * Complex.sinh(x.re), Math.sin(x.im) * Complex.cosh(x.re));
    }

    public static Complex cos(Complex x) {
        return new Complex(Math.cos(x.re) * Complex.cosh(x.im), -Math.sin(x.re) * Complex.sinh(x.im));
    }

    public static Complex sin(Complex x) {
        return new Complex(Math.sin(x.re) * Complex.cosh(x.im), Math.cos(x.re) * Complex.sinh(x.im));
    }

    public static Complex log(Complex x) {
        double h = Complex.hypot(x.re, x.im);
        if (h <= 0.0) {
            return new Complex(0.0, 0.0);
        }
        return new Complex(Math.log(h), Math.atan2(x.im, x.re));
    }

    public static Complex pow(Complex x, Complex p) {
        double h = Complex.hypot(x.re, x.im);
        if (h <= 0.0) {
            return new Complex(0.0, 0.0);
        }
        double a = Math.atan2(x.im, x.re);
        double lr = Math.pow(h, p.re);
        double li = p.re * a;
        if (p.im != 0.0) {
            lr /= Math.exp(p.im * a);
            li += p.im * Math.log(h);
        }
        return new Complex(lr * Math.cos(li), lr * Math.sin(li));
    }

    public static Complex pow(Complex x, double p) {
        double h = Complex.hypot(x.re, x.im);
        if (h <= 0.0) {
            return new Complex(0.0, 0.0);
        }
        double lr = Math.pow(h, p);
        double a = Math.atan2(x.im, x.re);
        double li = p * a;
        return new Complex(lr * Math.cos(li), lr * Math.sin(li));
    }

    public static Complex sqrt(Complex x) {
        if (x.re == 0.0 && x.im == 0.0) {
            return new Complex(0.0, 0.0);
        }
        double s = Math.sqrt((Math.abs(x.re) + Complex.hypot(x.re, x.im)) * 0.5);
        double d = x.im / s * 0.5;
        if (x.re > 0.0) {
            return new Complex(s, d);
        }
        if (x.im >= 0.0) {
            return new Complex(d, s);
        }
        return new Complex(-d, -s);
    }

    public static Complex pow(Complex x, int p) {
        if (p == 0) {
            return new Complex(1.0, 0.0);
        }
        if (x.re == 0.0 && x.im == 0.0) {
            return new Complex(0.0, 0.0);
        }
        Complex res = new Complex(1.0, 0.0);
        Complex b = x;
        if (p < 0) {
            p = -p;
            b = Complex.divide(1.0, b);
        }
        while (true) {
            if (p % 2 != 0) {
                res = Complex.multiply(res, b);
            }
            if ((p >>= 1) == 0) {
                return res;
            }
            b = Complex.multiply(b, b);
        }
    }

    private static double hypot(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    private static double sinh(double x) {
        return 0.5 * (Math.exp(x) - Math.exp(-x));
    }

    private static double cosh(double x) {
        return 0.5 * (Math.exp(x) + Math.exp(-x));
    }
}

