/*
 * Decompiled with CFR 0.152.
 */
package kandid.util;

import junit.framework.TestCase;
import kandid.util.CentralRandomizer;

public class CentralRandomizerTest
extends TestCase {
    private static final int upperBound = 50;

    public CentralRandomizerTest(String name) {
        super(name);
    }

    public void testGetBinomial() {
        int[] hits = this.binomialRun(0.0);
        CentralRandomizerTest.assertEquals((int)100, (int)hits[0]);
        CentralRandomizerTest.assertEquals((int)0, (int)hits[hits.length - 1]);
        hits = this.binomialRun(0.25);
        CentralRandomizerTest.assertEquals((int)16, (int)hits[11]);
        hits = this.binomialRun(0.5);
        CentralRandomizerTest.assertEquals((int)16, (int)hits[24]);
        hits = this.binomialRun(0.9);
        CentralRandomizerTest.assertEquals((int)22, (int)hits[46]);
        hits = this.binomialRun(1.0);
        CentralRandomizerTest.assertEquals((int)0, (int)hits[0]);
        CentralRandomizerTest.assertEquals((int)100, (int)hits[hits.length - 1]);
    }

    private int[] binomialRun(double probability) {
        System.out.println("binominal, probability " + probability);
        CentralRandomizer.setSeed(1512L);
        int[] hits = new int[51];
        int hx = 0;
        while (hx < hits.length) {
            hits[hx] = 0;
            ++hx;
        }
        int i = 0;
        while (i < 100) {
            int aNumber = CentralRandomizer.getBinomial(50, probability);
            CentralRandomizerTest.assertTrue((aNumber >= 0 ? 1 : 0) != 0);
            CentralRandomizerTest.assertTrue((aNumber <= 50 ? 1 : 0) != 0);
            int n = aNumber;
            hits[n] = hits[n] + 1;
            ++i;
        }
        hx = 0;
        while (hx < hits.length) {
            System.out.print(hx + " " + hits[hx] + " ");
            int sx = 0;
            while (sx < hits[hx]) {
                System.out.print("*");
                ++sx;
            }
            System.out.println();
            ++hx;
        }
        return hits;
    }
}

