/*
 * Decompiled with CFR 0.152.
 */
package kandid.util;

import java.util.Random;

public class CentralRandomizer {
    static Random rnd = new Random();

    public static void setSeed(long seed) {
        rnd.setSeed(seed);
    }

    public static boolean getBoolean() {
        return rnd.nextBoolean();
    }

    public static int getInt(int upperBound) {
        int value = rnd.nextInt(upperBound + 1);
        return value;
    }

    public static int getInt(int lowerBound, int upperBound) {
        if (lowerBound == upperBound) {
            return lowerBound;
        }
        int modulo = upperBound - lowerBound + 1;
        int value = lowerBound + rnd.nextInt(modulo);
        return value;
    }

    public static float getFloat(float upperBound) {
        float value = upperBound * rnd.nextFloat();
        return value;
    }

    public static float getFloat(float lowerBound, float upperBound) {
        float modulo = upperBound - lowerBound;
        float value = lowerBound + modulo * rnd.nextFloat();
        return value;
    }

    public static double getDouble(double upperBound) {
        double value = upperBound * rnd.nextDouble();
        return value;
    }

    public static double getDouble(double lowerBound, double upperBound) {
        double modulo = upperBound - lowerBound;
        double value = lowerBound + modulo * rnd.nextDouble();
        return value;
    }

    public static long getLong() {
        return rnd.nextLong();
    }

    public static double getGaussian() {
        return rnd.nextGaussian();
    }

    public static int getBinomial(int n, double p) {
        int r = 0;
        int i = 0;
        while (i < n) {
            if (rnd.nextDouble() < p) {
                ++r;
            }
            ++i;
        }
        return r;
    }

    public static boolean getBoolean(double probability) {
        return rnd.nextDouble() < probability;
    }
}

