/*
 * Decompiled with CFR 0.152.
 */
package kandid.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class Base64 {
    protected static final byte[] base64Chars = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    protected static final byte[] reverseBase64Chars = new byte[255];

    static {
        int i = 0;
        while (i < reverseBase64Chars.length) {
            Base64.reverseBase64Chars[i] = -1;
            ++i;
        }
        i = 0;
        while (i < base64Chars.length) {
            Base64.reverseBase64Chars[Base64.base64Chars[i]] = i;
            i = (byte)(i + 1);
        }
    }

    private Base64() {
    }

    private static void main(String[] args) {
        int i = 0;
        while (i < args.length) {
            String encoded = Base64.encode(args[i]);
            String decoded = Base64.decode(encoded);
            System.out.println(args[i] + ": " + encoded + " " + Base64.decode(args[i]));
            if (!decoded.equals(args[i])) {
                System.err.println("Encoding then decoding " + args[i] + " does not work. Decoded: '" + decoded + "'");
            }
            ++i;
        }
    }

    public static String encode(String string) {
        return new String(Base64.encode(string.getBytes()));
    }

    public static String encode(String string, String enc) throws UnsupportedEncodingException {
        return new String(Base64.encode(string.getBytes(enc)), enc);
    }

    public static byte[] encode(byte[] bytes) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        int length = bytes.length;
        int mod = length % 3;
        if (mod != 0) {
            length += 3 - mod;
        }
        length = length * 4 / 3;
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        try {
            Base64.encode(in, out, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    public static void encode(InputStream in, OutputStream out, boolean lineBreaks) throws IOException {
        int[] inBuffer = new int[3];
        int lineCount = 0;
        boolean done = false;
        while (!done && (inBuffer[0] = in.read()) != -1) {
            inBuffer[1] = in.read();
            inBuffer[2] = in.read();
            out.write(base64Chars[inBuffer[0] >> 2]);
            if (inBuffer[1] != -1) {
                out.write(base64Chars[inBuffer[0] << 4 & 0x30 | inBuffer[1] >> 4]);
                if (inBuffer[2] != -1) {
                    out.write(base64Chars[inBuffer[1] << 2 & 0x3C | inBuffer[2] >> 6]);
                    out.write(base64Chars[inBuffer[2] & 0x3F]);
                } else {
                    out.write(base64Chars[inBuffer[1] << 2 & 0x3C]);
                    out.write(61);
                    done = true;
                }
            } else {
                out.write(base64Chars[inBuffer[0] << 4 & 0x30]);
                out.write(61);
                out.write(61);
                done = true;
            }
            if (!lineBreaks || (lineCount += 4) < 76) continue;
            out.write(10);
            lineCount = 0;
        }
    }

    public static String decode(String string) {
        return new String(Base64.decode(string.getBytes()));
    }

    public static String decode(String string, String enc) throws UnsupportedEncodingException {
        return new String(Base64.decode(string.getBytes(enc)), enc);
    }

    public static byte[] decode(byte[] bytes) {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        int length = bytes.length;
        int mod = length % 4;
        if (mod != 0) {
            length += 4 - mod;
        }
        length = length * 3 / 4;
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        try {
            Base64.decode(in, out, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    private static final int readBase64(InputStream in, boolean throwExceptions) throws IOException {
        int read;
        do {
            if ((read = in.read()) == -1) {
                return -1;
            }
            if (!throwExceptions || reverseBase64Chars[(byte)read] != -1 || read == 32 || read == 10 || read == 13 || read == 9 || read == 12 || read == 61) continue;
            throw new IOException("Unexpected Base64 character: " + read);
        } while ((read = reverseBase64Chars[(byte)read]) == -1);
        return read;
    }

    public static void decode(InputStream in, OutputStream out, boolean throwExceptions) throws IOException {
        int[] inBuffer = new int[4];
        boolean done = false;
        while (!done && (inBuffer[0] = Base64.readBase64(in, throwExceptions)) != -1 && (inBuffer[1] = Base64.readBase64(in, throwExceptions)) != -1) {
            inBuffer[2] = Base64.readBase64(in, throwExceptions);
            inBuffer[3] = Base64.readBase64(in, throwExceptions);
            out.write(inBuffer[0] << 2 | inBuffer[1] >> 4);
            if (inBuffer[2] != -1) {
                out.write(inBuffer[1] << 4 | inBuffer[2] >> 2);
                if (inBuffer[3] != -1) {
                    out.write(inBuffer[2] << 6 | inBuffer[3]);
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
    }
}

