/*
 * Decompiled with CFR 0.152.
 */
package kandid.tree.user;

import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.tree.TreeCellEditor;
import kandid.tree.editor.TextCellEditor;
import kandid.tree.user.AbstractUserObject;
import kandid.util.Debug;

public class UserText
extends AbstractUserObject {
    public UserText(JLabel label, TreeCellEditor editor, String value, Object dataModel, Method dataSetter) {
        super(label, editor, value, dataModel, dataSetter);
    }

    @Override
    public void setAfterEditing(JComponent source) {
        String newValue = ((JTextField)source).getText();
        if (!this.value.equals(newValue)) {
            try {
                this.sendToModel(this.getInnerText(newValue));
                this.value = newValue;
            }
            catch (Exception exc) {
                Debug.stackTrace(exc);
            }
        }
    }

    @Override
    public JComponent getRenderer() {
        JLabel label = (JLabel)this.renderer;
        if (this.value == null) {
            label.setText("");
        } else {
            label.setText((String)this.value);
        }
        return label;
    }

    @Override
    public TreeCellEditor getEditor() {
        ((TextCellEditor)this.editor).setValue(this.getRenderValue());
        return this.editor;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public String getInnerText(String fullValue) {
        String innerValue = fullValue;
        try {
            int pos = fullValue.indexOf(" = ");
            if (pos >= 0) {
                pos += 2;
            } else if (pos < 0) {
                fullValue.indexOf("=");
            }
            if (pos >= 0) {
                innerValue = fullValue.substring(pos + 1);
            }
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return innerValue.trim();
    }
}

