/*
 * Decompiled with CFR 0.152.
 */
package kandid.tree.renderer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import kandid.tree.user.AbstractUserObject;
import kandid.tree.user.UserTreeNode;

public class UserNodeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    protected JComponent renderer;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (!(value instanceof UserTreeNode)) {
            return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        UserTreeNode node = (UserTreeNode)value;
        AbstractUserObject userObject = (AbstractUserObject)node.getUser();
        this.renderer = node.getUser().getRenderer();
        if (selected) {
            if (!this.renderer.isOpaque()) {
                this.renderer.setOpaque(true);
            }
            this.renderer.setForeground(this.getTextSelectionColor());
            this.renderer.setBackground(this.getBackgroundSelectionColor());
        } else {
            this.renderer.setForeground(this.getTextNonSelectionColor());
            Color backgroundColor = userObject.getBackgroundColor();
            this.renderer.setBackground(backgroundColor == null ? this.getBackgroundNonSelectionColor() : backgroundColor);
        }
        return this.renderer;
    }
}

