/*
 * Decompiled with CFR 0.152.
 */
package kandid.tree.editor;

import java.awt.Component;
import java.awt.Font;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import kandid.tree.user.UserObject;
import kandid.tree.user.UserTreeNode;

public class UserNodeEditor
extends DefaultTreeCellEditor {
    UserObject user;
    CellEditorListener[] listeners = null;

    public UserNodeEditor(JTree tree, DefaultTreeCellRenderer renderer, TreeCellEditor editor) {
        super(tree, renderer, editor);
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        if (!(value instanceof UserTreeNode)) {
            return super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        }
        UserTreeNode node = (UserTreeNode)value;
        this.user = node.getUser();
        if (this.listeners == null) {
            this.listeners = ((AbstractCellEditor)((Object)this.realEditor)).getCellEditorListeners();
        }
        this.realEditor = this.user.getEditor();
        if (this.listeners != null) {
            int i = 0;
            while (i < this.listeners.length) {
                ((AbstractCellEditor)((Object)this.realEditor)).addCellEditorListener(this.listeners[i]);
                ++i;
            }
        }
        this.setTree(tree);
        this.lastRow = row;
        this.determineOffset(tree, value, isSelected, expanded, leaf, row);
        if (this.editingComponent != null) {
            this.editingContainer.remove(this.editingComponent);
        }
        this.editingComponent = this.realEditor.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        TreePath newPath = tree.getPathForRow(row);
        this.canEdit = this.lastPath != null && newPath != null && this.lastPath.equals(newPath);
        Font font = this.getFont();
        if (font == null) {
            if (this.renderer != null) {
                font = this.renderer.getFont();
            }
            if (font == null) {
                font = tree.getFont();
            }
        }
        this.editingContainer.setFont(font);
        this.prepareForEditing();
        return this.editingContainer;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.user == null) {
            return super.getCellEditorValue();
        }
        if (!(this.user instanceof UserObject)) {
            return super.getCellEditorValue();
        }
        this.user.setAfterEditing((JComponent)this.editingComponent);
        return this.user;
    }

    @Override
    protected void determineOffset(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.offset = 0;
    }
}

