/*
 * Decompiled with CFR 0.152.
 */
package kandid.soup.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import kandid.Console;
import kandid.Environment;
import kandid.Fitness;
import kandid.colorator.ColoratorFactory;
import kandid.soup.ChromosomeType;
import kandid.soup.ColoratorType;
import kandid.soup.ContextGene;
import kandid.soup.EntityType;
import kandid.soup.GradientChromosome;
import kandid.soup.HsbFrequenceChromosome;
import kandid.soup.ImageType;
import kandid.soup.IntegerGene;
import kandid.soup.LookUpTableChromosome;
import kandid.soup.Lsys0LImage;
import kandid.soup.LsysD0LImage;
import kandid.soup.LsysProductionGene;
import kandid.soup.ObjectFactory;
import kandid.soup.PopulationType;
import kandid.soup.PovThingImage;
import kandid.soup.PovThingNFImage;
import kandid.soup.RatingBase;
import kandid.soup.ScalarExpressionChromosome;
import kandid.soup.ScalarExpressionImage;
import kandid.soup.TransparentLookUpTableChromosome;
import kandid.soup.VectorExpressionChromosome;
import kandid.soup.VectorExpressionImage;
import kandid.soup.VoronoiChromosome;
import kandid.soup.VoronoiImage;
import kandid.soup.VoronoiTransparentChromosome;
import kandid.soup.VoronoiTransparentImage;
import kandid.soup.genetic.scalarvm.Randomizer;
import kandid.soup.genetic.vectorvm.Merger;
import kandid.soup.genetic.vectorvm.Mutator;
import kandid.soup.genetic.voronoi.Cloner;
import kandid.soup.genetic.voronoi.ClonerTransparent;
import kandid.soup.genetic.voronoi.MergerTransparent;
import kandid.soup.genetic.voronoi.MutatorTransparent;
import kandid.soup.genetic.voronoi.RandomizerTransparent;
import kandid.soup.map.CloneChromosome;
import kandid.soup.map.MergeChromosome;
import kandid.soup.map.MutateChromosome;
import kandid.soup.map.RandomizeChromosome;
import kandid.soup.map.SetEditorMapping;
import kandid.soup.util.ChromosomeStamp;
import kandid.util.Debug;
import kandid.util.Util;

public class SoupFactory {
    private static SoupFactory soupFactory;
    private ObjectFactory objectFactory = new ObjectFactory();
    private CloneChromosome cloner = new CloneChromosome();
    private MergeChromosome merger = new MergeChromosome();
    private MutateChromosome mutator = new MutateChromosome();
    private SetEditorMapping editorFiller = new SetEditorMapping();
    private RandomizeChromosome randomizer = new RandomizeChromosome();
    private JAXBContext jc;

    private SoupFactory() {
        try {
            this.jc = JAXBContext.newInstance((String)"kandid.soup");
        }
        catch (JAXBException exc) {
            Debug.stackTrace(exc);
        }
    }

    public static SoupFactory getSoupFactory() {
        if (soupFactory == null) {
            soupFactory = new SoupFactory();
        }
        return soupFactory;
    }

    public Object create(String qualifiedClassName) {
        try {
            int gpx = qualifiedClassName.lastIndexOf(46);
            String className = qualifiedClassName.substring(gpx + 1);
            Method[] of = ObjectFactory.class.getMethods();
            String creatorName = "create" + className;
            int mx = 0;
            while (mx < of.length) {
                if (of[mx].getName().equals(creatorName)) {
                    return of[mx].invoke((Object)this.objectFactory, new Object[0]);
                }
                ++mx;
            }
            throw new IllegalArgumentException("missing: ObjectFactory." + creatorName);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
            return null;
        }
    }

    public PopulationType createPopulation(String typeName) {
        PopulationType population = null;
        try {
            population = this.objectFactory.createPopulationType();
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return population;
    }

    public ImageType createImage(PopulationType population, int nx, String typeName, String calculationName, String coloratorName) {
        String imageClassName = typeName + "Image";
        ImageType image = null;
        try {
            image = (ImageType)soupFactory.create(imageClassName);
            Class[] calculationTypes = new Class[]{calculationName.getClass()};
            Method setCalculationName = image.getClass().getMethod("setCalculationName", calculationTypes);
            Object[] param = new Object[]{calculationName};
            setCalculationName.invoke((Object)image, param);
            if (ColoratorFactory.isSimpleColorator(coloratorName)) {
                Class[] coloratorTypes = new Class[]{coloratorName.getClass()};
                Method setColoratorName = image.getClass().getMethod("setColoratorName", coloratorTypes);
                param = new Object[]{coloratorName};
                setColoratorName.invoke((Object)image, param);
            } else {
                ColoratorType newColorator = this.objectFactory.createColoratorType();
                newColorator.setColoratorName(coloratorName);
                Class[] coloratorTypes = new Class[]{ColoratorType.class};
                Method setColorator = image.getClass().getMethod("setColorator", coloratorTypes);
                Object[] param2 = new Object[]{newColorator};
                setColorator.invoke((Object)image, param2);
            }
            Method getList = population.getClass().getMethod("get" + typeName, new Class[0]);
            List imageList = (List)getList.invoke((Object)population, new Object[0]);
            imageList.add(image);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return image;
    }

    public ChromosomeType createRandomChromosome(PopulationType population, int nx, ChromosomeStamp chromosomeStamp) {
        String chromosomeClassName = SoupFactory.getTypeName(population) + "Chromosome";
        ChromosomeType newChromosome = null;
        try {
            List list = this.getImageList(population);
            ImageType image = (ImageType)list.get(nx);
            if (image instanceof ScalarExpressionImage) {
                newChromosome = Randomizer.create();
            } else if (image instanceof VectorExpressionImage) {
                newChromosome = kandid.soup.genetic.vectorvm.Randomizer.create();
            } else if (image instanceof VoronoiImage) {
                newChromosome = kandid.soup.genetic.voronoi.Randomizer.create();
            } else if (image instanceof VoronoiTransparentImage) {
                newChromosome = RandomizerTransparent.create();
            } else {
                newChromosome = (ChromosomeType)this.create(chromosomeClassName);
                Class[] signatureTypes = new Class[]{newChromosome.getClass()};
                Method randomized = this.randomizer.getClass().getMethod("randomize", signatureTypes);
                Object[] param2 = new Object[]{newChromosome};
                randomized.invoke((Object)this.randomizer, param2);
            }
            Object[] param = new Object[]{newChromosome};
            Method[] of = image.getClass().getMethods();
            int mx = 0;
            mx = 0;
            while (mx < of.length) {
                if (of[mx].getName().equals("setChromosome")) {
                    of[mx].invoke((Object)image, param);
                    break;
                }
                ++mx;
            }
            newChromosome.setIdent(chromosomeStamp.getNextStamp());
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return newChromosome;
    }

    public static String getTypeName(PopulationType population) {
        try {
            Method[] of = population.getClass().getMethods();
            int mx = 0;
            mx = 0;
            while (mx < of.length) {
                List list;
                if (of[mx].getName().startsWith("get") && of[mx].getReturnType() == List.class && (list = (List)of[mx].invoke((Object)population, null)) != null && list.size() > 0) {
                    return of[mx].getName().substring(3);
                }
                ++mx;
            }
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return null;
    }

    public void replaceImage(PopulationType population, int ix, ImageType image) {
        List imageList = this.getImageList(population);
        imageList.set(ix, image);
    }

    public void addImage(PopulationType population, int ix, ImageType image) {
        List imageList = this.getImageList(population);
        imageList.add(ix, image);
    }

    public ColoratorType createRandomColorator(PopulationType population, int nx, String coloratorName, ChromosomeStamp chromosomeStamp) {
        Object cloloratorChromosomeClassName = coloratorName;
        if (coloratorName.endsWith("Colorator")) {
            cloloratorChromosomeClassName = coloratorName.substring(0, coloratorName.length() - 9);
        }
        cloloratorChromosomeClassName = (String)cloloratorChromosomeClassName + "Chromosome";
        ColoratorType newColorator = null;
        try {
            List list = this.getImageList(population);
            ImageType image = (ImageType)list.get(nx);
            newColorator = this.objectFactory.createColoratorType();
            if (ColoratorFactory.isSimpleColorator(coloratorName)) {
                Class[] coloratorTypes = new Class[]{coloratorName.getClass()};
                Method setColoratorName = image.getClass().getMethod("setColoratorName", coloratorTypes);
                Object[] param = new Object[]{coloratorName};
                setColoratorName.invoke((Object)image, param);
            } else {
                ChromosomeType newColoratorChromosome = (ChromosomeType)this.create((String)cloloratorChromosomeClassName);
                newColoratorChromosome.setIdent(chromosomeStamp.getNextStamp());
                newColorator.setColoratorName(coloratorName);
                Class[] signatureTypes1 = new Class[]{newColoratorChromosome.getClass()};
                Method randomized = this.randomizer.getClass().getMethod("randomize", signatureTypes1);
                Object[] param1 = new Object[]{newColoratorChromosome};
                randomized.invoke((Object)this.randomizer, param1);
                this.setColorTable(newColorator, newColoratorChromosome);
                Class[] coloratorTypes = new Class[]{ColoratorType.class};
                Method setColorator = image.getClass().getMethod("setColorator", coloratorTypes);
                Object[] param4 = new Object[]{newColorator};
                setColorator.invoke((Object)image, param4);
            }
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return newColorator;
    }

    public ChromosomeType clone(ChromosomeType chromosome, boolean newIdent, String populationIdent) {
        ChromosomeType newChromosome = null;
        try {
            if (chromosome instanceof ScalarExpressionChromosome) {
                newChromosome = kandid.soup.genetic.scalarvm.Cloner.deepclone((ScalarExpressionChromosome)chromosome);
            } else if (chromosome instanceof VectorExpressionChromosome) {
                newChromosome = kandid.soup.genetic.vectorvm.Cloner.deepclone((VectorExpressionChromosome)chromosome);
            } else if (chromosome instanceof VoronoiChromosome) {
                newChromosome = Cloner.deepclone((VoronoiChromosome)chromosome);
            } else if (chromosome instanceof VoronoiTransparentChromosome) {
                newChromosome = ClonerTransparent.deepclone((VoronoiTransparentChromosome)chromosome);
            } else {
                Class[] signatureTypes = new Class[]{chromosome.getClass()};
                Method clone = this.cloner.getClass().getMethod("clone", signatureTypes);
                Object[] param = new Object[]{chromosome};
                newChromosome = (ChromosomeType)clone.invoke((Object)this.cloner, param);
            }
            if (newIdent) {
                newChromosome.setIdent(ChromosomeStamp.forceNextChromosomeId(chromosome.getIdent()));
            } else {
                newChromosome.setIdent(chromosome.getIdent());
            }
            if (populationIdent != null) {
                newChromosome.setIdent(ChromosomeStamp.patchPopulationIdent(newChromosome.getIdent(), populationIdent));
            }
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return newChromosome;
    }

    public ColoratorType clone(ColoratorType colorator, boolean newIdent, String populationIdent) {
        if (colorator != null) {
            try {
                ColoratorType newColorator = this.objectFactory.createColoratorType();
                newColorator.setColoratorName(new String(colorator.getColoratorName()));
                LookUpTableChromosome lut = colorator.getLookUpTable();
                if (lut != null) {
                    newColorator.setLookUpTable((LookUpTableChromosome)this.clone(lut, newIdent, populationIdent));
                } else {
                    TransparentLookUpTableChromosome transLut = colorator.getTransparentLookUpTable();
                    if (transLut != null) {
                        newColorator.setTransparentLookUpTable((TransparentLookUpTableChromosome)this.clone(transLut, newIdent, populationIdent));
                    } else {
                        GradientChromosome gradient = colorator.getGradient();
                        if (gradient != null) {
                            newColorator.setGradient((GradientChromosome)this.clone(gradient, newIdent, populationIdent));
                        } else {
                            HsbFrequenceChromosome hsbFrequence = colorator.getHsbFrequence();
                            if (hsbFrequence != null) {
                                newColorator.setHsbFrequence((HsbFrequenceChromosome)this.clone(hsbFrequence, newIdent, populationIdent));
                            }
                        }
                    }
                }
                return newColorator;
            }
            catch (Exception exc) {
                Debug.stackTrace(exc);
            }
        }
        return null;
    }

    public ChromosomeType merge(ChromosomeType chromosome1, ChromosomeType chromosome2, Environment env) {
        ChromosomeType newChromosome = null;
        try {
            env.setSource1(true);
            if (chromosome1 instanceof ScalarExpressionChromosome) {
                assert (chromosome2 instanceof ScalarExpressionChromosome);
                newChromosome = kandid.soup.genetic.scalarvm.Merger.merge(env, (ScalarExpressionChromosome)chromosome1, (ScalarExpressionChromosome)chromosome2);
            } else if (chromosome1 instanceof VectorExpressionChromosome) {
                assert (chromosome2 instanceof VectorExpressionChromosome);
                newChromosome = Merger.merge(env, (VectorExpressionChromosome)chromosome1, (VectorExpressionChromosome)chromosome2);
            } else if (chromosome1 instanceof VoronoiChromosome) {
                assert (chromosome2 instanceof VoronoiChromosome);
                newChromosome = kandid.soup.genetic.voronoi.Merger.merge(env, (VoronoiChromosome)chromosome1, (VoronoiChromosome)chromosome2);
            } else if (chromosome1 instanceof VoronoiTransparentChromosome) {
                assert (chromosome2 instanceof VoronoiTransparentChromosome);
                newChromosome = MergerTransparent.merge(env, (VoronoiTransparentChromosome)chromosome1, (VoronoiTransparentChromosome)chromosome2);
            } else {
                Class[] signatureTypes = new Class[]{env.getClass(), chromosome1.getClass(), chromosome2.getClass()};
                Method merge = this.merger.getClass().getMethod("merge", signatureTypes);
                Object[] param = new Object[]{env, chromosome1, chromosome2};
                newChromosome = (ChromosomeType)merge.invoke((Object)this.merger, param);
            }
            newChromosome.setIdent(ChromosomeStamp.forceNextChromosomeId(chromosome1.getIdent()));
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return newChromosome;
    }

    public int mutate(ChromosomeType chromosome, Environment env) {
        int mutationCounter = 0;
        try {
            if (chromosome instanceof ScalarExpressionChromosome) {
                mutationCounter = kandid.soup.genetic.scalarvm.Mutator.mutate(env, (ScalarExpressionChromosome)chromosome);
            } else if (chromosome instanceof VectorExpressionChromosome) {
                mutationCounter = Mutator.mutate(env, (VectorExpressionChromosome)chromosome);
            } else if (chromosome instanceof VoronoiChromosome) {
                mutationCounter = kandid.soup.genetic.voronoi.Mutator.mutate(env, (VoronoiChromosome)chromosome);
            } else if (chromosome instanceof VoronoiTransparentChromosome) {
                mutationCounter = MutatorTransparent.mutate(env, (VoronoiTransparentChromosome)chromosome);
            } else {
                Class[] signatureTypes = new Class[]{env.getClass(), chromosome.getClass()};
                Method mutate = this.mutator.getClass().getMethod("mutate", signatureTypes);
                Object[] param = new Object[]{env, chromosome};
                Integer ret = (Integer)mutate.invoke((Object)this.mutator, param);
                mutationCounter = ret;
            }
            chromosome.setIdent(ChromosomeStamp.forceNextChromosomeId(chromosome.getIdent()));
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return mutationCounter;
    }

    public int mutate(ColoratorType colorator, Environment env) {
        if (colorator != null) {
            LookUpTableChromosome lut = colorator.getLookUpTable();
            if (lut != null) {
                return this.mutate(lut, env);
            }
            TransparentLookUpTableChromosome transLut = colorator.getTransparentLookUpTable();
            if (transLut != null) {
                return this.mutate(transLut, env);
            }
            GradientChromosome gradient = colorator.getGradient();
            if (gradient != null) {
                return this.mutate(gradient, env);
            }
            HsbFrequenceChromosome hsbFrequence = colorator.getHsbFrequence();
            if (hsbFrequence != null) {
                return this.mutate(hsbFrequence, env);
            }
        }
        return 0;
    }

    public void fillEditor(ChromosomeType chromosome, ColoratorType colorator, JTree tree) {
        ChromosomeType colorChromosome;
        this.fillEditor(chromosome, tree);
        if (colorator != null && (colorChromosome = soupFactory.getColorTable(colorator)) != null) {
            soupFactory.fillEditor(colorChromosome, tree);
        }
    }

    private void fillEditor(ChromosomeType chromosome, JTree tree) {
        try {
            Class[] signatureTypes = new Class[]{chromosome.getClass(), tree.getClass()};
            Method fillEditor = this.editorFiller.getClass().getMethod("fillEditor", signatureTypes);
            Object[] param = new Object[]{chromosome, tree};
            fillEditor.invoke((Object)this.editorFiller, param);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
    }

    public void marshalToFile(Object model, String outputFileName) {
        try {
            FileOutputStream out = new FileOutputStream(outputFileName);
            Marshaller m = this.jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal(model, (OutputStream)out);
            out.close();
            Console.append("store " + String.valueOf(new File(outputFileName).getAbsoluteFile()));
        }
        catch (JAXBException je) {
            Debug.stackTrace(je);
        }
        catch (IOException ioe) {
            Debug.stackTrace(ioe);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
    }

    public Object unmarshalFromFile(String inputFileName) {
        Object input = null;
        try {
            Unmarshaller u = this.jc.createUnmarshaller();
            input = u.unmarshal((InputStream)new FileInputStream(inputFileName));
            Console.append("read " + String.valueOf(new File(inputFileName).getAbsoluteFile()));
            this.upgrade(input);
        }
        catch (JAXBException je) {
            Debug.stackTrace(je);
        }
        catch (IOException ioe) {
            Debug.stackTrace(ioe);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return input;
    }

    private void upgrade(Object input) throws JAXBException {
        if (input instanceof PopulationType) {
            Iterator<ImageType> iter;
            PopulationType population = (PopulationType)input;
            if (population.getLsysD0L() != null) {
                for (LsysD0LImage lsysD0LImage : population.getLsysD0L()) {
                    this.upgradeLsysD0L_0_2_7(lsysD0LImage);
                    this.upgradeLsysD0L_0_2_9(lsysD0LImage);
                }
            }
            if (population.getLsys0L() != null) {
                for (Lsys0LImage lsys0LImage : population.getLsys0L()) {
                    this.upgradeLsys0L_0_2_7(lsys0LImage);
                    this.upgradeLsys0L_0_2_9(lsys0LImage);
                }
            }
            if (population.getScalarExpression() != null) {
                iter = population.getScalarExpression().iterator();
                while (iter.hasNext()) {
                    this.upgradeScalarExpression_0_2_8((ScalarExpressionImage)iter.next());
                }
            }
            if (population.getPovThing() != null) {
                iter = population.getPovThing().iterator();
                while (iter.hasNext()) {
                    this.upgradePovThing_0_3_3((PovThingImage)iter.next());
                }
            }
            if (population.getPovThingNF() != null) {
                iter = population.getPovThingNF().iterator();
                while (iter.hasNext()) {
                    this.upgradePovThingNF_0_3_3((PovThingNFImage)iter.next());
                }
            }
        } else if (input instanceof EntityType) {
            EntityType entity = (EntityType)input;
            if (entity.getLsysD0L() != null) {
                this.upgradeLsysD0L_0_2_7(entity.getLsysD0L());
                this.upgradeLsysD0L_0_2_9(entity.getLsysD0L());
            }
            if (entity.getLsys0L() != null) {
                this.upgradeLsys0L_0_2_7(entity.getLsys0L());
                this.upgradeLsys0L_0_2_9(entity.getLsys0L());
            }
            if (entity.getScalarExpression() != null) {
                this.upgradeScalarExpression_0_2_8(entity.getScalarExpression());
            }
            if (entity.getPovThing() != null) {
                this.upgradePovThing_0_3_3(entity.getPovThing());
            }
            if (entity.getPovThingNF() != null) {
                this.upgradePovThingNF_0_3_3(entity.getPovThingNF());
            }
        } else assert (false) : "type not suported" + input.getClass().getName();
    }

    private void upgradePovThing_0_3_3(PovThingImage image) {
        if (image.getCalculationName().equals("kandid.calculation.bridge.povray.PovThingCalculation")) {
            image.setCalculationName("kandid.calculation.bridge.povray.PovTextureCalculation");
        }
    }

    private void upgradePovThingNF_0_3_3(PovThingNFImage image) {
        if (image.getCalculationName().equals("kandid.calculation.bridge.povray.PovThingCalculation")) {
            image.setCalculationName("kandid.calculation.bridge.povray.PovTextureCalculation");
        }
    }

    private void updateLsysProductionList_0_2_9(List productionList) throws JAXBException {
        for (LsysProductionGene production : productionList) {
            ContextGene leftContext = this.objectFactory.createContextGene();
            leftContext.setValue("");
            production.setLeftContext(leftContext);
            ContextGene rightContext = this.objectFactory.createContextGene();
            rightContext.setValue("");
            production.setRightContext(rightContext);
        }
    }

    private void upgradeLsys0L_0_2_9(Lsys0LImage image) throws JAXBException {
        List<LsysProductionGene> productionList = image.getChromosome().getProduction();
        this.updateLsysProductionList_0_2_9(productionList);
    }

    private void upgradeLsysD0L_0_2_9(LsysD0LImage image) throws JAXBException {
        List<LsysProductionGene> productionList = image.getChromosome().getProduction();
        this.updateLsysProductionList_0_2_9(productionList);
    }

    private void upgradeScalarExpression_0_2_8(ScalarExpressionImage image) {
        String calculationName = image.getCalculationName();
        if (calculationName.equals("kandid.calculation.vm.ScalarExpressionCalculation")) {
            image.setCalculationName("kandid.calculation.vm.scalar.ScalarExpressionCalculation");
        }
    }

    private void upgradeLsysD0L_0_2_7(LsysD0LImage image) throws JAXBException {
        if (image.getChromosome().getBaseIndex() == null) {
            IntegerGene baseIndex = this.objectFactory.createIntegerGene();
            baseIndex.setValue(0);
            image.getChromosome().setBaseIndex(baseIndex);
        }
    }

    private void upgradeLsys0L_0_2_7(Lsys0LImage image) throws JAXBException {
        if (image.getChromosome().getBaseIndex() == null) {
            IntegerGene baseIndex = this.objectFactory.createIntegerGene();
            baseIndex.setValue(0);
            image.getChromosome().setBaseIndex(baseIndex);
        }
    }

    public String marshalToString(Object model) {
        return Util.marshalToString(model, this.jc);
    }

    public Object unmarshalFromString(String stringRepresentation) {
        Object input = null;
        try {
            Unmarshaller u = this.jc.createUnmarshaller();
            Object unkown = u.unmarshal((Source)new StreamSource(new StringReader(stringRepresentation)));
            if (unkown instanceof JAXBElement) {
                input = (JAXBElement)unkown;
                this.upgrade(((JAXBElement)input).getValue());
            } else {
                input = unkown;
                this.upgrade(input);
            }
        }
        catch (JAXBException je) {
            Debug.stackTrace(je);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return input;
    }

    public boolean validate(Object model) {
        return true;
    }

    public List getImageList(PopulationType population) {
        try {
            Method[] of = population.getClass().getMethods();
            int mx = 0;
            mx = 0;
            while (mx < of.length) {
                List list;
                if (of[mx].getName().startsWith("get") && of[mx].getReturnType() == List.class && (list = (List)of[mx].invoke((Object)population, null)).size() > 0) {
                    return list;
                }
                ++mx;
            }
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return null;
    }

    public ImageType getImage(PopulationType population, int id) {
        return (ImageType)soupFactory.getImageList(population).get(id);
    }

    public int getSize(PopulationType population) {
        List list = this.getImageList(population);
        return list == null ? 0 : list.size();
    }

    public ChromosomeType getChromosome(PopulationType population, int nx) {
        ChromosomeType chromosomeType = null;
        try {
            List list = this.getImageList(population);
            ImageType image = (ImageType)list.get(nx);
            Method getChromosome = image.getClass().getMethod("getChromosome", null);
            chromosomeType = (ChromosomeType)getChromosome.invoke((Object)image, null);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return chromosomeType;
    }

    public String getColoratorName(PopulationType population, int nx) {
        String coloratorName = null;
        try {
            List list = this.getImageList(population);
            ImageType image = (ImageType)list.get(nx);
            Method getColoratorName = image.getClass().getMethod("getColoratorName", null);
            coloratorName = (String)getColoratorName.invoke((Object)image, null);
            if (coloratorName == null) {
                ColoratorType coloratorType = this.getColorator(population, nx);
                coloratorName = coloratorType.getColoratorName();
            }
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return coloratorName;
    }

    public ColoratorType getColorator(PopulationType population, int nx) {
        ColoratorType colorator = null;
        try {
            List list = this.getImageList(population);
            ImageType image = (ImageType)list.get(nx);
            Method getColorator = image.getClass().getMethod("getColorator", null);
            colorator = (ColoratorType)getColorator.invoke((Object)image, null);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return colorator;
    }

    public String getCalculationName(PopulationType population, int nx) {
        String calculationName = null;
        try {
            List list = this.getImageList(population);
            ImageType image = (ImageType)list.get(nx);
            Method getCalculationNameMethod = image.getClass().getMethod("getCalculationName", null);
            calculationName = (String)getCalculationNameMethod.invoke((Object)image, null);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return calculationName;
    }

    public void setRating(PopulationType population, int nx, Fitness fitness) {
        try {
            List list = this.getImageList(population);
            ImageType image = (ImageType)list.get(nx);
            if (fitness.abort) {
                image.setRating(RatingBase.ABORT);
            } else if (fitness.best) {
                image.setRating(RatingBase.BEST);
            } else if (fitness.parent1) {
                image.setRating(RatingBase.PARENT_1);
            } else if (fitness.parent2) {
                image.setRating(RatingBase.PARENT_2);
            } else {
                image.setRating(RatingBase.NONE);
            }
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
    }

    public Fitness mapRating(PopulationType population, int nx) {
        Fitness fitness = new Fitness();
        try {
            List list = this.getImageList(population);
            ImageType image = (ImageType)list.get(nx);
            RatingBase rating = image.getRating();
            fitness.setRating(rating);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return fitness;
    }

    public void setChromosome(PopulationType population, int nx, ChromosomeType chromosome) {
        try {
            List list = this.getImageList(population);
            ImageType image = (ImageType)list.get(nx);
            Object[] param = new Object[]{chromosome};
            Method[] of = image.getClass().getMethods();
            int mx = 0;
            mx = 0;
            while (mx < of.length) {
                if (of[mx].getName().equals("setChromosome")) {
                    of[mx].invoke((Object)image, param);
                    break;
                }
                ++mx;
            }
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
    }

    public void setColorator(PopulationType population, int nx, ColoratorType colorator) {
        List list = this.getImageList(population);
        ImageType image = (ImageType)list.get(nx);
        image.setColorator(colorator);
    }

    public void setColorTable(ColoratorType colorator, ChromosomeType coloratorChromosome) throws Exception {
        switch (coloratorChromosome.getClass().getSimpleName()) {
            case "HsbFrequenceChromosome": {
                colorator.setHsbFrequence((HsbFrequenceChromosome)coloratorChromosome);
                break;
            }
            case "GradientChromosome": {
                colorator.setGradient((GradientChromosome)coloratorChromosome);
                break;
            }
            case "LookUpTableChromosome": {
                colorator.setLookUpTable((LookUpTableChromosome)coloratorChromosome);
                break;
            }
            case "TransparentLookUpTableChromosome": {
                colorator.setTransparentLookUpTable((TransparentLookUpTableChromosome)coloratorChromosome);
                break;
            }
            default: {
                System.err.println("chromosome = " + coloratorChromosome.getClass().getSimpleName());
                System.err.println("colorator  = " + colorator.getColoratorName() + " " + colorator.getClass().getName());
                throw new Exception("colorator / chromosome mapping not implemented");
            }
        }
    }

    public ChromosomeType getColorTable(ColoratorType colorator) {
        try {
            ChromosomeType colorTable = colorator.getLookUpTable();
            if (colorTable != null) {
                return colorTable;
            }
            colorTable = colorator.getTransparentLookUpTable();
            if (colorTable != null) {
                return colorTable;
            }
            colorTable = colorator.getGradient();
            if (colorTable != null) {
                return colorTable;
            }
            colorTable = colorator.getHsbFrequence();
            if (colorTable != null) {
                return colorTable;
            }
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return null;
    }

    public EntityType createEntity(String typeName, ImageType image) {
        EntityType entity = null;
        try {
            entity = this.objectFactory.createEntityType();
            Object[] param = new Object[]{image};
            Method[] of = entity.getClass().getMethods();
            int mx = 0;
            mx = 0;
            while (mx < of.length) {
                if (of[mx].getName().equals("set" + typeName)) {
                    of[mx].invoke((Object)entity, param);
                    break;
                }
                ++mx;
            }
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return entity;
    }

    public EntityType createEntity(ImageType image) {
        EntityType entity = null;
        try {
            entity = this.objectFactory.createEntityType();
            Object[] param = new Object[]{image};
            Method[] of = entity.getClass().getMethods();
            int mx = 0;
            mx = 0;
            while (mx < of.length) {
                if (of[mx].getName().startsWith("set") && of[mx].getParameterTypes().length == 1 && of[mx].getParameterTypes()[0] == image.getClass().getInterfaces()[0]) {
                    of[mx].invoke((Object)entity, param);
                    break;
                }
                ++mx;
            }
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return entity;
    }

    public ImageType getImage(EntityType entity) {
        try {
            Method[] of = entity.getClass().getMethods();
            int mx = 0;
            mx = 0;
            while (mx < of.length) {
                Object image;
                if (of[mx].getName().startsWith("get") && of[mx].getParameterTypes().length == 0 && (image = of[mx].invoke((Object)entity, null)) != null && image instanceof ImageType) {
                    return (ImageType)image;
                }
                ++mx;
            }
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return null;
    }

    public static String getTypeName(EntityType entity) {
        try {
            Method[] of = entity.getClass().getMethods();
            int mx = 0;
            mx = 0;
            while (mx < of.length) {
                Object image;
                if (of[mx].getName().startsWith("get") && of[mx].getParameterTypes().length == 0 && (image = of[mx].invoke((Object)entity, null)) != null && image instanceof ImageType) {
                    return of[mx].getName().substring(3);
                }
                ++mx;
            }
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return null;
    }

    public ChromosomeType getChromosome(EntityType entity) {
        ChromosomeType chromosomeType = null;
        try {
            ImageType image = this.getImage(entity);
            Method getChromosome = image.getClass().getMethod("getChromosome", null);
            chromosomeType = (ChromosomeType)getChromosome.invoke((Object)image, null);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return chromosomeType;
    }

    public String getCalculationName(EntityType entity) {
        String calculationName = null;
        try {
            ImageType image = this.getImage(entity);
            Method getCalculationNameMethod = image.getClass().getMethod("getCalculationName", null);
            calculationName = (String)getCalculationNameMethod.invoke((Object)image, null);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return calculationName;
    }

    public ColoratorType getColorator(EntityType entity) {
        ColoratorType colorator = null;
        try {
            ImageType image = this.getImage(entity);
            Method getColorator = image.getClass().getMethod("getColorator", null);
            colorator = (ColoratorType)getColorator.invoke((Object)image, null);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return colorator;
    }

    public String getColoratorName(EntityType entity) {
        String coloratorName = null;
        try {
            ImageType image = this.getImage(entity);
            Method getColoratorName = image.getClass().getMethod("getColoratorName", null);
            coloratorName = (String)getColoratorName.invoke((Object)image, null);
            if (coloratorName == null) {
                ColoratorType coloratorType = this.getColorator(entity);
                coloratorName = coloratorType.getColoratorName();
            }
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return coloratorName;
    }
}

