/*
 * Decompiled with CFR 0.152.
 */
package kandid.soup.util;

public class ChromosomeStamp {
    private String typeName;
    private long populationIdent;
    private static long chromosomeIdent;

    public ChromosomeStamp(String typeName) {
        long timeStamp = System.currentTimeMillis();
        this.typeName = typeName;
        this.populationIdent = timeStamp;
        chromosomeIdent = timeStamp;
    }

    public String getStamp() {
        return this.typeName + "_" + Long.toString(this.populationIdent, 36) + "_" + Long.toString(chromosomeIdent, 36);
    }

    public String getTypePopulationIdent(String id2) {
        return this.typeName + "_" + id2 + "_" + Long.toString(this.populationIdent, 36);
    }

    public String getPopulationIdent() {
        return Long.toString(this.populationIdent, 36);
    }

    public String getNextStamp() {
        ++chromosomeIdent;
        return this.getStamp();
    }

    public void wipeIdent() {
        this.populationIdent = 10L;
        chromosomeIdent = 0L;
    }

    public void setPopulationIDfromName(String name) {
        int pos1;
        int pos2;
        int pos0;
        if (name.toLowerCase().endsWith(".kpop")) {
            int lastFileSeperator = (name = name.substring(0, name.length() - 5)).lastIndexOf("/");
            if (lastFileSeperator > -1) {
                name = name.substring(lastFileSeperator + 1);
            }
            pos0 = name.indexOf(95);
            pos2 = name.lastIndexOf(95);
            pos1 = name.lastIndexOf(95, pos2 - 1);
            if (pos1 < 0 || pos2 < 0 || pos2 == pos1) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.typeName = name.substring(0, pos0);
        this.populationIdent = Long.parseLong(name.substring(pos1 + 1, pos2), 36);
    }

    public static String forceNextChromosomeId(String origStamp) {
        int pos = origStamp.lastIndexOf(95);
        if (pos >= 3) {
            long counter = Long.parseLong(origStamp.substring(pos + 1), 36);
            chromosomeIdent = counter <= chromosomeIdent ? ++chromosomeIdent : counter + 1L;
        } else {
            throw new IllegalArgumentException();
        }
        return origStamp.substring(0, pos) + "_" + Long.toString(chromosomeIdent, 36);
    }

    public static String removeType(String origStamp) {
        int pos = origStamp.indexOf(95);
        if (pos >= 0) {
            return origStamp.substring(pos + 1, origStamp.length());
        }
        return origStamp;
    }

    public static String patchPopulationIdent(String populationIdent, String patch) {
        int endPos = populationIdent.lastIndexOf(95);
        int startPos = populationIdent.lastIndexOf(95, endPos - 1);
        return populationIdent.substring(0, startPos + 1) + patch + populationIdent.substring(endPos);
    }
}

