/*
 * Decompiled with CFR 0.152.
 */
package kandid.soup.test;

import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import junit.framework.TestCase;
import kandid.Environment;
import kandid.soup.ChromosomeType;
import kandid.soup.ColoratorType;
import kandid.soup.ImageType;
import kandid.soup.PopulationType;
import kandid.soup.map.SetEditorMapping;
import kandid.soup.test.FileDiff;
import kandid.soup.util.ChromosomeStamp;
import kandid.soup.util.SoupFactory;
import kandid.util.CentralRandomizer;
import kandid.util.Debug;

public class SoupFactoryTest
extends TestCase {
    private FileDiff fileDiff = new FileDiff();
    private SoupFactory soupFactory = null;
    public static String outputPath = "src/kandid/soup/test/";

    public SoupFactoryTest(String arg0) {
        super(arg0);
    }

    public void ignore_testPovIsoSurface() {
        this.soupFactory = SoupFactory.getSoupFactory();
        this.populationTest("PovIsoSurface", "kandid.colorator.RGBColorator", 1512L, 0.95);
    }

    public void testPovNFThing() {
        this.soupFactory = SoupFactory.getSoupFactory();
        this.populationTest("PovThingNF", "kandid.colorator.RGBColorator", 1512L, 0.95);
    }

    public void testPovThing() {
        this.soupFactory = SoupFactory.getSoupFactory();
        this.populationTest("PovThing", "kandid.colorator.RGBColorator", 1512L, 0.95);
    }

    public void testFlameIfs() {
        this.soupFactory = SoupFactory.getSoupFactory();
        this.populationTest("FlameIfs", "kandid.colorator.RGBColorator", 1512L, 0.95);
    }

    public void testLsysD0L() {
        this.soupFactory = SoupFactory.getSoupFactory();
        this.populationTest("LsysD0L", "kandid.colorator.BlackWhiteColorator", 31461L, 0.99);
    }

    public void testLsys0L() {
        this.soupFactory = SoupFactory.getSoupFactory();
        this.populationTest("Lsys0L", "kandid.colorator.GrayColorator", 1512L, 0.99);
    }

    public void testLsysIL() {
        this.soupFactory = SoupFactory.getSoupFactory();
        this.populationTest("LsysIL", "kandid.colorator.TransparentLookUpTableColorator", 31461L, 0.99);
    }

    public void ignore_testScalarExpression() {
        this.soupFactory = SoupFactory.getSoupFactory();
        this.populationTest("ScalarExpression", "kandid.colorator.GradientColorator", 31462L, 0.99);
    }

    public void ignore_testVectorExpression() {
        this.soupFactory = SoupFactory.getSoupFactory();
        this.populationTest("VectorExpression", "kandid.colorator.HsbFrequenceColorator", 31466L, 0.99);
    }

    public void testDirectLca() {
        this.soupFactory = SoupFactory.getSoupFactory();
        this.populationTest("DirectLca", "kandid.colorator.RGBColorator", 1512L, 0.05);
    }

    public void testTotalLca() {
        this.soupFactory = SoupFactory.getSoupFactory();
        this.populationTest("TotalLca", "kandid.colorator.RGBColorator", 1512L, 0.05);
    }

    public void testAffineIfs() {
        this.soupFactory = SoupFactory.getSoupFactory();
        this.populationTest("AffineIfs", "kandid.colorator.RGBColorator", 1512L, 0.05);
    }

    public void testAffineIfsSymm() {
        this.soupFactory = SoupFactory.getSoupFactory();
        this.populationTest("AffineIfsSymm", "kandid.colorator.GradientColorator", 1512L, 0.05);
    }

    public void testVoronoi() {
        this.soupFactory = SoupFactory.getSoupFactory();
        this.populationTest("Voronoi", "kandid.colorator.LookUpTableColorator", 1512L, 0.05);
    }

    public void testVoronoiTransparent() {
        this.soupFactory = SoupFactory.getSoupFactory();
        this.populationTest("VoronoiTransparent", "kandid.colorator.RGBColorator", 1512L, 0.05);
    }

    private void populationTest(String imageType, String coloratorName, long seed, double mutationRate) {
        try {
            System.out.println("--- populationTest " + imageType + " ---");
            Environment env = new Environment();
            env.setMutationRate(mutationRate);
            CentralRandomizer.setSeed(seed);
            String originalFileName = outputPath + imageType + ".test.xml";
            String originalRefFileName = outputPath + imageType + ".ref.xml";
            PopulationType population = SoupFactoryTest.createRandomPopulation(this.soupFactory, imageType, imageType, coloratorName);
            this.soupFactory.marshalToFile(population, originalFileName);
            SoupFactoryTest.assertTrue((boolean)this.soupFactory.validate(population));
            PopulationType population1 = (PopulationType)this.soupFactory.unmarshalFromFile(outputPath + imageType + ".test.xml");
            SoupFactoryTest.assertTrue((boolean)this.soupFactory.validate(population1));
            SoupFactoryTest.assertTrue((boolean)this.fileDiff.isEquals(originalFileName, originalRefFileName, true));
            int ix = 0;
            while (ix < this.soupFactory.getSize(population)) {
                ChromosomeType aChromosome = this.soupFactory.getChromosome(population, ix);
                JTree tree = new JTree();
                tree.setEditable(true);
                tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("test")));
                this.soupFactory.fillEditor(aChromosome, this.soupFactory.getColorator(population, ix), tree);
                StringBuffer buffer = SetEditorMapping.dump(tree);
                FileWriter fileWriter = new FileWriter(new File(outputPath + imageType + ".test.txt"));
                fileWriter.write(buffer.toString());
                fileWriter.close();
                if (imageType.equals("Voronoi")) {
                    SoupFactoryTest.assertTrue((boolean)this.fileDiff.isEquals(outputPath + imageType + ".test.txt", outputPath + imageType + ".ref.txt", false));
                }
                ChromosomeType aClone = this.soupFactory.clone(aChromosome, false, "a");
                ColoratorType aColorClone = this.soupFactory.clone(this.soupFactory.getColorator(population, ix), false, "a");
                ChromosomeType aMerge = this.soupFactory.merge(aClone, aChromosome, env);
                this.soupFactory.setChromosome(population, ix, aMerge);
                System.out.println("number of switch during merge " + env.getSwitchCounter());
                String mergeFileName = outputPath + imageType + ix + "merge.test.xml";
                this.soupFactory.marshalToFile(population, mergeFileName);
                SoupFactoryTest.assertTrue((boolean)this.soupFactory.validate(population));
                this.soupFactory.mutate(aChromosome, env);
                ColoratorType aMutatedColorator = this.soupFactory.getColorator(population, ix);
                this.soupFactory.mutate(aMutatedColorator, env);
                String cloneFileName = outputPath + imageType + ix + "clone.test.xml";
                this.soupFactory.setColorator(population, ix, aColorClone);
                this.soupFactory.setChromosome(population, ix, aClone);
                this.soupFactory.marshalToFile(population, cloneFileName);
                String mutateFileName = outputPath + imageType + ix + "mutate.test.xml";
                String mutateRefFileName = outputPath + imageType + ix + "mutate.ref.xml";
                this.soupFactory.setChromosome(population, ix, aChromosome);
                this.soupFactory.setColorator(population, ix, aMutatedColorator);
                this.soupFactory.marshalToFile(population, mutateFileName);
                SoupFactoryTest.assertTrue((boolean)this.fileDiff.isEquals(cloneFileName, originalFileName, true));
                SoupFactoryTest.assertTrue((!this.fileDiff.isEquals(mutateFileName, originalFileName, false) ? 1 : 0) != 0);
                SoupFactoryTest.assertTrue((boolean)this.fileDiff.isEquals(mutateFileName, mutateRefFileName, true));
                ++ix;
            }
            SoupFactoryTest.assertTrue((boolean)this.soupFactory.validate(population));
            this.soupFactory.marshalToFile(population, outputPath + imageType + "2.test.xml");
            PopulationType population2 = (PopulationType)this.soupFactory.unmarshalFromFile(outputPath + imageType + ".test.xml");
            SoupFactoryTest.assertTrue((boolean)this.soupFactory.validate(population2));
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
            SoupFactoryTest.assertTrue((boolean)false);
        }
    }

    public static PopulationType createRandomPopulation(SoupFactory setSoupFactory, String typeName, String calculationClassName, String coloratorClassName) {
        PopulationType population = null;
        try {
            population = setSoupFactory.createPopulation(typeName);
            ImageType image = setSoupFactory.createImage(population, 0, typeName, calculationClassName, coloratorClassName);
            ChromosomeStamp chromosomeStamp = new ChromosomeStamp(typeName);
            chromosomeStamp.wipeIdent();
            ChromosomeType chromosome = setSoupFactory.createRandomChromosome(population, 0, chromosomeStamp);
            ColoratorType coloratorType = setSoupFactory.createRandomColorator(population, 0, coloratorClassName, chromosomeStamp);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
        return population;
    }

    public static void listMethods(Class aClass) {
        Method[] me = aClass.getMethods();
        int mx = 0;
        while (mx < me.length) {
            System.out.print("method: " + aClass.getName() + "." + me[mx].getName() + "(");
            Class<?>[] params = me[mx].getParameterTypes();
            int px = 0;
            while (px < params.length) {
                System.out.print("  " + params[px].getName());
                ++px;
            }
            System.out.println(")");
            ++mx;
        }
    }

    public static void listFields(Class aClass) {
        Field[] fl = aClass.getFields();
        int mx = 0;
        while (mx < fl.length) {
            System.out.println("field: " + aClass.getName() + "." + fl[mx].getName());
            ++mx;
        }
    }
}

