/*
 * Decompiled with CFR 0.152.
 */
package kandid.soup.genetic.voronoi;

import java.util.List;
import kandid.soup.ColorGene;
import kandid.soup.DistanceFunctionBase;
import kandid.soup.DistanceFunctionGene;
import kandid.soup.KingGene;
import kandid.soup.NormalizedGene;
import kandid.soup.ObjectFactory;
import kandid.soup.RandomWalkPointGene;
import kandid.soup.SymmetricGene;
import kandid.soup.VoronoiChromosomeBase;
import kandid.util.CentralRandomizer;

public class RandomizerBase {
    protected static ObjectFactory objectFactory = new ObjectFactory();

    public static VoronoiChromosomeBase create() {
        VoronoiChromosomeBase chromosome = objectFactory.createVoronoiChromosomeBase();
        RandomizerBase.randomize_members(chromosome);
        return chromosome;
    }

    protected static void randomize_members(VoronoiChromosomeBase chromosome) {
        List<DistanceFunctionGene> dist = chromosome.getDistance();
        int len = CentralRandomizer.getInt(1, 8);
        while (len > 0) {
            dist.add(RandomizerBase.randomize_distance());
            --len;
        }
        List<KingGene> kings = chromosome.getKing();
        len = CentralRandomizer.getInt(2, 50);
        while (len > 0) {
            kings.add(RandomizerBase.randomize_king());
            --len;
        }
    }

    static DistanceFunctionGene randomize_distance() {
        DistanceFunctionBase[] possible_distance = DistanceFunctionBase.values();
        DistanceFunctionBase new_distance = possible_distance[CentralRandomizer.getInt(possible_distance.length - 1)];
        DistanceFunctionGene new_distance_gene = objectFactory.createDistanceFunctionGene();
        new_distance_gene.setDistanceFunction(new_distance);
        SymmetricGene weight = objectFactory.createSymmetricGene();
        weight.setValue(CentralRandomizer.getDouble(-1.0, 1.0));
        new_distance_gene.setWeight(weight);
        return new_distance_gene;
    }

    static KingGene randomize_king() {
        KingGene king = objectFactory.createKingGene();
        king.setPoint(RandomizerBase.randomize_point());
        king.setColor(RandomizerBase.randomize_color());
        king.setWeight(RandomizerBase.randomize_weight());
        return king;
    }

    private static NormalizedGene randomize_weight() {
        NormalizedGene new_weight = objectFactory.createNormalizedGene();
        new_weight.setValue(CentralRandomizer.getDouble(1.0));
        return new_weight;
    }

    private static ColorGene randomize_color() {
        ColorGene new_color = objectFactory.createColorGene();
        new_color.setRed(Float.valueOf((float)CentralRandomizer.getDouble(1.0)));
        new_color.setGreen(Float.valueOf((float)CentralRandomizer.getDouble(1.0)));
        new_color.setBlue(Float.valueOf((float)CentralRandomizer.getDouble(1.0)));
        return new_color;
    }

    private static RandomWalkPointGene randomize_point() {
        RandomWalkPointGene new_point = objectFactory.createRandomWalkPointGene();
        double radius = CentralRandomizer.getDouble(1.0);
        double angle = CentralRandomizer.getDouble(-Math.PI, Math.PI);
        new_point.setX(radius * Math.cos(angle));
        new_point.setY(radius * Math.sin(angle));
        return new_point;
    }
}

