/*
 * Decompiled with CFR 0.152.
 */
package kandid.soup.genetic.voronoi;

import kandid.Environment;
import kandid.soup.DoubleGene;
import kandid.soup.IntegerGene;
import kandid.soup.VoronoiTransparentChromosome;
import kandid.soup.genetic.voronoi.MutatorBase;
import kandid.util.CentralRandomizer;

public class MutatorTransparent
extends MutatorBase {
    public static int mutate(Environment env, VoronoiTransparentChromosome chromosome) {
        int mutationCounter = MutatorBase.mutate_members(env, chromosome);
        mutationCounter += MutatorTransparent.mutate_IntegerGene(env, chromosome.getPrioritySize(), 2, 10);
        return mutationCounter += MutatorTransparent.mutate_DoubleGene(env, chromosome.getPriorityWeight(), 0.5, 2.0);
    }

    private static int mutate_DoubleGene(Environment env, DoubleGene gene, double minInclusive, double maxInclusive) {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            double oldValue = gene.getValue();
            double newValue = oldValue + env.getScaleFactor() * CentralRandomizer.getGaussian();
            if (newValue < minInclusive) {
                newValue = minInclusive;
            } else if (newValue > maxInclusive) {
                newValue = maxInclusive;
            }
            gene.setValue(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        return mutationCounter;
    }

    private static int mutate_IntegerGene(Environment env, IntegerGene gene, int minInclusive, int maxInclusive) {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            int oldValue = gene.getValue();
            int newValue = oldValue + (CentralRandomizer.getBoolean() ? 1 : -1);
            if (newValue < minInclusive) {
                newValue = minInclusive;
            } else if (newValue > maxInclusive) {
                newValue = maxInclusive;
            }
            gene.setValue(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        return mutationCounter;
    }
}

