/*
 * Decompiled with CFR 0.152.
 */
package kandid.soup.genetic.voronoi;

import java.util.List;
import kandid.Environment;
import kandid.colorator.ColorF32;
import kandid.soup.ColorGene;
import kandid.soup.DistanceFunctionBase;
import kandid.soup.DistanceFunctionGene;
import kandid.soup.KingGene;
import kandid.soup.NormalizedGene;
import kandid.soup.RandomWalkPointGene;
import kandid.soup.SymmetricGene;
import kandid.soup.VoronoiChromosomeBase;
import kandid.soup.genetic.voronoi.Randomizer;
import kandid.util.CentralRandomizer;

public class MutatorBase {
    public static int mutate(Environment env, VoronoiChromosomeBase chromosome) {
        int mutationCounter = MutatorBase.mutate_members(env, chromosome);
        return mutationCounter;
    }

    protected static int mutate_members(Environment env, VoronoiChromosomeBase chromosome) {
        int mutationCounter = 0;
        List<DistanceFunctionGene> dist = chromosome.getDistance();
        int len = dist.size();
        int di = 0;
        while (di < len) {
            if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
                mutationCounter += MutatorBase.mutate_distance(env, dist.get(di));
            }
            ++di;
        }
        if (dist.size() > 3 && CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            dist.remove(CentralRandomizer.getInt(0, dist.size() - 1));
            ++mutationCounter;
        } else if (dist.size() < 4 && CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            dist.add(Randomizer.randomize_distance());
            ++mutationCounter;
        }
        List<KingGene> kings = chromosome.getKing();
        len = kings.size();
        int di2 = 0;
        while (di2 < len) {
            if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
                mutationCounter += MutatorBase.mutate_king(env, kings.get(di2));
            }
            ++di2;
        }
        if (kings.size() > 3 && CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            kings.remove(CentralRandomizer.getInt(0, kings.size() - 1));
            ++mutationCounter;
        } else if (kings.size() < 49 && CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            kings.add(Randomizer.randomize_king());
            ++mutationCounter;
        }
        return mutationCounter;
    }

    private static int mutate_king(Environment env, KingGene kingGene) {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            MutatorBase.mutate_point(env, kingGene.getPoint());
            ++mutationCounter;
        }
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            mutationCounter += MutatorBase.mutate_color(env, kingGene.getColor());
        }
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            mutationCounter += MutatorBase.mutate_NormalizedGene(env, kingGene.getWeight());
        }
        return mutationCounter;
    }

    private static int mutate_color(Environment env, ColorGene color) {
        int mutationCounter = 0;
        ColorF32 rgb = new ColorF32(color.getRed().floatValue(), color.getGreen().floatValue(), color.getBlue().floatValue());
        ColorF32 hsb = new ColorF32();
        ColorF32 old = new ColorF32();
        ColorF32.rgb2hsb(rgb, hsb);
        ColorF32.copy(rgb, old);
        double scale = env.getScaleFactor();
        hsb.r += (float)(scale * CentralRandomizer.getGaussian());
        while ((double)hsb.r < 0.0) {
            hsb.r = (float)((double)hsb.r + 1.0);
        }
        while ((double)hsb.r > 1.0) {
            hsb.r = (float)((double)hsb.r - 1.0);
        }
        hsb.g += (float)(scale * CentralRandomizer.getGaussian());
        if ((double)hsb.g < 0.0) {
            hsb.g = 0.0f;
        } else if ((double)hsb.g > 1.0) {
            hsb.g = 1.0f;
        }
        hsb.b += (float)(scale * CentralRandomizer.getGaussian());
        if ((double)hsb.b < 0.0) {
            hsb.b = 0.0f;
        } else if ((double)hsb.b > 1.0) {
            hsb.b = 1.0f;
        }
        ColorF32.hsb2rgb(hsb, rgb);
        color.setRed(Float.valueOf(rgb.r));
        color.setGreen(Float.valueOf(rgb.g));
        color.setBlue(Float.valueOf(rgb.b));
        return mutationCounter += old.r != rgb.r || old.g != rgb.g || old.b != rgb.b ? 1 : 0;
    }

    private static void mutate_point(Environment env, RandomWalkPointGene point) {
        double radius = CentralRandomizer.getDouble(env.getScaleFactor());
        double angle = CentralRandomizer.getDouble(-Math.PI, Math.PI);
        point.setX(point.getX() + radius * Math.cos(angle));
        point.setY(point.getY() + radius * Math.sin(angle));
    }

    private static int mutate_distance(Environment env, DistanceFunctionGene distanceFunctionGene) {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            DistanceFunctionBase old_var = distanceFunctionGene.getDistanceFunction();
            DistanceFunctionBase[] possible_vars = DistanceFunctionBase.values();
            DistanceFunctionBase new_var = possible_vars[CentralRandomizer.getInt(possible_vars.length - 1)];
            distanceFunctionGene.setDistanceFunction(new_var);
            mutationCounter += old_var != new_var ? 1 : 0;
        }
        return mutationCounter;
    }

    protected static int mutate_SymmetricGene(Environment env, SymmetricGene gene) {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            double oldValue = gene.getValue();
            double newValue = oldValue + env.getScaleFactor() * CentralRandomizer.getGaussian();
            if (newValue < -1.0) {
                newValue = -1.0;
            } else if (newValue > 1.0) {
                newValue = 1.0;
            }
            gene.setValue(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        return mutationCounter;
    }

    private static int mutate_NormalizedGene(Environment env, NormalizedGene gene) {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            double oldValue = gene.getValue();
            double newValue = oldValue + env.getScaleFactor() * CentralRandomizer.getGaussian();
            if (newValue < 0.0) {
                newValue = 0.0;
            } else if (newValue > 1.0) {
                newValue = 1.0;
            }
            gene.setValue(newValue);
            mutationCounter += oldValue != newValue ? 1 : 0;
        }
        return mutationCounter;
    }
}

