/*
 * Decompiled with CFR 0.152.
 */
package kandid.soup.genetic.vectorvm;

import java.util.List;
import kandid.soup.DoubleGene;
import kandid.soup.ExprVectorArgsListGene;
import kandid.soup.ExprVectorConstGene;
import kandid.soup.ExprVectorListGene;
import kandid.soup.ExprVectorOprBase;
import kandid.soup.ExprVectorOprGene;
import kandid.soup.ExprVectorVarBase;
import kandid.soup.ExprVectorVarGene;
import kandid.soup.GeneType;
import kandid.soup.ObjectFactory;
import kandid.soup.SeedGene;
import kandid.soup.VectorExprGene;
import kandid.soup.VectorExpressionChromosome;
import kandid.util.CentralRandomizer;

public class Randomizer {
    private static ObjectFactory objectFactory = new ObjectFactory();

    public static VectorExpressionChromosome create() {
        VectorExpressionChromosome chromosome = objectFactory.createVectorExpressionChromosome();
        VectorExprGene new_scalarExpression = objectFactory.createVectorExprGene();
        Randomizer.randomize(new_scalarExpression, 1);
        chromosome.setVectorExpression(new_scalarExpression);
        SeedGene new_noiseSeed = objectFactory.createSeedGene();
        new_noiseSeed.setValue(CentralRandomizer.getLong());
        chromosome.setNoiseSeed(new_noiseSeed);
        return chromosome;
    }

    static void randomize(VectorExprGene aVectorExpression, int depth) {
        ExprVectorListGene new_list = objectFactory.createExprVectorListGene();
        aVectorExpression.setList(new_list);
        new_list.setOpr(Randomizer.randomize_opr());
        new_list.setArgs(Randomizer.randomize_argslist(depth + 1));
    }

    private static ExprVectorArgsListGene randomize_argslist(int depth) {
        ExprVectorArgsListGene new_argslist = objectFactory.createExprVectorArgsListGene();
        List<GeneType> vce1_list = new_argslist.getVarOrConstOrVectorExpression();
        int len = CentralRandomizer.getInt(2, 2);
        while (len > 0) {
            switch (CentralRandomizer.getInt(1, 3)) {
                case 1: {
                    vce1_list.add(Randomizer.randomize_var());
                    --len;
                    break;
                }
                case 2: {
                    vce1_list.add(Randomizer.randomize_const());
                    --len;
                    break;
                }
                case 3: {
                    if (!(CentralRandomizer.getDouble(0.0, 0.15) < 1.0 / (double)depth)) break;
                    VectorExprGene new_scalar_expression = objectFactory.createVectorExprGene();
                    Randomizer.randomize(new_scalar_expression, depth + 1);
                    vce1_list.add(new_scalar_expression);
                    --len;
                }
            }
        }
        return new_argslist;
    }

    static ExprVectorConstGene randomize_const() {
        ExprVectorConstGene new_const = objectFactory.createExprVectorConstGene();
        DoubleGene new_double = objectFactory.createDoubleGene();
        new_double.setValue(CentralRandomizer.getDouble(-1.0, 1.0));
        new_const.setCx(new_double);
        new_double = objectFactory.createDoubleGene();
        new_double.setValue(CentralRandomizer.getDouble(-1.0, 1.0));
        new_const.setCy(new_double);
        new_double = objectFactory.createDoubleGene();
        new_double.setValue(CentralRandomizer.getDouble(-1.0, 1.0));
        new_const.setCz(new_double);
        return new_const;
    }

    static ExprVectorVarGene randomize_var() {
        ExprVectorVarBase[] possible_vars = ExprVectorVarBase.values();
        ExprVectorVarBase new_var = possible_vars[CentralRandomizer.getInt(possible_vars.length - 1)];
        ExprVectorVarGene new_var_gene = objectFactory.createExprVectorVarGene();
        new_var_gene.setVectorVar(new_var);
        return new_var_gene;
    }

    private static ExprVectorOprGene randomize_opr() {
        ExprVectorOprGene new_opr_gene = objectFactory.createExprVectorOprGene();
        ExprVectorOprBase[] possible_oprs = ExprVectorOprBase.values();
        ExprVectorOprBase new_opr = possible_oprs[CentralRandomizer.getInt(possible_oprs.length - 1)];
        new_opr_gene.setVectorOpr(new_opr);
        return new_opr_gene;
    }
}

