/*
 * Decompiled with CFR 0.152.
 */
package kandid.soup.genetic.scalarvm;

import java.util.Collections;
import java.util.List;
import kandid.Environment;
import kandid.soup.ExprScalarConstGene;
import kandid.soup.ExprScalarListGene;
import kandid.soup.ExprScalarOprBase;
import kandid.soup.ExprScalarVarBase;
import kandid.soup.ExprScalarVarGene;
import kandid.soup.GeneType;
import kandid.soup.ObjectFactory;
import kandid.soup.ScalarExprGene;
import kandid.soup.ScalarExpressionChromosome;
import kandid.soup.SeedGene;
import kandid.soup.genetic.scalarvm.Randomizer;
import kandid.util.CentralRandomizer;

public class Mutator {
    private static ObjectFactory objectFactory = new ObjectFactory();

    public static int mutate(Environment env, ScalarExpressionChromosome aChromosome) {
        int mutationCounter = 0;
        mutationCounter += Mutator.mutate_seed(env, aChromosome.getNoiseSeed());
        return mutationCounter += Mutator.mutate(env, aChromosome.getScalarExpression(), 1);
    }

    private static int mutate(Environment env, ScalarExprGene scalarExpression, int depth) {
        int mutationCounter = 0;
        ExprScalarListGene expr_list = scalarExpression.getList();
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            ExprScalarOprBase old_opr = expr_list.getOpr().getScalarOpr();
            ExprScalarOprBase[] possible_oprs = ExprScalarOprBase.values();
            ExprScalarOprBase new_opr = possible_oprs[CentralRandomizer.getInt(possible_oprs.length - 1)];
            expr_list.getOpr().setScalarOpr(new_opr);
            mutationCounter += old_opr != new_opr ? 1 : 0;
        }
        List<GeneType> vce1_list = expr_list.getArgs().getVarOrConstOrScalarExpression();
        int length1 = vce1_list.size();
        int ci = 0;
        while (ci < length1) {
            GeneType vce1 = vce1_list.get(ci);
            if (vce1 instanceof ExprScalarVarGene) {
                mutationCounter += Mutator.mutate_var_gene(env, (ExprScalarVarGene)vce1);
            } else if (vce1 instanceof ExprScalarConstGene) {
                mutationCounter += Mutator.mutate_const_gene(env, (ExprScalarConstGene)vce1);
            } else if (vce1 instanceof ScalarExprGene) {
                mutationCounter += Mutator.mutate(env, (ScalarExprGene)vce1, depth + 1);
            } else assert (false) : "no strategy for mutating " + vce1.getClass().getName();
            ++ci;
        }
        if (vce1_list.size() > 3 && CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            vce1_list.remove(CentralRandomizer.getInt(0, vce1_list.size() - 1));
            ++mutationCounter;
        } else if (vce1_list.size() < 4 && CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            switch (CentralRandomizer.getInt(1, 3)) {
                case 1: {
                    vce1_list.add(Randomizer.randomize_var());
                    break;
                }
                case 2: {
                    vce1_list.add(Randomizer.randomize_const());
                    break;
                }
                case 3: {
                    ScalarExprGene new_scalarExpression = objectFactory.createScalarExprGene();
                    Randomizer.randomize(new_scalarExpression, depth + 1);
                    vce1_list.add(new_scalarExpression);
                }
            }
            ++mutationCounter;
        }
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            Collections.shuffle(vce1_list);
            ++mutationCounter;
        }
        return mutationCounter;
    }

    private static int mutate_const_gene(Environment env, ExprScalarConstGene const_gene) {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            double old_const = const_gene.getScalarConst().getValue();
            double new_const = old_const + env.getScaleFactor() * CentralRandomizer.getGaussian();
            if (new_const < -1.0) {
                new_const = -1.0;
            } else if (new_const > 1.0) {
                new_const = 1.0;
            }
            const_gene.getScalarConst().setValue(new_const);
            mutationCounter += old_const != new_const ? 1 : 0;
        }
        return mutationCounter;
    }

    private static int mutate_var_gene(Environment env, ExprScalarVarGene var_gene) {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            ExprScalarVarBase old_var = var_gene.getScalarVar();
            ExprScalarVarBase[] possible_vars = ExprScalarVarBase.values();
            ExprScalarVarBase new_var = possible_vars[CentralRandomizer.getInt(possible_vars.length - 1)];
            var_gene.setScalarVar(new_var);
            mutationCounter += old_var != new_var ? 1 : 0;
        }
        return mutationCounter;
    }

    private static int mutate_seed(Environment env, SeedGene aGene) {
        int mutationCounter = 0;
        if (CentralRandomizer.getDouble(1.0) < env.getMutationRate()) {
            long old_seed = aGene.getValue();
            long new_seed = CentralRandomizer.getLong();
            aGene.setValue(new_seed);
            mutationCounter += old_seed != new_seed ? 1 : 0;
        }
        return mutationCounter;
    }
}

