/*
 * Decompiled with CFR 0.152.
 */
package kandid.soup.genetic.lsys;

import java.util.ArrayList;
import java.util.List;
import kandid.soup.AlphabetGene;
import kandid.soup.AxiomGene;
import kandid.soup.ContextGene;
import kandid.soup.IgnoreGene;
import kandid.soup.LsysChromosome;
import kandid.soup.PredecessorGene;
import kandid.soup.SuccessorGene;
import kandid.util.CentralRandomizer;

public abstract class LsysGeneticWorker {
    public abstract String randomizeAlphabet(LsysChromosome var1);

    protected List randomizeAlphabetList(LsysChromosome lsysChromosome) {
        ArrayList<String> alphabethList = new ArrayList<String>();
        alphabethList.add(new String("F"));
        if (CentralRandomizer.getDouble(1.0) < 0.5) {
            alphabethList.add(new String("f"));
        }
        if (CentralRandomizer.getDouble(1.0) < 0.5) {
            alphabethList.add(new String("A"));
        }
        if (CentralRandomizer.getDouble(1.0) < 0.3333333333333333) {
            alphabethList.add(new String("B"));
        }
        if (CentralRandomizer.getDouble(1.0) < 0.25) {
            alphabethList.add(new String("C"));
        }
        if (CentralRandomizer.getDouble(1.0) < 0.2) {
            alphabethList.add(new String("D"));
        }
        if (CentralRandomizer.getDouble(1.0) < 0.75) {
            alphabethList.add(new String("+"));
        }
        if (CentralRandomizer.getDouble(1.0) < 0.75) {
            alphabethList.add(new String("-"));
        }
        if (CentralRandomizer.getDouble(1.0) < 0.25) {
            alphabethList.add(new String("|"));
        }
        if (CentralRandomizer.getDouble(1.0) < 0.5) {
            alphabethList.add(new String("."));
        }
        if (CentralRandomizer.getDouble(1.0) < 0.25) {
            alphabethList.add(new String("'"));
        }
        if (CentralRandomizer.getDouble(1.0) < 0.25) {
            alphabethList.add(new String(","));
        }
        if (CentralRandomizer.getDouble(1.0) < 0.25) {
            alphabethList.add(new String(":"));
        }
        if (CentralRandomizer.getDouble(1.0) < 0.25) {
            alphabethList.add(new String(";"));
        }
        return alphabethList;
    }

    public String randomizeAxiom(LsysChromosome lsysChromosome) {
        String alphabeth = lsysChromosome.getAlphabet().getValue();
        int len = CentralRandomizer.getInt(1, 6);
        StringBuffer characters = new StringBuffer();
        while (len > 0) {
            characters.append(alphabeth.charAt(CentralRandomizer.getInt(0, alphabeth.length() - 1)));
            --len;
        }
        return characters.toString();
    }

    public String randomizePredecessor(LsysChromosome lsysChromosome) {
        String alphabeth = lsysChromosome.getAlphabet().getValue();
        StringBuffer characters = new StringBuffer();
        characters.append(alphabeth.charAt(CentralRandomizer.getInt(0, alphabeth.length() - 1)));
        return characters.toString();
    }

    public String randomizeContext(LsysChromosome lsysChromosome) {
        return "";
    }

    public String randomizeSuccessor(LsysChromosome lsysChromosome) {
        String alphabeth = lsysChromosome.getAlphabet().getValue();
        int len = CentralRandomizer.getInt(1, 20);
        StringBuffer characters = new StringBuffer();
        int needsBranchClosure = 0;
        int needsLeafClosure = 0;
        while (len > 0) {
            double probabilityBranchClosure = (double)(needsBranchClosure + needsLeafClosure) / (double)len;
            double probabilityLeafClosure = (double)(needsBranchClosure + needsLeafClosure) / (double)len;
            if (needsBranchClosure > 0 && CentralRandomizer.getDouble(1.0) < probabilityBranchClosure + 0.01) {
                characters.append(']');
                --needsBranchClosure;
            } else if (needsBranchClosure + needsLeafClosure < len - 1 && CentralRandomizer.getDouble(1.0) < 1.0 / (double)(alphabeth.length() + 2)) {
                characters.append('[');
                ++needsBranchClosure;
            } else if (needsLeafClosure > 0 && CentralRandomizer.getDouble(1.0) < probabilityLeafClosure + 0.01) {
                characters.append('}');
                --needsLeafClosure;
            } else if (needsBranchClosure + needsLeafClosure < len - 1 && CentralRandomizer.getDouble(1.0) < 1.0 / (double)(alphabeth.length() + 2)) {
                characters.append('{');
                ++needsLeafClosure;
            } else {
                characters.append(alphabeth.charAt(CentralRandomizer.getInt(0, alphabeth.length() - 1)));
            }
            assert (needsBranchClosure >= 0);
            assert (needsLeafClosure >= 0);
            --len;
        }
        return characters.toString();
    }

    public String randomizeIgnore(LsysChromosome lsysChromosome) {
        return "";
    }

    public void mutateAlphabet(AlphabetGene aGene, LsysChromosome lsysChromosome) {
    }

    public void mutateAxiom(AxiomGene aGene, LsysChromosome lsysChromosome) {
        String alphabeth = lsysChromosome.getAlphabet().getValue();
        char[] chars = aGene.getValue().toCharArray();
        int pos = CentralRandomizer.getInt(0, chars.length - 1);
        chars[pos] = alphabeth.charAt(CentralRandomizer.getInt(0, alphabeth.length() - 1));
        aGene.setValue(new String(chars));
    }

    public void mutatePredecessor(PredecessorGene aGene, LsysChromosome lsysChromosome) {
        String alphabeth = lsysChromosome.getAlphabet().getValue();
        char[] chars = aGene.getValue().toCharArray();
        assert (chars.length == 1);
        chars[0] = alphabeth.charAt(CentralRandomizer.getInt(0, alphabeth.length() - 1));
        aGene.setValue(new String(chars));
    }

    public void mutateContext(ContextGene aGene, LsysChromosome lsysChromosome) {
    }

    public void mutateSuccessor(SuccessorGene aGene, LsysChromosome lsysChromosome) {
        StringBuffer chars = null;
        do {
            chars = new StringBuffer(aGene.getValue());
            int pos1 = CentralRandomizer.getInt(0, chars.length() - 1);
            int pos2 = CentralRandomizer.getInt(0, chars.length() - 1);
            char temp = chars.charAt(pos1);
            chars.setCharAt(pos1, chars.charAt(pos2));
            chars.setCharAt(pos2, temp);
        } while (!this.invariant(chars));
        aGene.setValue(new String(chars));
    }

    public void mutateIgnore(IgnoreGene aGene, LsysChromosome lsysChromosome) {
    }

    private boolean invariant(StringBuffer characters) {
        int branchClosureCount = 0;
        int leafClosureCount = 0;
        int ix = 0;
        while (ix < characters.length()) {
            char character = characters.charAt(ix);
            if (character == '[') {
                ++branchClosureCount;
            } else if (character == ']') {
                --branchClosureCount;
            } else if (character == '{') {
                ++leafClosureCount;
            } else if (character == '}') {
                --leafClosureCount;
            }
            if (branchClosureCount < 0) {
                return false;
            }
            if (leafClosureCount < 0) {
                return false;
            }
            ++ix;
        }
        return branchClosureCount == 0 && leafClosureCount == 0;
    }

    public abstract int getNumberOfProductions(LsysChromosome var1);

    public boolean reject(LsysChromosome lsysChromosome) {
        return false;
    }
}

