/*
 * Decompiled with CFR 0.152.
 */
package kandid.preference.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import kandid.Console;
import kandid.preference.GenomeDBType;
import kandid.preference.HttpProxyType;
import kandid.preference.KandidType;
import kandid.preference.ObjectFactory;
import kandid.preference.OutgoingMailType;
import kandid.preference.PreferenceType;
import kandid.preference.UserType;
import kandid.util.Debug;

public class PreferenceModel {
    private static PreferenceModel preferencModel;
    private PreferenceType preference;
    private JAXBContext jc;
    private ObjectFactory objectFactory = new ObjectFactory();

    private PreferenceModel() {
        try {
            this.jc = JAXBContext.newInstance((String)"kandid.preference");
        }
        catch (JAXBException exc) {
            Debug.stackTrace(exc);
        }
        this.unmarshalFromFile();
    }

    public static PreferenceModel getInstance() {
        if (preferencModel == null) {
            preferencModel = new PreferenceModel();
        }
        return preferencModel;
    }

    public void marshalToFile() {
        try {
            FileOutputStream out = new FileOutputStream("./kandid.preferences");
            Marshaller m = this.jc.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)this.preference, (OutputStream)out);
            out.close();
            Console.append("store preferences " + String.valueOf(new File("./kandid.preferences").getAbsoluteFile()));
        }
        catch (JAXBException je) {
            Debug.stackTrace(je);
        }
        catch (IOException ioe) {
            Debug.stackTrace(ioe);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
    }

    public Object unmarshalFromFile() {
        this.preference = null;
        try {
            Unmarshaller u = this.jc.createUnmarshaller();
            try {
                this.preference = (PreferenceType)u.unmarshal((InputStream)new FileInputStream("./kandid.preferences"));
                Console.append("reading preferences " + String.valueOf(new File("./kandid.preferences").getAbsoluteFile()));
            }
            catch (FileNotFoundException exc) {
                PreferenceType defaultPreference = null;
                defaultPreference = this.objectFactory.createPreferenceType();
                Console.append("missing preferences " + String.valueOf(new File("./kandid.preferences").getAbsoluteFile()));
                this.preference = defaultPreference;
            }
            this.addDefaults();
        }
        catch (JAXBException je) {
            Debug.stackTrace(je);
        }
        return this.preference;
    }

    private void addDefaults() throws JAXBException {
        if (this.preference == null) {
            this.preference = this.objectFactory.createPreferenceType();
        }
        if (this.preference.getKandid() == null) {
            KandidType kandid = this.objectFactory.createKandidType();
            kandid.setHome("http://");
            this.preference.setKandid(kandid);
        }
        if (this.preference.getUser() == null) {
            UserType user = this.objectFactory.createUserType();
            user.setNickname("");
            user.setEmail("");
            this.preference.setUser(user);
        }
        if (this.preference.getOutgoingMail() == null) {
            OutgoingMailType outgoingMail = this.objectFactory.createOutgoingMailType();
            outgoingMail.setSmptHost("");
            this.preference.setOutgoingMail(outgoingMail);
        }
        if (this.preference.getHttpProxy() == null) {
            HttpProxyType httpProxy = this.objectFactory.createHttpProxyType();
            httpProxy.setEnabled(false);
            httpProxy.setHost("");
            httpProxy.setPort(80);
            httpProxy.setNonProxyHosts("");
            httpProxy.setUsername("");
            httpProxy.setPassword("****");
            this.preference.setHttpProxy(httpProxy);
        }
        if (this.preference.getGenomeDB() == null) {
            GenomeDBType genomeDBType = this.objectFactory.createGenomeDBType();
            genomeDBType.setURL("http://www.???.org/KandidGenomeDBv1/KandidConnector_v1.php");
            genomeDBType.setInstallationId(0);
            genomeDBType.setTimeout(50000);
            this.preference.setGenomeDB(genomeDBType);
        }
    }

    public boolean checkOutgoingMailCompleted() {
        boolean completed = false;
        if (this.preference != null && this.preference.getUser() != null && this.preference.getOutgoingMail() != null && this.preference.getHttpProxy() != null) {
            completed = this.preference.getUser().getNickname().length() > 0 && this.preference.getOutgoingMail().getSmptHost().length() > 0 && (!this.preference.getHttpProxy().isEnabled() || this.preference.getHttpProxy().getHost().length() > 0);
        }
        return completed;
    }

    public boolean checkLoadGenomeDBCompleted() {
        boolean completed = false;
        if (this.preference != null && this.preference.getHttpProxy() != null && this.preference.getGenomeDB() != null) {
            completed = !this.preference.getHttpProxy().isEnabled() || this.preference.getHttpProxy().getHost().length() > 0;
        }
        return completed;
    }

    public boolean checkExportGenomeDBCompleted() {
        boolean completed = false;
        if (this.preference != null && this.preference.getUser() != null && this.preference.getHttpProxy() != null && this.preference.getGenomeDB() != null) {
            completed = this.preference.getUser().getNickname().length() > 0 && (!this.preference.getHttpProxy().isEnabled() || this.preference.getHttpProxy().getHost().length() > 0);
        }
        return completed;
    }

    public boolean fileExists() {
        return new File("./kandid.preferences").exists();
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public PreferenceType getPreference() {
        return this.preference;
    }
}

