/*
 * Decompiled with CFR 0.152.
 */
package kandid.pond.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import kandid.pond.BreederType;
import kandid.pond.PondType;

public class BreederListConnection {
    String randomBreederURL;
    PondType pond;

    private InputStream getInputStream() throws IOException, URISyntaxException {
        InputStream in = null;
        URL url = new URI(this.randomBreederURL).toURL();
        HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
        int resp = httpConnection.getResponseCode();
        if (resp == 200) {
            in = httpConnection.getInputStream();
        }
        return in;
    }

    public void readPond(String randomBreederURL) throws JAXBException, IOException, URISyntaxException {
        this.randomBreederURL = randomBreederURL;
        JAXBContext jc = JAXBContext.newInstance((String)"kandid.pond");
        Unmarshaller u = jc.createUnmarshaller();
        this.pond = (PondType)u.unmarshal(this.getInputStream());
    }

    public BreederType getRandomBreeder() {
        BreederType breederType = null;
        List<BreederType> breederList = this.pond.getBreeder();
        if (breederList != null && breederList.size() > 0) {
            breederType = breederList.get(0);
        }
        return breederType;
    }
}

