/*
 * Decompiled with CFR 0.152.
 */
package kandid.pond.ui;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import kandid.Gateway;
import kandid.ImageTransferHandler;
import kandid.ViewEngine;
import kandid.calculation.Calculation;
import kandid.catalog.CalculationType;
import kandid.catalog.CatalogType;
import kandid.catalog.ModelType;
import kandid.colorator.Colorator;
import kandid.colorator.ColoratorFactory;
import kandid.extensions.ExportState;
import kandid.extensions.FileList;
import kandid.pond.ui.IlLoadWizzard;
import kandid.pond.ui.TypeDescription;
import kandid.pond.ui.UiPool;
import kandid.preference.ui.IlPreference;
import kandid.soup.ChromosomeType;
import kandid.soup.ColoratorType;
import kandid.soup.EntityType;
import kandid.soup.ImageType;
import kandid.soup.util.ChromosomeStamp;
import kandid.soup.util.SoupFactory;
import kandid.util.Debug;

public class IlPool {
    private static IlPool wizzard = null;
    private UiPool uiPool;
    private TypeDescription selectedType = null;
    private String[] filenameList;
    private Vector<String> chromosomeList;
    private int startPos;
    private ViewEngine[] viewEngine;
    private EntityType[] entity;
    private DefaultTreeModel typeTreeModel;
    private SoupFactory soupFactory;
    private boolean loading;

    public static IlPool showInstance() {
        IlPool.getInstance();
        IlPool.wizzard.uiPool.setVisible(true);
        return wizzard;
    }

    public static IlPool getInstance() {
        if (wizzard == null) {
            wizzard = new IlPool();
            wizzard.initialize();
            IlPool.wizzard.uiPool.pack();
        }
        return wizzard;
    }

    private void initialize() {
        this.uiPool = new UiPool(this);
        this.uiPool.getBothRadioButton().setSelected(false);
        this.uiPool.getLoadButton().setEnabled(false);
        this.soupFactory = SoupFactory.getSoupFactory();
        this.chromosomeList = new Vector();
        this.viewEngine = new ViewEngine[10];
        this.entity = new EntityType[this.viewEngine.length];
        int ix = 0;
        while (ix < this.viewEngine.length) {
            this.viewEngine[ix] = null;
            this.entity[ix] = null;
            ++ix;
        }
        this.initTreeModel();
        this.startPos = 0;
        this.activateView();
        this.uiPool.getPoolContentPane().setTransferHandler(new ImageTransferHandler(true));
        this.uiPool.getPoolPanel().setTransferHandler(new ImageTransferHandler(true));
        this.uiPool.getTypeTree().setTransferHandler(new ImageTransferHandler(true));
        this.uiPool.getViewPanel().setTransferHandler(new ImageTransferHandler(true));
    }

    public void load() {
        if (this.selectedType != null) {
            this.loading = true;
            this.uiPool.getLoadButton().setEnabled(false);
            IlLoadWizzard ilLoadWizzard = IlLoadWizzard.showInstance();
            ilLoadWizzard.setQueryCalulationName(this.selectedType.calcClassName);
            ilLoadWizzard.setQueryColoratorName(this.selectedType.colorClassName);
        }
    }

    public void finalizeLoad(boolean isCanceled) {
        this.loading = false;
        this.uiPool.getLoadButton().setEnabled(this.selectedType != null);
        if (!isCanceled) {
            this.activateView();
        }
    }

    private void initTreeModel() {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"kandid.catalog");
            Unmarshaller u = jc.createUnmarshaller();
            JAXBElement uo = (JAXBElement)u.unmarshal(this.getClass().getResourceAsStream("/kandid/catalog/catalog.xml"));
            CatalogType catalog = (CatalogType)uo.getValue();
            List<CalculationType> calculationList = catalog.getCalculation();
            JTree typeTree = this.uiPool.getTypeTree();
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
            rootNode.setUserObject("Pool");
            this.typeTreeModel = new DefaultTreeModel(rootNode);
            typeTree.setModel(this.typeTreeModel);
            for (CalculationType calculationType : calculationList) {
                DefaultMutableTreeNode calcNode = new DefaultMutableTreeNode();
                String calculationName = calculationType.getName();
                calcNode.setUserObject(calculationName);
                List<ModelType> modelList = calculationType.getModel();
                for (ModelType modelType : modelList) {
                    try {
                        Class<?> cc = Class.forName(modelType.getColoratorClass());
                        Colorator colorator = (Colorator)cc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        DefaultMutableTreeNode colorNode = new DefaultMutableTreeNode();
                        TypeDescription colorDescription = new TypeDescription(modelType.getCalculationClass(), calculationName, modelType.getColoratorClass(), colorator.getShortName());
                        colorNode.setUserObject(colorDescription);
                        calcNode.add(colorNode);
                    }
                    catch (Exception exc) {
                        Debug.stackTrace(exc);
                    }
                }
                rootNode.add(calcNode);
            }
            typeTree.expandPath(new TreePath(rootNode));
        }
        catch (JAXBException exc) {
            Debug.stackTrace(exc);
        }
    }

    protected void activateView() {
        boolean displayExported = true;
        boolean displayIncoming = false;
        this.chromosomeList.clear();
        if (this.selectedType != null) {
            ArrayList<Object> filenameListExported = new ArrayList();
            ArrayList<Object> filenameListIncoming = new ArrayList();
            if (displayExported) {
                filenameListExported = FileList.createImageList("./filebase", this.buildName(), ".kimg");
            }
            if (displayIncoming) {
                filenameListIncoming = FileList.createImageList("./incoming", this.buildName(), ".kimg");
            }
            ArrayList<Object> sum = new ArrayList<Object>(filenameListExported.size() + filenameListIncoming.size());
            int i1 = 0;
            while (i1 < filenameListIncoming.size()) {
                sum.add(filenameListIncoming.get(i1));
                ++i1;
            }
            int i2 = 0;
            while (i2 < filenameListExported.size()) {
                sum.add(filenameListExported.get(i2));
                ++i2;
            }
            this.filenameList = new String[sum.size()];
            this.filenameList = sum.toArray(this.filenameList);
            int fx = 0;
            while (fx < this.filenameList.length) {
                try {
                    StringBuffer chromosomeBuffer = new StringBuffer();
                    String chromosome = null;
                    File inf = new File(this.filenameList[fx]);
                    int len = (int)inf.length();
                    FileReader in = new FileReader(inf);
                    char[] buffer = new char[len];
                    while (in.read(buffer) > 0) {
                        chromosomeBuffer.append(buffer);
                    }
                    chromosome = chromosomeBuffer.toString();
                    if (!this.chromosomeList.contains(chromosome)) {
                        this.chromosomeList.add(chromosome);
                    }
                    in.close();
                }
                catch (IOException exc) {
                    Debug.stackTrace(exc);
                }
                ++fx;
            }
        }
        this.goTop();
    }

    private String buildName() {
        return this.selectedType.calcShortName + "_" + this.selectedType.colorShortName;
    }

    private void clean() {
        int ix = 0;
        while (ix < this.viewEngine.length) {
            if (this.viewEngine[ix] != null) {
                this.viewEngine[ix].stop();
                this.viewEngine[ix] = null;
            }
            ++ix;
        }
        this.uiPool.getViewPanel().removeAll();
    }

    private void next(int start) {
        int size = this.chromosomeList.size();
        int vx = 0;
        while (vx < this.viewEngine.length) {
            int px = start + vx;
            if (px < size) {
                this.entity[vx] = (EntityType)this.soupFactory.unmarshalFromString(this.chromosomeList.get(px));
                ChromosomeType chromosome = this.soupFactory.getChromosome(this.entity[vx]);
                Calculation calculation = new Gateway().createCalculation(this.soupFactory.getCalculationName(this.entity[vx]));
                ColoratorType coloratorType = this.soupFactory.getColorator(this.entity[vx]);
                String coloratorName = this.soupFactory.getColoratorName(this.entity[vx]);
                Colorator colorator = ColoratorFactory.createColoratorWorker(coloratorName, coloratorType);
                this.viewEngine[vx] = new ViewEngine(100, 6, 6, null, this);
                Object author = this.soupFactory.getImage(this.entity[vx]).getAuthor();
                author = author == null || ((String)author).length() == 0 ? "unknown author" : "Author: " + (String)author;
                this.viewEngine[vx].setToolTipText((String)author);
                this.viewEngine[vx].addMouseListener(wizzard.new DragMouseAdapter());
                this.viewEngine[vx].setTransferHandler(new ImageTransferHandler(true));
                this.uiPool.getViewPanel().add(this.viewEngine[vx]);
                this.viewEngine[vx].prepare(chromosome, calculation, colorator);
                this.viewEngine[vx].start();
            } else {
                JLabel empty = new JLabel("");
                empty.setMinimumSize(new Dimension(100, 100));
                empty.setPreferredSize(new Dimension(100, 100));
                empty.setTransferHandler(new ImageTransferHandler(true));
                this.uiPool.getViewPanel().add(empty);
                this.entity[vx] = null;
                this.viewEngine[vx] = null;
            }
            ++vx;
        }
        this.enableButtons();
        this.uiPool.getViewPanel().repaint();
    }

    protected void goTop() {
        this.clean();
        this.startPos = 0;
        this.next(this.startPos);
    }

    protected void goBottom() {
        this.clean();
        this.startPos = this.chromosomeList.size() - this.viewEngine.length;
        if (this.startPos < 0) {
            this.startPos = 0;
        }
        this.next(this.startPos);
    }

    protected void goForward() {
        this.clean();
        this.startPos += this.viewEngine.length;
        this.next(this.startPos);
    }

    protected void goBackward() {
        this.clean();
        this.startPos -= this.viewEngine.length;
        if (this.startPos < 0) {
            this.startPos = 0;
        }
        this.next(this.startPos);
    }

    public EntityType getEntity(ViewEngine aViewEngine) {
        int vx = 0;
        while (vx < this.viewEngine.length) {
            if (this.viewEngine[vx] == aViewEngine) {
                return this.entity[vx];
            }
            ++vx;
        }
        return null;
    }

    public void nodeSelected(TreeSelectionEvent sel) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.uiPool.getTypeTree().getLastSelectedPathComponent();
        this.selectedType = null;
        if (node != null && node.isLeaf()) {
            TreePath path = sel.getPath();
            DefaultMutableTreeNode o2 = (DefaultMutableTreeNode)path.getPathComponent(2);
            this.selectedType = (TypeDescription)o2.getUserObject();
        }
        this.uiPool.getLoadButton().setEnabled(!this.loading && this.selectedType != null);
        if (this.selectedType != null) {
            this.activateView();
        }
    }

    public void addImage(ImageType image) {
        try {
            String typeName = image.getClass().getName();
            EntityType addEntity = this.soupFactory.createEntity(image);
            this.addEntity(typeName, addEntity, true);
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
    }

    private void addEntity(String typeName, EntityType entity, boolean marshalToFile) {
        String shortColoratorName = ColoratorFactory.getShortName(this.soupFactory.getColoratorName(entity));
        ChromosomeType chromosomeType = this.soupFactory.getChromosome(entity);
        String ident = chromosomeType.getIdent();
        String filename = ChromosomeStamp.patchPopulationIdent(ident, shortColoratorName + "_pool");
        if (marshalToFile) {
            ExportState exportState = new ExportState();
            exportState.setFullname(filename);
            new File(exportState.getPath("filebase")).mkdirs();
            this.soupFactory.marshalToFile(entity, exportState.getPath("filebase") + filename + ".kimg");
        }
        this.navigateToType(this.soupFactory.getCalculationName(entity), this.soupFactory.getColoratorName(entity));
        this.activateView();
        this.enableButtons();
        this.uiPool.repaint();
    }

    private void enableButtons() {
        this.uiPool.getLastButton().setEnabled(!this.isLastPage());
        this.uiPool.getRightButton().setEnabled(!this.isLastPage());
        this.uiPool.getFirstButton().setEnabled(!this.isFirstPage());
        this.uiPool.getLeftButton().setEnabled(!this.isFirstPage());
    }

    private boolean isFirstPage() {
        return this.startPos <= 0;
    }

    private boolean isLastPage() {
        return this.startPos >= this.chromosomeList.size() - this.viewEngine.length;
    }

    public void navigateToType(String calcClassName, String colorClassName) {
        try {
            TreePath newPath = null;
            TreePath oldPath = this.uiPool.getTypeTree().getSelectionPath();
            DefaultTreeModel tm = (DefaultTreeModel)this.uiPool.getTypeTree().getModel();
            Object tr = tm.getRoot();
            int d1Count = tm.getChildCount(tr);
            int ix1 = 0;
            while (ix1 < d1Count) {
                Object calcNode = tm.getChild(tr, ix1);
                int d2Count = tm.getChildCount(calcNode);
                int ix2 = 0;
                while (ix2 < d2Count) {
                    DefaultMutableTreeNode colorNode = (DefaultMutableTreeNode)tm.getChild(calcNode, ix2);
                    TypeDescription colorDescription = (TypeDescription)colorNode.getUserObject();
                    if (colorDescription.calcClassName.equals(calcClassName) && colorDescription.colorClassName.equals(colorClassName)) {
                        Object[] newNodePath = tm.getPathToRoot(colorNode);
                        newPath = new TreePath(newNodePath);
                    }
                    ++ix2;
                }
                ++ix1;
            }
            if (newPath != null) {
                if (oldPath != null) {
                    if (!newPath.equals(oldPath)) {
                        this.uiPool.getTypeTree().removeSelectionPath(oldPath);
                        this.uiPool.getTypeTree().setSelectionPath(newPath);
                    }
                } else {
                    this.uiPool.getTypeTree().setSelectionPath(newPath);
                }
            }
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
        }
    }

    public void setVisible(boolean visible) {
        this.uiPool.setVisible(visible);
    }

    public static void main(String[] args) {
        IlPool ilPool = IlPool.getInstance();
        ilPool.navigateToType("kandid.calculation.vm.scalar.ScalarExpressionCalculation", "kandid.colorator.GradientColorator");
        ilPool = IlPool.showInstance();
    }

    public void showPreference() {
        IlPreference.showInstance(0, this.uiPool);
    }

    private class DragMouseAdapter
    extends MouseAdapter {
        private DragMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JComponent c = (JComponent)e.getSource();
            TransferHandler handler = c.getTransferHandler();
            handler.exportAsDrag(c, e, 1);
        }
    }
}

