/*
 * Decompiled with CFR 0.152.
 */
package kandid.noise;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.vecmath.Vector3d;
import junit.framework.TestCase;
import kandid.noise.ImprovedNoise;
import kandid.noise.PerlinNoise;

public class PerlinNoiseTest
extends TestCase {
    protected void renderScalarImage(int width, int height, double z, SNoiseCalculation calculation) throws IOException {
        BufferedImage image = new BufferedImage(width, height, 4);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.setColor(Color.BLACK);
        g2d.fillRect(0, 0, width, height);
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double dx = 1.0 / (double)width;
        double dy = 1.0 / (double)width;
        int ix = 0;
        while (ix < width) {
            double x = (double)ix * dx;
            int iy = 0;
            while (iy < height) {
                double y = (double)iy * dy;
                double scalar = calculation.valueAt(x, y, z);
                if (scalar < min) {
                    min = scalar;
                }
                if (scalar > max) {
                    max = scalar;
                }
                if (scalar < 0.0) {
                    g2d.setColor(Color.BLUE);
                } else if (scalar > 1.0) {
                    g2d.setColor(Color.RED);
                } else {
                    float gray = (float)scalar;
                    g2d.setColor(new Color(gray, gray, gray));
                }
                g2d.fillRect(ix, iy, 1, 1);
                ++iy;
            }
            ++ix;
        }
        String classname = calculation.getClass().getName();
        System.out.println(String.format("%+f ", min) + String.format("%+f ", max) + " " + classname);
        ImageIO.write((RenderedImage)image, "png", new File("/dev/shm/scalar_noise_" + classname + "_z" + z + ".png"));
        calculation.checkRange(min);
        calculation.checkRange(max);
    }

    protected void renderVectorImage(int width, int height, double z, SNoiseCalculation calculation) throws IOException {
        BufferedImage image = new BufferedImage(width, height, 4);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.setColor(Color.BLACK);
        g2d.fillRect(0, 0, width, height);
        Vector3d vnoise = new Vector3d();
        double xmin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        double ymin = Double.MAX_VALUE;
        double ymax = Double.MIN_VALUE;
        double zmin = Double.MAX_VALUE;
        double zmax = Double.MIN_VALUE;
        double dx = 1.0 / (double)width;
        double dy = 1.0 / (double)width;
        int ix = 0;
        while (ix < width) {
            double x = (double)ix * dx;
            int iy = 0;
            while (iy < height) {
                double y = (double)iy * dy;
                calculation.vectorAt(x, y, z, vnoise);
                if (vnoise.x < xmin) {
                    xmin = vnoise.x;
                }
                if (vnoise.x > xmax) {
                    xmax = vnoise.x;
                }
                if (vnoise.y < ymin) {
                    ymin = vnoise.y;
                }
                if (vnoise.y > ymax) {
                    ymax = vnoise.y;
                }
                if (vnoise.z < zmin) {
                    zmin = vnoise.z;
                }
                if (vnoise.z > zmax) {
                    zmax = vnoise.z;
                }
                if (vnoise.x < 0.0 || vnoise.y < 0.0 || vnoise.z < 0.0) {
                    g2d.setColor(Color.BLACK);
                } else if (vnoise.x > 1.0 || vnoise.y > 1.0 || vnoise.z > 1.0) {
                    g2d.setColor(Color.WHITE);
                } else {
                    g2d.setColor(new Color((float)vnoise.x, (float)vnoise.y, (float)vnoise.z));
                }
                g2d.fillRect(ix, iy, 1, 1);
                ++iy;
            }
            ++ix;
        }
        String classname = calculation.getClass().getName();
        System.out.println(String.format("%+f ", xmin) + String.format("%+f ", xmax) + String.format("%+f ", ymin) + String.format("%+f ", ymax) + String.format("%+f ", zmin) + String.format("%+f ", zmax) + " " + classname);
        ImageIO.write((RenderedImage)image, "png", new File("/dev/shm/vector_noise_" + classname + "_z" + z + ".png"));
        calculation.checkRange(xmin);
        calculation.checkRange(xmax);
        calculation.checkRange(ymin);
        calculation.checkRange(ymax);
        calculation.checkRange(zmin);
        calculation.checkRange(zmax);
    }

    public void testNoiseMargin() {
        ImprovedNoise improvedPerlinNoise = new ImprovedNoise();
        double x = 0.0;
        while (x <= 1.0001) {
            double y = 0.0;
            while (y <= 1.0001) {
                double z = 0.0;
                while (z <= 1.0001) {
                    double n = improvedPerlinNoise.noise(x, y, z);
                    PerlinNoiseTest.assertEquals((double)n, (double)0.0, (double)0.0);
                    System.out.print(n);
                    System.out.print(' ');
                    z += 1.0;
                }
                System.out.println();
                y += 1.0;
            }
            x += 1.0;
        }
    }

    public void testNoise() throws IOException {
        double[] z1 = new double[]{0.0, 0.1, 0.25, 0.5, 0.75, 0.9, 1.0};
        this.scanRange(z1);
        double[] z2 = new double[]{-0.1, -0.25, -0.5, -0.75, -0.9, -1.0};
        this.scanRange(z2);
        double[] z3 = new double[]{-1000.1, -100.25, -10.5, 10.75, 100.9, 1000.0};
        this.scanRange(z3);
    }

    private void scanRange(double[] z) throws IOException {
        int iz = 0;
        while (iz < z.length) {
            this.renderScalarImage(256, 256, z[iz], new RawNoiseCalculation(null));
            ++iz;
        }
        PerlinNoise perlinNoise = new PerlinNoise(1512L);
        int iz2 = 0;
        while (iz2 < z.length) {
            this.renderScalarImage(256, 256, z[iz2], new NoiseCalculation(perlinNoise));
            ++iz2;
        }
        iz2 = 0;
        while (iz2 < z.length) {
            this.renderScalarImage(256, 256, z[iz2], new TurbulenceCalculation(perlinNoise));
            ++iz2;
        }
        iz2 = 0;
        while (iz2 < z.length) {
            this.renderVectorImage(256, 256, z[iz2], new NoiseCalculation(perlinNoise));
            ++iz2;
        }
        iz2 = 0;
        while (iz2 < z.length) {
            this.renderVectorImage(256, 256, z[iz2], new TurbulenceCalculation(perlinNoise));
            ++iz2;
        }
    }

    abstract class AbstractNoiseCalculation {
        PerlinNoise perlinNoise;

        public AbstractNoiseCalculation(PerlinNoise perlinNoise) {
            this.perlinNoise = perlinNoise;
        }
    }

    class NoiseCalculation
    extends AbstractNoiseCalculation
    implements SNoiseCalculation {
        public NoiseCalculation(PerlinNoise perlinNoise) {
            super(perlinNoise);
        }

        @Override
        public double valueAt(double x, double y, double z) {
            return this.perlinNoise.unoise(x, y, z);
        }

        @Override
        public void vectorAt(double x, double y, double z, Vector3d vnoise) {
            this.perlinNoise.unoise3d(x, y, z, vnoise);
        }

        @Override
        public void checkRange(double value) {
            PerlinNoiseTest.assertTrue((value >= 0.0 ? 1 : 0) != 0);
            PerlinNoiseTest.assertTrue((value <= 1.0 ? 1 : 0) != 0);
        }
    }

    class RawNoiseCalculation
    extends AbstractNoiseCalculation
    implements SNoiseCalculation {
        ImprovedNoise improvedPerlinNoise;

        public RawNoiseCalculation(PerlinNoise perlinNoise) {
            super(null);
            this.improvedPerlinNoise = new ImprovedNoise();
        }

        @Override
        public double valueAt(double x, double y, double z) {
            return this.improvedPerlinNoise.noise(x, y, z);
        }

        @Override
        public void vectorAt(double x, double y, double z, Vector3d vnoise) {
        }

        @Override
        public void checkRange(double value) {
            PerlinNoiseTest.assertTrue((value >= -1.0 ? 1 : 0) != 0);
            PerlinNoiseTest.assertTrue((value <= 1.0 ? 1 : 0) != 0);
        }
    }

    static interface SNoiseCalculation {
        public double valueAt(double var1, double var3, double var5);

        public void checkRange(double var1);

        public void vectorAt(double var1, double var3, double var5, Vector3d var7);
    }

    class TurbulenceCalculation
    extends AbstractNoiseCalculation
    implements SNoiseCalculation {
        public TurbulenceCalculation(PerlinNoise perlinNoise) {
            super(perlinNoise);
        }

        @Override
        public double valueAt(double x, double y, double z) {
            return this.perlinNoise.uturbulence(x, y, z, 6.0, 0.5, 2.0);
        }

        @Override
        public void vectorAt(double x, double y, double z, Vector3d vnoise) {
            this.perlinNoise.uturbulence3d(x, y, z, 6, 0.5, 2.0, vnoise);
        }

        @Override
        public void checkRange(double value) {
            PerlinNoiseTest.assertTrue((value >= 0.0 ? 1 : 0) != 0);
            PerlinNoiseTest.assertTrue((value <= 1.0 ? 1 : 0) != 0);
        }
    }
}

