/*
 * Decompiled with CFR 0.152.
 */
package kandid.noise;

import javax.vecmath.Vector3d;
import kandid.noise.ImprovedNoise;

public class PerlinNoise {
    ImprovedNoise improvedPerlinNoise = new ImprovedNoise();

    public PerlinNoise(long seed) {
        this.improvedPerlinNoise.seed(seed);
    }

    public void initializeNoise(long seed) {
        this.improvedPerlinNoise.seed(seed);
    }

    public double unoise(double x, double y, double z) {
        return 0.5 * (1.0 + this.improvedPerlinNoise.noise(x, y, z));
    }

    public double snoise(double x, double y, double z) {
        return this.improvedPerlinNoise.noise(x, y, z);
    }

    public void unoise3d(double x, double y, double z, Vector3d vnoise) {
        vnoise.x = this.unoise(x + 9.321, y - 1.531, z - 7.951);
        vnoise.y = this.unoise(x, y, z);
        vnoise.z = this.unoise(x + 6.327, y + 0.1671, z - 2.672);
    }

    public void snoise3d(double x, double y, double z, Vector3d vnoise) {
        vnoise.x = this.snoise(x + 9.321, y - 1.531, z - 7.951);
        vnoise.y = this.snoise(x, y, z);
        vnoise.z = this.snoise(x + 6.327, y + 0.1671, z - 2.672);
    }

    public double uturbulence(double x, double y, double z, double octaves, double ampscale, double freqscale) {
        double amp = 1.0;
        double noise = this.unoise(x, y, z);
        int ioctaves = (int)octaves;
        double fraction = octaves - (double)ioctaves;
        int i = 1;
        while (i < ioctaves) {
            double t = (amp *= ampscale) * (this.unoise(x *= freqscale, y *= freqscale, z *= freqscale) - 0.5);
            noise += t;
            ++i;
        }
        double t = fraction * (amp *= ampscale) * (this.unoise(x *= freqscale, y *= freqscale, z *= freqscale) - 0.5);
        return noise += t;
    }

    public double sturbulence(double x, double y, double z, double octaves, double ampscale, double freqscale) {
        double amp = 1.0;
        double noise = this.snoise(x, y, z);
        int ioctaves = (int)octaves;
        double fraction = octaves - (double)ioctaves;
        int i = 1;
        while (i < ioctaves) {
            double t = (amp *= ampscale) * (this.snoise(x *= freqscale, y *= freqscale, z *= freqscale) - 0.5);
            noise += t;
            ++i;
        }
        double t = fraction * (amp *= ampscale) * (this.snoise(x *= freqscale, y *= freqscale, z *= freqscale) - 0.5);
        return noise += t;
    }

    public void uturbulence3d(double x, double y, double z, int octaves, double ampscale, double freqscale, Vector3d vnoise) {
        vnoise.x = this.unoise(x + 9.321, y - 1.531, z - 7.951);
        vnoise.y = this.unoise(x, y, z);
        vnoise.z = this.unoise(x + 6.327, y + 0.1671, z - 2.672);
        double amp = 1.0;
        int i = 1;
        while (i < octaves) {
            double nx = this.unoise((x *= freqscale) + 9.321, (y *= freqscale) - 1.531, (z *= freqscale) - 7.951);
            double ny = this.unoise(x, y, z);
            double nz = this.unoise(x + 6.327, y + 0.1671, z - 2.672);
            vnoise.x += (amp *= ampscale) * (nx - 0.5);
            vnoise.y += amp * (ny - 0.5);
            vnoise.z += amp * (nz - 0.5);
            ++i;
        }
        vnoise.x = 0.05 + vnoise.x / 1.1;
        vnoise.y = 0.05 + vnoise.y / 1.1;
        vnoise.z = 0.05 + vnoise.z / 1.1;
    }

    public void sturbulence3d(double x, double y, double z, int octaves, double ampscale, double freqscale, Vector3d vnoise) {
        vnoise.x = this.snoise(x + 9.321, y - 1.531, z - 7.951);
        vnoise.y = this.snoise(x, y, z);
        vnoise.z = this.snoise(x + 6.327, y + 0.1671, z - 2.672);
        double amp = 1.0;
        int i = 1;
        while (i < octaves) {
            double nx = this.snoise((x *= freqscale) + 9.321, (y *= freqscale) - 1.531, (z *= freqscale) - 7.951);
            double ny = this.snoise(x, y, z);
            double nz = this.snoise(x + 6.327, y + 0.1671, z - 2.672);
            vnoise.x += (amp *= ampscale) * (nx - 0.5);
            vnoise.y += amp * (ny - 0.5);
            vnoise.z += amp * (nz - 0.5);
            ++i;
        }
        vnoise.x = 0.05 + vnoise.x / 1.1;
        vnoise.y = 0.05 + vnoise.y / 1.1;
        vnoise.z = 0.05 + vnoise.z / 1.1;
    }
}

