/*
 * Decompiled with CFR 0.152.
 */
package kandid.extensions;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import kandid.calculation.Calculation;
import kandid.calculation.bridge.povray.PovTextureCalculation;
import kandid.extensions.LRUImageCache;
import kandid.util.Debug;

public class LRUImageCacheTest
extends TestCase {
    private static final int yDim = 100;
    private static final int xDim = 200;
    private Calculation calc;
    private String id1;
    private BufferedImage img1;
    private String id2;
    private BufferedImage img2;
    private String id3;
    private BufferedImage img3;

    public LRUImageCacheTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.calc = new PovTextureCalculation();
        this.id1 = "id1";
        this.img1 = new BufferedImage(200, 100, 1);
        this.id2 = "id2";
        this.img2 = new BufferedImage(200, 100, 1);
        this.id3 = "id3";
        this.img3 = new BufferedImage(200, 100, 1);
        LRUImageCache lruImageCache = LRUImageCache.getLRUImageCache();
        lruImageCache.put(this.calc, this.id1, this.img1);
        lruImageCache.put(this.calc, this.id2, this.img2);
        int i = 2;
        while (i < 1000) {
            lruImageCache.put(this.calc, "id-filler" + i, this.img1);
            ++i;
        }
    }

    public void testLRU() {
        this.addSequence();
        this.forgetSequence();
        this.removeAllSequence();
    }

    private void addSequence() {
        LRUImageCache lruImageCache = LRUImageCache.getLRUImageCache();
        LRUImageCacheTest.assertEquals((int)lruImageCache.get(this.id2, new Dimension(200, 100)).getWidth(), (int)this.img2.getWidth());
        LRUImageCacheTest.assertEquals((int)lruImageCache.get(this.id1, new Dimension(200, 100)).getWidth(), (int)this.img1.getWidth());
        LRUImageCacheTest.assertNull((Object)lruImageCache.get(this.id2, new Dimension(201, 101)));
        LRUImageCacheTest.assertNull((Object)lruImageCache.get("id0", new Dimension(200, 100)));
    }

    private void forgetSequence() {
        LRUImageCache lruImageCache = LRUImageCache.getLRUImageCache();
        lruImageCache.get(this.id1, new Dimension(200, 100));
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException exc) {
            Debug.stackTrace(exc);
        }
        lruImageCache.get(this.id2, new Dimension(200, 100));
        int i = 2;
        while (i < 1000) {
            lruImageCache.get("id-filler" + i, new Dimension(200, 100));
            ++i;
        }
        LRUImageCacheTest.assertEquals((int)1000, (int)lruImageCache.getNofEntries());
        lruImageCache.put(this.calc, this.id3, this.img3);
        LRUImageCacheTest.assertEquals((int)1000, (int)lruImageCache.getNofEntries());
        LRUImageCacheTest.assertEquals((int)lruImageCache.get(this.id2, new Dimension(200, 100)).getWidth(), (int)this.img2.getWidth());
        LRUImageCacheTest.assertEquals((int)lruImageCache.get(this.id3, new Dimension(200, 100)).getWidth(), (int)this.img3.getWidth());
        LRUImageCacheTest.assertNull((Object)lruImageCache.get(this.id1, new Dimension(200, 100)));
    }

    private void removeAllSequence() {
        LRUImageCache lruImageCache = LRUImageCache.getLRUImageCache();
        LRUImageCacheTest.assertEquals((int)1000, (int)lruImageCache.getNofEntries());
        LRUImageCacheTest.assertEquals((int)lruImageCache.get(this.id3, new Dimension(200, 100)).getWidth(), (int)this.img3.getWidth());
        lruImageCache.removeAll(this.id3);
        LRUImageCacheTest.assertNull((Object)lruImageCache.get(this.id3, new Dimension(200, 100)));
        LRUImageCacheTest.assertEquals((int)999, (int)lruImageCache.getNofEntries());
    }

    public void testDuplicate() {
        LRUImageCache lruImageCache = LRUImageCache.getLRUImageCache();
        lruImageCache.put(this.calc, this.id1, this.img1);
        LRUImageCacheTest.assertEquals((int)lruImageCache.get(this.id1, new Dimension(200, 100)).getWidth(), (int)this.img1.getWidth());
        lruImageCache.duplicate(this.id1, "dup1");
        BufferedImage imgDup1 = lruImageCache.get("dup1", new Dimension(200, 100));
        LRUImageCacheTest.assertNotNull((Object)imgDup1);
        LRUImageCacheTest.assertEquals((int)this.img1.getWidth(), (int)imgDup1.getWidth());
        LRUImageCacheTest.assertEquals((int)lruImageCache.get(this.id1, new Dimension(200, 100)).getWidth(), (int)this.img1.getWidth());
        LRUImageCacheTest.assertEquals((int)lruImageCache.get("dup1", new Dimension(200, 100)).getWidth(), (int)imgDup1.getWidth());
        LRUImageCacheTest.assertTrue((this.img1 != imgDup1 ? 1 : 0) != 0);
    }

    public static void main(String[] args) {
        TestRunner.run(LRUImageCacheTest.class);
    }
}

