/*
 * Decompiled with CFR 0.152.
 */
package kandid.extensions;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import kandid.Kandid;
import kandid.calculation.Calculation;
import kandid.calculation.lca.LcaCalculation;
import kandid.extensions.CachedImageInfo;
import kandid.util.Debug;

public class LRUImageCache {
    private static final String imagetype = "png";
    private static final String fileExtension = ".kcache.png";
    public static final int maxEntries = 1000;
    private static HashMap<String, CachedImageInfo> lru;
    private static LRUImageCache lruImageCache;

    private LRUImageCache() {
        lru = new HashMap();
    }

    public static LRUImageCache getLRUImageCache() {
        if (lruImageCache == null) {
            lruImageCache = new LRUImageCache();
            File cacheDir = new File(Kandid.cacheFolder);
            if (cacheDir.exists()) {
                try {
                    File[] dirList = cacheDir.listFiles();
                    int fx = 0;
                    while (fx < dirList.length) {
                        CachedImageInfo cachedImageInfo = new CachedImageInfo();
                        String fname = dirList[fx].getName();
                        if (dirList[fx].isFile() && dirList[fx].canRead() && fname.toLowerCase().endsWith(fileExtension)) {
                            int pos_x = fname.indexOf("_x");
                            int pos_y = fname.indexOf("_y");
                            int pos_png = fname.indexOf(fileExtension);
                            if (pos_x > 1 && pos_y > pos_x && pos_png > pos_y) {
                                String sx = fname.substring(pos_x + 2, pos_y);
                                String sy = fname.substring(pos_y + 2, pos_png);
                                cachedImageInfo.dim = new Dimension(Integer.parseInt(sx), Integer.parseInt(sy));
                                cachedImageInfo.id = LRUImageCache.getQualifiedId(fname.substring(0, pos_x), cachedImageInfo.dim);
                                cachedImageInfo.stamp = dirList[fx].lastModified();
                                lru.put(cachedImageInfo.id, cachedImageInfo);
                            }
                        }
                        ++fx;
                    }
                }
                catch (Exception exc) {
                    Debug.stackTrace(exc);
                }
            } else {
                cacheDir.mkdirs();
            }
        }
        return lruImageCache;
    }

    public synchronized void put(Calculation calculation, String id, BufferedImage img) {
        if (calculation instanceof LcaCalculation) {
            return;
        }
        Dimension dim = new Dimension(img.getWidth(), img.getHeight());
        CachedImageInfo cachedImageInfo = lru.get(LRUImageCache.getQualifiedId(id, dim));
        if (cachedImageInfo == null) {
            while (lru.size() >= 1000) {
                this.forget();
            }
            cachedImageInfo = new CachedImageInfo();
            cachedImageInfo.id = LRUImageCache.getQualifiedId(id, dim);
            cachedImageInfo.dim = dim;
            cachedImageInfo.stamp = System.currentTimeMillis();
            try {
                File imageOutFile = new File(LRUImageCache.getQualifiedFilename(cachedImageInfo));
                ImageIO.write((RenderedImage)img, imagetype, imageOutFile);
                imageOutFile.setLastModified(cachedImageInfo.stamp);
                lru.put(cachedImageInfo.id, cachedImageInfo);
            }
            catch (IOException exc) {
                Debug.stackTrace(exc);
            }
        }
    }

    private void forget() {
        int ne = lru.size();
        long oldest = Long.MAX_VALUE;
        for (CachedImageInfo cachedImageInfo : lru.values()) {
            if (cachedImageInfo.stamp >= oldest) continue;
            oldest = cachedImageInfo.stamp;
        }
        Iterator<CachedImageInfo> iter = lru.values().iterator();
        while (iter.hasNext()) {
            CachedImageInfo cachedImageInfo;
            cachedImageInfo = iter.next();
            if (cachedImageInfo.stamp != oldest) continue;
            new File(LRUImageCache.getQualifiedFilename(cachedImageInfo)).delete();
            iter.remove();
            break;
        }
    }

    public synchronized BufferedImage get(String id, Dimension dim) {
        BufferedImage img = null;
        CachedImageInfo cachedImageInfo = lru.get(LRUImageCache.getQualifiedId(id, dim));
        if (cachedImageInfo != null) {
            File imageInFile = new File(LRUImageCache.getQualifiedFilename(cachedImageInfo));
            if (imageInFile.exists()) {
                try {
                    img = ImageIO.read(imageInFile);
                    cachedImageInfo.stamp = System.currentTimeMillis();
                    imageInFile.setLastModified(cachedImageInfo.stamp);
                }
                catch (IOException exc) {
                    Debug.stackTrace(exc);
                }
            }
            return img;
        }
        return null;
    }

    public int getNofEntries() {
        return lru.size();
    }

    public synchronized void removeAll(String id) {
        Iterator<CachedImageInfo> iter = lru.values().iterator();
        while (iter.hasNext()) {
            CachedImageInfo cachedImageInfo = iter.next();
            if (!cachedImageInfo.id.startsWith(id + "_x")) continue;
            new File(LRUImageCache.getQualifiedFilename(cachedImageInfo)).delete();
            iter.remove();
        }
    }

    public synchronized void duplicate(String oldId, String newId) {
        ArrayList<CachedImageInfo> dupList = new ArrayList<CachedImageInfo>();
        for (CachedImageInfo cachedImageInfo : lru.values()) {
            if (!cachedImageInfo.id.startsWith(oldId + "_x")) continue;
            dupList.add(cachedImageInfo);
        }
        for (CachedImageInfo cachedImageInfo : dupList) {
            try {
                File imageInFile = new File(LRUImageCache.getQualifiedFilename(cachedImageInfo));
                BufferedImage img = ImageIO.read(imageInFile);
                cachedImageInfo.stamp = System.currentTimeMillis();
                imageInFile.setLastModified(cachedImageInfo.stamp);
                int pos = cachedImageInfo.id.indexOf("_x");
                CachedImageInfo dupImageInfo = (CachedImageInfo)cachedImageInfo.clone();
                dupImageInfo.id = newId + cachedImageInfo.id.substring(pos);
                dupImageInfo.stamp = System.currentTimeMillis();
                File imageOutFile = new File(LRUImageCache.getQualifiedFilename(dupImageInfo));
                ImageIO.write((RenderedImage)img, imagetype, imageOutFile);
                imageOutFile.setLastModified(dupImageInfo.stamp);
                lru.put(dupImageInfo.id, dupImageInfo);
            }
            catch (IOException exc) {
                Debug.stackTrace(exc);
            }
        }
        while (lru.size() >= 1000) {
            this.forget();
        }
    }

    public void touch(String id, Dimension dim) {
        CachedImageInfo cachedImageInfo = lru.get(LRUImageCache.getQualifiedId(id, dim));
        if (cachedImageInfo != null) {
            cachedImageInfo.stamp = System.currentTimeMillis();
            File imageInFile = new File(LRUImageCache.getQualifiedFilename(cachedImageInfo));
            imageInFile.setLastModified(cachedImageInfo.stamp);
        }
    }

    private static String getQualifiedId(String id, Dimension dim) {
        return id + "_x" + dim.width + "_y" + dim.height;
    }

    private static String getQualifiedFilename(CachedImageInfo cachedImageInfo) {
        return Kandid.cacheFolder + "/" + cachedImageInfo.id + fileExtension;
    }
}

