/*
 * Decompiled with CFR 0.152.
 */
package kandid.extensions;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import kandid.Console;
import kandid.calculation.Calculation;
import kandid.calculation.PixelCalculation;
import kandid.calculation.bridge.PixelBridgeCalculation;
import kandid.colorator.Colorator;
import kandid.extensions.BitmapEngine;
import kandid.extensions.ExportState;
import kandid.soup.ChromosomeType;

public class BitmapFileEngine
extends BitmapEngine {
    public BitmapFileEngine(ChromosomeType chromosome, String calculationName, Colorator colorator, ExportState exportState) {
        super(chromosome, calculationName, colorator, exportState);
    }

    @Override
    protected void generateOutput() throws IOException {
        block13: {
            block16: {
                File imageOutFile;
                block14: {
                    Calculation calc = this.gw.getCalculation();
                    if (calc instanceof PixelBridgeCalculation) break block13;
                    imageOutFile = new File(this.exportState.getPath("filebase") + this.exportState.getFullname());
                    String extension = this.exportState.fileExtension.toLowerCase();
                    if (!(calc instanceof PixelCalculation) || !extension.equals("png") && !extension.equals("pfm") && !extension.equals("jpg")) break block14;
                    switch (extension) {
                        case "png": {
                            ((PixelCalculation)calc).writeRGB_PNG16(this.exportState, imageOutFile);
                            break;
                        }
                        case "pfm": {
                            ((PixelCalculation)calc).writeRGB_PFM(this.exportState, imageOutFile);
                            break;
                        }
                        case "jpg": {
                            ((PixelCalculation)calc).writeRGB_JPG(imageOutFile);
                        }
                    }
                    break block16;
                }
                ImageIO.write((RenderedImage)((BufferedImage)this.gw.getImage()), this.exportState.fileExtension.toLowerCase(), imageOutFile);
            }
            Console.append(this.exportState.getAbsolutPath("filebase") + "/" + this.exportState.getFullname() + " is ready");
        }
    }
}

