/*
 * Decompiled with CFR 0.152.
 */
package kandid.extensions;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import kandid.Console;
import kandid.colorator.Colorator;
import kandid.extensions.ExportEngine;
import kandid.extensions.ExportState;
import kandid.soup.ChromosomeType;
import kandid.util.Debug;

public abstract class BitmapEngine
extends ExportEngine
implements Runnable {
    public BitmapEngine(ChromosomeType chromosome, String calculationName, Colorator colorator, ExportState exportState) {
        super(chromosome, calculationName, colorator, exportState);
    }

    protected abstract void generateOutput() throws IOException;

    public void start() {
        if (this.engine == null) {
            this.engine = new Thread(this);
            this.engine.start();
        }
    }

    public void stop() {
        this.engine = null;
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        Thread me = Thread.currentThread();
        me.setPriority(1);
        try {
            new File(this.exportState.getPath("filebase")).mkdirs();
            Console.append("exporting " + this.exportState.getAbsolutPath("filebase") + this.exportState.getFullname());
            this.gw.setChromosome(this.chromosome, this.gw.createCalculation(this.calculationName), this.colorator);
            this.gw.activateBitmapCanvas(new Dimension(this.exportState.xDim, this.exportState.yDim));
            this.gw.getCalculation().setImgaeFormat(this.exportState.fileExtension);
            while (!this.gw.getReady() && me == this.engine) {
                this.gw.calculate(false, this.exportState.getPath("filebase") + this.exportState.getFilename());
            }
            this.generateOutput();
        }
        catch (Throwable exc) {
            Console.append("error while exporting ");
            Console.append(exc.toString());
            Debug.stackTrace(exc);
        }
    }
}

