/*
 * Decompiled with CFR 0.152.
 */
package kandid.colorator;

import java.awt.Color;
import kandid.colorator.ColorF32;
import kandid.colorator.Colorator;
import kandid.colorator.LookUpTableColorator;
import kandid.soup.ChromosomeType;
import kandid.soup.ColorGene;
import kandid.soup.GradientChromosome;
import kandid.soup.GradientSegmentGene;

public class GradientColorator
implements Colorator {
    private float[] hueSegment;
    private float[] saturationSegment;
    private float[] brightnessSegment;
    private double[] segmentStart;
    private int size;

    @Override
    public void getColor(double value, ColorF32 cout) {
        assert (cout != null);
        if (value <= 0.0) {
            ColorF32 hsb = new ColorF32(this.hueSegment[0], this.saturationSegment[0], this.brightnessSegment[0]);
            ColorF32.hsb2rgb(hsb, cout);
            return;
        }
        if (value >= 1.0) {
            ColorF32 hsb = new ColorF32(this.hueSegment[this.size - 1], this.saturationSegment[this.size - 1], this.brightnessSegment[this.size - 1]);
            ColorF32.hsb2rgb(hsb, cout);
            return;
        }
        int upperSegment = 1;
        while (this.segmentStart[upperSegment] < value && upperSegment < this.size) {
            ++upperSegment;
        }
        int lowerSegment = upperSegment - 1;
        double v = (this.segmentStart[upperSegment] - value) / (this.segmentStart[upperSegment] - this.segmentStart[lowerSegment]);
        ColorF32 hsb = new ColorF32(GradientColorator.interpolateHue(this.hueSegment[lowerSegment], this.hueSegment[upperSegment], v), GradientColorator.interpolate(this.saturationSegment[lowerSegment], this.saturationSegment[upperSegment], v), GradientColorator.interpolate(this.brightnessSegment[lowerSegment], this.brightnessSegment[upperSegment], v));
        ColorF32.hsb2rgb(hsb, cout);
    }

    public static float interpolate(float lowerValue, float upperValue, double v) {
        return (float)((double)lowerValue * v + (double)upperValue * (1.0 - v));
    }

    public static float interpolateHue(float lowerValue, float upperValue, double v) {
        double diff = LookUpTableColorator.diffHue(lowerValue, upperValue);
        if (LookUpTableColorator.isMinDiffCW(lowerValue, upperValue)) {
            double diff1 = (double)lowerValue + (1.0 - v) * diff;
            return (float)(diff1 - Math.floor(diff1));
        }
        double diff1 = (double)upperValue + (1.0 - v) * diff;
        return (float)(diff1 - Math.floor(diff1));
    }

    @Override
    public void getColor(double redValue, double greenValue, double blueValue, ColorF32 cout) {
        assert (cout != null);
        double gray = 0.3 * redValue + 0.59 * greenValue + 0.11 * blueValue;
        if (gray >= 1.0) {
            gray = 1.0;
        } else if (gray < 0.0) {
            gray = 0.0;
        }
        cout.r = (float)gray;
        cout.g = (float)gray;
        cout.b = (float)gray;
    }

    @Override
    public void getColor(ColorGene colorGene, ColorF32 cout) {
        assert (cout != null);
        cout.r = colorGene.getRed().floatValue();
        cout.g = colorGene.getGreen().floatValue();
        cout.b = colorGene.getBlue().floatValue();
    }

    @Override
    public void getColor(Color color, ColorF32 cout) {
        assert (cout != null);
        cout.r = (float)((double)color.getRed() / 256.0);
        cout.g = (float)((double)color.getGreen() / 256.0);
        cout.b = (float)((double)color.getBlue() / 256.0);
    }

    @Override
    public String getShortName() {
        return "Grad";
    }

    @Override
    public void setColorTable(ChromosomeType colorTable) {
        this.size = ((GradientChromosome)colorTable).getGradientSegment().size();
        this.segmentStart = new double[this.size];
        this.hueSegment = new float[this.size];
        this.saturationSegment = new float[this.size];
        this.brightnessSegment = new float[this.size];
        GradientSegmentGene[] gradientSegment = new GradientSegmentGene[this.size];
        ((GradientChromosome)colorTable).getGradientSegment().toArray(gradientSegment);
        double sum = 0.0;
        int ix = 0;
        while (ix < this.size) {
            this.segmentStart[ix] = sum;
            if (ix + 1 < this.segmentStart.length) {
                sum += gradientSegment[ix].getWeight().getValue().doubleValue();
            }
            this.hueSegment[ix] = (float)gradientSegment[ix].getHue().getValue().doubleValue();
            this.saturationSegment[ix] = (float)gradientSegment[ix].getSaturation().getValue().doubleValue();
            this.brightnessSegment[ix] = (float)gradientSegment[ix].getBrightness().getValue().doubleValue();
            ++ix;
        }
        ix = 0;
        while (ix < this.size) {
            int n = ix++;
            this.segmentStart[n] = this.segmentStart[n] / sum;
        }
    }

    @Override
    public void getDiscretColor(int index, ColorF32 cout) {
        assert (cout != null);
        cout.r = 0.0f;
        cout.g = 0.0f;
        cout.b = 0.0f;
    }

    @Override
    public int getNumberOfDiscretColors() {
        return 0;
    }
}

