/*
 * Decompiled with CFR 0.152.
 */
package kandid.colorator;

import java.awt.Color;
import kandid.colorator.ColorF32;
import kandid.colorator.Colorator;
import kandid.soup.ChromosomeType;
import kandid.soup.ColorGene;

public class BlackWhiteColorator
implements Colorator {
    @Override
    public void getColor(double value, ColorF32 cout) {
        assert (cout != null);
        if (value > 0.5) {
            cout.r = 1.0f;
            cout.g = 1.0f;
            cout.b = 1.0f;
        } else {
            cout.r = 0.0f;
            cout.g = 0.0f;
            cout.b = 0.0f;
        }
    }

    @Override
    public void getColor(double redValue, double greenValue, double blueValue, ColorF32 cout) {
        assert (cout != null);
        if (0.3 * redValue + 0.59 * greenValue + 0.11 * blueValue > 0.5) {
            cout.r = 1.0f;
            cout.g = 1.0f;
            cout.b = 1.0f;
        } else {
            cout.r = 0.0f;
            cout.g = 0.0f;
            cout.b = 0.0f;
        }
    }

    @Override
    public void getColor(ColorGene colorGene, ColorF32 cout) {
        this.getColor(colorGene.getRed().floatValue(), colorGene.getGreen().floatValue(), colorGene.getBlue().floatValue(), cout);
    }

    @Override
    public void getColor(Color color, ColorF32 cout) {
        this.getColor((double)color.getRed() / 256.0, (double)color.getGreen() / 256.0, (double)color.getBlue() / 256.0, cout);
    }

    @Override
    public String getShortName() {
        return "BlackWhite";
    }

    @Override
    public void setColorTable(ChromosomeType colorTable) {
    }

    @Override
    public void getDiscretColor(int index, ColorF32 cout) {
        assert (cout != null);
        if (index > 0) {
            cout.r = 1.0f;
            cout.g = 1.0f;
            cout.b = 1.0f;
        } else {
            cout.r = 0.0f;
            cout.g = 0.0f;
            cout.b = 0.0f;
        }
    }

    @Override
    public int getNumberOfDiscretColors() {
        return 2;
    }
}

