/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.voronoi;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import kandid.calculation.RefinementCalculation;
import kandid.soup.ChromosomeType;
import kandid.soup.DistanceFunctionBase;
import kandid.soup.DistanceFunctionGene;
import kandid.soup.KingGene;
import kandid.soup.VoronoiChromosomeBase;

public abstract class VoronoiCalculationBase
extends RefinementCalculation
implements Cloneable {
    protected double[] dw;
    protected DistanceFunctionBase[] df;
    protected int numberOfDistanceFunctions;
    protected double[] kw;
    protected double[] ykp;
    protected double[] xkp;
    protected int numberOfKings;

    @Override
    public boolean reject(ChromosomeType chromosome) {
        return false;
    }

    @Override
    public void activateCanvas(Component viewComponent, Dimension canvasSize, boolean zoomMode) {
        this.depth = 6;
        this.xwMin = 0.0;
        this.xwMax = 1.0;
        this.ywMin = 0.0;
        this.ywMax = 1.0;
        super.activateCanvas(viewComponent, canvasSize, zoomMode);
        VoronoiChromosomeBase voronoiChromosomeBase = (VoronoiChromosomeBase)this.chromosome;
        List<KingGene> kingList = voronoiChromosomeBase.getKing();
        this.numberOfKings = kingList.size();
        this.xkp = new double[this.numberOfKings];
        this.ykp = new double[this.numberOfKings];
        this.kw = new double[this.numberOfKings];
        int kx = 0;
        while (kx < this.numberOfKings) {
            KingGene kingGene = kingList.get(kx);
            this.xkp[kx] = kingGene.getPoint().getX();
            this.ykp[kx] = kingGene.getPoint().getY();
            this.kw[kx] = kingGene.getWeight().getValue();
            ++kx;
        }
        List<DistanceFunctionGene> dfList = voronoiChromosomeBase.getDistance();
        this.numberOfDistanceFunctions = dfList.size();
        this.df = new DistanceFunctionBase[this.numberOfDistanceFunctions];
        this.dw = new double[this.numberOfDistanceFunctions];
        int kx2 = 0;
        while (kx2 < this.numberOfDistanceFunctions) {
            DistanceFunctionGene distanceFunctionGene = dfList.get(kx2);
            this.df[kx2] = distanceFunctionGene.getDistanceFunction();
            this.dw[kx2] = distanceFunctionGene.getWeight().getValue();
            ++kx2;
        }
    }

    protected double distance(int kx) {
        double xd = this.xw - this.xkp[kx];
        double yd = this.yw - this.ykp[kx];
        double dist = 0.0;
        int dx = 0;
        while (dx < this.numberOfDistanceFunctions) {
            if (this.dw[dx] > 0.0) {
                String dfx = this.df[dx].value();
                if (dfx.equals("abs(dx,dy)")) {
                    dist += this.dw[dx] * Math.abs(xd) + Math.abs(yd);
                } else if (dfx.equals("abs(dx)")) {
                    dist += this.dw[dx] * Math.abs(xd);
                } else if (dfx.equals("abs(dy)")) {
                    dist += this.dw[dx] * Math.abs(yd);
                } else if (dfx.equals("dx")) {
                    dist += this.dw[dx] * xd;
                } else if (dfx.equals("dy")) {
                    dist += this.dw[dx] * yd;
                } else if (dfx.equals("euclide(dx,dy)")) {
                    dist += this.dw[dx] * Math.sqrt(xd * xd + yd * yd);
                } else if (dfx.equals("product(dx,dy)")) {
                    dist += this.dw[dx] * Math.abs(xd) * Math.abs(yd);
                } else if (dfx.equals("quotient(dx,dy)")) {
                    dist += this.dw[dx] * Math.abs(xd) / (Math.abs(yd) + 1.0);
                }
            }
            ++dx;
        }
        return dist;
    }
}

