/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.vm.vector;

import javax.vecmath.Vector3d;
import junit.framework.TestCase;
import kandid.calculation.vm.vector.VectorLisp;
import kandid.calculation.vm.vector.VectorVM;
import kandid.soup.EntityType;
import kandid.soup.VectorExprGene;
import kandid.soup.util.SoupFactory;

public class VectorVMTest
extends TestCase {
    private VectorVM vectorVM;
    private SoupFactory soupFactory;
    private String expr1 = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<entity version=\"0.1.3\">\n    <vectorExpression version=\"0.2.3\">\n          <calculationName>kandid.calculation.vm.vector.VectorExpressionCalculation</calculationName>\n          <coloratorName>kandid.colorator.RGBColorator</coloratorName>\n          <chromosome>\n              <ident>VectorExpression_a_1</ident>\n<vectorExpression>\n  <list>\n    <opr>\n      <vectorOpr>sub</vectorOpr>\n    </opr>\n    <args>\n      <const>\n        <cx>\n          <value>0.7</value>\n        </cx>\n        <cy>\n          <value>0.8</value>\n        </cy>\n        <cz>\n          <value>0.9</value>\n        </cz>\n      </const>\n      <var>\n        <vectorVar>xyr</vectorVar>\n      </var>\n    </args>\n  </list>\n</vectorExpression>\n            <noiseSeed>\n                <value>151258</value>\n            </noiseSeed>\n        </chromosome>\n    </vectorExpression>\n</entity>\n";

    public VectorVMTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.vectorVM = new VectorVM(151258L);
        this.soupFactory = SoupFactory.getSoupFactory();
    }

    private void compileExpr(String expr) {
        EntityType entity = (EntityType)this.soupFactory.unmarshalFromString(expr);
        VectorExprGene vectorExprGene = entity.getVectorExpression().getChromosome().getVectorExpression();
        System.out.println("----\n");
        this.vectorVM.compile(vectorExprGene);
        System.out.println(String.valueOf(this.vectorVM));
    }

    private Vector3d executeLispExpr(String expr, double x, double y, Vector3d result) {
        this.compileExpr(new VectorLisp().getAsXML(expr));
        this.vectorVM.execute(x, y, 1.0E-10, result);
        return result;
    }

    private String trimLines(String expr) {
        char[] inp = expr.toCharArray();
        StringBuffer trimmed = new StringBuffer();
        int ix = 0;
        while (ix < inp.length) {
            if (inp[ix] != ' ') {
                trimmed.append(inp[ix]);
            }
            ++ix;
        }
        return trimmed.toString();
    }

    public void testGetAsXML() {
        VectorVMTest.assertEquals((String)this.trimLines(this.expr1), (String)this.trimLines(new VectorLisp().getAsXML("(sub [0.7 0.8 0.9] xyr)")));
    }

    public void ignore_testExecuteOpr() {
        Vector3d result = new Vector3d();
        this.executeLispExpr("(add [0.7 0.8 0.9] xyr)", 1.0, 2.0, result);
        VectorVMTest.assertEquals(new Vector3d(1.7, 2.8, Math.sqrt(5.0) + 0.9), result);
        this.executeLispExpr("(sub [0.7 0.8 0.9] xyr)", 1.0, 2.0, result);
        VectorVMTest.assertEquals(new Vector3d(-0.3, -1.2, -Math.sqrt(5.0) + 0.9), result);
        this.executeLispExpr("(mult [0.7 0.8 0.9] xyr)", 1.0, 2.0, result);
        VectorVMTest.assertEquals(new Vector3d(0.7, 1.6, Math.sqrt(5.0) * 0.9), result);
        this.executeLispExpr("(mod [1.7 2.8 -0.9] xyr)", 1.0, -1.0, result);
        VectorVMTest.assertEquals(new Vector3d(0.7, 0.8, -0.9), result);
        this.executeLispExpr("(cross [0.7 0.8 0.9] xyr)", 3.0, 4.0, result);
        VectorVMTest.assertEquals(new Vector3d(0.4, -0.8, 0.4), result);
        this.executeLispExpr("(sincos [0.7 0.8 0.9] xyr)", 1.0, 2.0, result);
        VectorVMTest.assertEquals(new Vector3d(-0.19098300562505255, 1.5877852522924734, 1.046385872453267), result);
        this.executeLispExpr("(atan [0.7 0.8 0.9] xyr)", 1.0, 2.0, result);
        VectorVMTest.assertEquals(new Vector3d(0.19440011221421477, 0.12111894159084341, 0.12180223551427653), result);
        this.executeLispExpr("(atan [0 0 0] xyr)", 0.0, 0.0, result);
        VectorVMTest.assertEquals(new Vector3d(0.0, 0.0, 0.0), result);
        this.executeLispExpr("(maxvalue [0.7 0.8 99] xyr)", 3.0, 4.0, result);
        VectorVMTest.assertEquals(new Vector3d(3.0, 4.0, 99.0), result);
        this.executeLispExpr("(maxvalue [10.7 0.8 0.9] xyr)", 3.0, -4.0, result);
        VectorVMTest.assertEquals(new Vector3d(10.7, 0.8, 5.0), result);
        this.executeLispExpr("(minvalue [0.7 0.8 9] xyr)", 3.0, 4.0, result);
        VectorVMTest.assertEquals(new Vector3d(0.7, 0.8, 5.0), result);
        this.executeLispExpr("(minvalue [10.7 0.8 0.9] xyr)", 3.0, -4.0, result);
        VectorVMTest.assertEquals(new Vector3d(3.0, -4.0, 0.9), result);
        this.executeLispExpr("(minvalue [2 2 3] xym)", 1.0, 1.0, result);
        VectorVMTest.assertEquals(new Vector3d(1.0, 1.0, 2.0), result);
        this.executeLispExpr("(maxvector xyr [0.7 0.8 0.9])", 3.0, 4.0, result);
        VectorVMTest.assertEquals(new Vector3d(3.0, 4.0, 5.0), result);
        this.executeLispExpr("(maxvector [0.7 0.8 0.9] xyr)", 3.0, 4.0, result);
        VectorVMTest.assertEquals(new Vector3d(3.0, 4.0, 5.0), result);
        this.executeLispExpr("(maxvector xyr [0.7 0.8 -99])", 3.0, 4.0, result);
        VectorVMTest.assertEquals(new Vector3d(0.7, 0.8, -99.0), result);
        this.executeLispExpr("(minvector xyr [0.7 0.8 0.9])", 3.0, 4.0, result);
        VectorVMTest.assertEquals(new Vector3d(0.7, 0.8, 0.9), result);
        this.executeLispExpr("(minvector [0.7 0.8 0.9] xyr)", 3.0, 4.0, result);
        VectorVMTest.assertEquals(new Vector3d(0.7, 0.8, 0.9), result);
        this.executeLispExpr("(minvector xyr [0.7 0.8 -99])", 3.0, 4.0, result);
        VectorVMTest.assertEquals(new Vector3d(3.0, 4.0, 5.0), result);
        this.executeLispExpr("(maxmix [0 0 0] xym)", 1.0, 1.0, result);
        VectorVMTest.assertEquals(new Vector3d(1.0, 1.0, 2.0), result);
        this.executeLispExpr("(maxmix [2 2 3] xym)", 1.0, 1.0, result);
        VectorVMTest.assertEquals(new Vector3d(1.7391304347826086, 1.7391304347826086, 2.739130434782609), result);
        this.executeLispExpr("(maxmix [2 2 3] xym)", 100.0, 100.0, result);
        VectorVMTest.assertEquals(new Vector3d(99.97224119832714, 99.97224119832714, 199.944199143576), result);
        this.executeLispExpr("(invmix [0 0 0] xym)", 1.0, 1.0, result);
        VectorVMTest.assertEquals(new Vector3d(0.0, 0.0, 0.0), result);
        this.executeLispExpr("(invmix [2 2 3] xym)", 1.0, 1.0, result);
        VectorVMTest.assertEquals(new Vector3d(1.2608695652173914, 1.2608695652173914, 2.2608695652173916), result);
        this.executeLispExpr("(invmix [2 2 3] xym)", 100.0, 100.0, result);
        VectorVMTest.assertEquals(new Vector3d(2.0277588016728596, 2.0277588016728596, 3.055800856424013), result);
        this.executeLispExpr("(step xyr [0.7 0.8 99])", 3.0, 4.0, result);
        VectorVMTest.assertEquals(new Vector3d(1.0, 1.0, -1.0), result);
        this.executeLispExpr("(step [0.7 0.8 99] xyr)", 3.0, 4.0, result);
        VectorVMTest.assertEquals(new Vector3d(-1.0, -1.0, 1.0), result);
        this.executeLispExpr("(noise [0.7 0.8 99] xyr)", 3.0, 4.0, result);
        VectorVMTest.assertEquals(new Vector3d(-0.04891896714707681, -0.08266644176030277, 0.1465003573902327), result);
        this.executeLispExpr("(turbulence [0.7 0.8 99] xyr)", 3.0, 4.0, result);
        VectorVMTest.assertEquals(new Vector3d(-0.1351251425583108, 0.09117528639093217, 0.1566956664247885), result);
        this.executeLispExpr("(waves [0.7 0.8 99] xyr)", 3.0, 4.0, result);
        VectorVMTest.assertEquals(new Vector3d(-0.008955816236990988, -0.005374755236860104, -0.9999454511930503), result);
    }

    public static void assertEquals(Vector3d expected, Vector3d actual) {
        VectorVMTest.assertEquals(null, (double)expected.x, (double)actual.x, (double)1.0E-10);
        VectorVMTest.assertEquals(null, (double)expected.y, (double)actual.y, (double)1.0E-10);
        VectorVMTest.assertEquals(null, (double)expected.z, (double)actual.z, (double)1.0E-10);
    }

    public void ignore_testExecute1M() {
        EntityType entity = (EntityType)this.soupFactory.unmarshalFromString(this.expr1);
        VectorExprGene vectorExprGene = entity.getVectorExpression().getChromosome().getVectorExpression();
        this.vectorVM.compile(vectorExprGene);
        Vector3d result = new Vector3d();
        int i = 0;
        while (i < 100) {
            ++i;
        }
        long start = System.currentTimeMillis();
        int rounds = 1000000;
        int ix = 0;
        while (ix < 1000000) {
            this.vectorVM.execute(1.0, 2.0, 1.0E-10, result);
            ++ix;
        }
        long done = System.currentTimeMillis() - start;
        System.out.println(1000.0 / (double)done + " mips");
    }
}

