/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.vm.scalar;

import junit.framework.TestCase;
import kandid.calculation.vm.scalar.ScalarLisp;
import kandid.calculation.vm.scalar.ScalarVM;
import kandid.soup.EntityType;
import kandid.soup.ScalarExprGene;
import kandid.soup.util.SoupFactory;

public class ScalarVMTest
extends TestCase {
    private ScalarVM scalarVM;
    private SoupFactory soupFactory;
    String expr1 = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<entity version=\"0.1.3\">\n    <scalarExpression version=\"0.2.3\">\n        <calculationName>ScalarExpression</calculationName>\n        <colorator>\n            <coloratorName>kandid.colorator.GradientColorator</coloratorName>\n            <gradient>\n                <ident>ScalarExpression_a_1</ident>\n                <gradientSegment>\n                    <hue>\n                        <value>0.0</value>\n                    </hue>\n                    <saturation>\n                        <value>0.0</value>\n                    </saturation>\n                    <brightness>\n                        <value>0.0</value>\n                    </brightness>\n                    <weight>\n                        <value>0.5</value>\n                    </weight>\n                </gradientSegment>\n                <gradientSegment>\n                    <hue>\n                        <value>1.0</value>\n                    </hue>\n                    <saturation>\n                        <value>1.0</value>\n                    </saturation>\n                    <brightness>\n                        <value>1.0</value>\n                    </brightness>\n                    <weight>\n                        <value>0.5</value>\n                    </weight>\n                </gradientSegment>\n            </gradient>\n        </colorator>\n        <chromosome>\n            <ident>ScalarExpression_a_1</ident>\n<scalarExpression>\n    <list>\n        <opr>\n            <scalarOpr>sub</scalarOpr>\n        </opr>\n        <args>\n            <const>\n                <scalarConst>\n                    <value>0.7</value>\n                </scalarConst>\n            </const>\n            <var>\n                <scalarVar>x</scalarVar>\n            </var>\n        </args>\n    </list>\n</scalarExpression>\n            <noiseSeed>\n                <value>151258</value>\n            </noiseSeed>\n        </chromosome>\n    </scalarExpression>\n</entity>\n";
    String expr2 = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<entity version=\"0.1.3\">\n    <scalarExpression version=\"0.2.3\">\n        <calculationName>ScalarExpression</calculationName>\n        <colorator>\n            <coloratorName>kandid.colorator.GradientColorator</coloratorName>\n            <gradient>\n                <ident>ScalarExpression_a_1</ident>\n                <gradientSegment>\n                    <hue>\n                        <value>0.0</value>\n                    </hue>\n                    <saturation>\n                        <value>0.0</value>\n                    </saturation>\n                    <brightness>\n                        <value>0.0</value>\n                    </brightness>\n                    <weight>\n                        <value>0.5</value>\n                    </weight>\n                </gradientSegment>\n                <gradientSegment>\n                    <hue>\n                        <value>1.0</value>\n                    </hue>\n                    <saturation>\n                        <value>1.0</value>\n                    </saturation>\n                    <brightness>\n                        <value>1.0</value>\n                    </brightness>\n                    <weight>\n                        <value>0.5</value>\n                    </weight>\n                </gradientSegment>\n            </gradient>\n        </colorator>\n        <chromosome>\n            <ident>ScalarExpression_a_1</ident>\n<scalarExpression>\n    <list>\n        <opr>\n            <scalarOpr>div</scalarOpr>\n        </opr>\n        <args>\n            <scalarExpression>\n                <list>\n                    <opr>\n                        <scalarOpr>mult</scalarOpr>\n                    </opr>\n                    <args>\n                        <var>\n                            <scalarVar>y</scalarVar>\n                        </var>\n                        <const>\n                            <scalarConst>\n                                <value>3</value>\n                            </scalarConst>\n                        </const>\n                        <var>\n                            <scalarVar>x</scalarVar>\n                        </var>\n                    </args>\n                </list>\n            </scalarExpression>\n            <const>\n                <scalarConst>\n                    <value>4</value>\n                </scalarConst>\n            </const>\n            <var>\n                <scalarVar>x</scalarVar>\n            </var>\n        </args>\n    </list>\n</scalarExpression>\n            <noiseSeed>\n                <value>151258</value>\n            </noiseSeed>\n        </chromosome>\n    </scalarExpression>\n</entity>\n";
    String exprIfPositive = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<entity version=\"0.1.3\">\n    <scalarExpression version=\"0.2.3\">\n        <calculationName>ScalarExpression</calculationName>\n        <colorator>\n            <coloratorName>kandid.colorator.GradientColorator</coloratorName>\n            <gradient>\n                <ident>ScalarExpression_a_1</ident>\n                <gradientSegment>\n                    <hue>\n                        <value>0.0</value>\n                    </hue>\n                    <saturation>\n                        <value>0.0</value>\n                    </saturation>\n                    <brightness>\n                        <value>0.0</value>\n                    </brightness>\n                    <weight>\n                        <value>0.5</value>\n                    </weight>\n                </gradientSegment>\n                <gradientSegment>\n                    <hue>\n                        <value>1.0</value>\n                    </hue>\n                    <saturation>\n                        <value>1.0</value>\n                    </saturation>\n                    <brightness>\n                        <value>1.0</value>\n                    </brightness>\n                    <weight>\n                        <value>0.5</value>\n                    </weight>\n                </gradientSegment>\n            </gradient>\n        </colorator>\n        <chromosome>\n            <ident>ScalarExpression_a_1</ident>\n<scalarExpression>\n    <list>\n        <opr>\n            <scalarOpr>ifPositive</scalarOpr>\n        </opr>\n        <args>\n            <var>\n                <scalarVar>y</scalarVar>\n            </var>\n            <const>\n                <scalarConst>\n                    <value>0.3</value>\n                </scalarConst>\n            </const>\n            <var>\n                <scalarVar>x</scalarVar>\n            </var>\n        </args>\n    </list>\n</scalarExpression>\n            <noiseSeed>\n                <value>151258</value>\n            </noiseSeed>\n        </chromosome>\n    </scalarExpression>\n</entity>\n";
    String exprNoise = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<entity version=\"0.1.3\">\n    <scalarExpression version=\"0.2.3\">\n        <calculationName>ScalarExpression</calculationName>\n        <colorator>\n            <coloratorName>kandid.colorator.GradientColorator</coloratorName>\n            <gradient>\n                <ident>ScalarExpression_a_1</ident>\n                <gradientSegment>\n                    <hue>\n                        <value>0.0</value>\n                    </hue>\n                    <saturation>\n                        <value>0.0</value>\n                    </saturation>\n                    <brightness>\n                        <value>0.0</value>\n                    </brightness>\n                    <weight>\n                        <value>0.5</value>\n                    </weight>\n                </gradientSegment>\n                <gradientSegment>\n                    <hue>\n                        <value>1.0</value>\n                    </hue>\n                    <saturation>\n                        <value>1.0</value>\n                    </saturation>\n                    <brightness>\n                        <value>1.0</value>\n                    </brightness>\n                    <weight>\n                        <value>0.5</value>\n                    </weight>\n                </gradientSegment>\n            </gradient>\n        </colorator>\n        <chromosome>\n            <ident>ScalarExpression_a_1</ident>\n<scalarExpression>\n    <list>\n        <opr>\n            <scalarOpr>noise</scalarOpr>\n        </opr>\n        <args>\n            <const>\n                <scalarConst>\n                    <value>0.1</value>\n                </scalarConst>\n            </const>\n            <var>\n                <scalarVar>x</scalarVar>\n            </var>\n            <var>\n                <scalarVar>y</scalarVar>\n            </var>\n        </args>\n    </list>\n</scalarExpression>\n            <noiseSeed>\n                <value>151258</value>\n            </noiseSeed>\n        </chromosome>\n    </scalarExpression>\n</entity>\n";

    public ScalarVMTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.scalarVM = new ScalarVM(151258L);
        this.soupFactory = SoupFactory.getSoupFactory();
    }

    private void compileExpr(String expr) {
        EntityType entity = (EntityType)this.soupFactory.unmarshalFromString(expr);
        ScalarExprGene scalarExprGene = entity.getScalarExpression().getChromosome().getScalarExpression();
        System.out.println("----\n");
        this.scalarVM.compile(scalarExprGene);
        System.out.println(String.valueOf(this.scalarVM));
    }

    private double executeLispExpr(String expr, double x, double y) {
        this.compileExpr(new ScalarLisp().getAsXML(expr));
        return this.scalarVM.execute(x, y, 1.0E-10);
    }

    private String trimLines(String expr) {
        char[] inp = expr.toCharArray();
        StringBuffer trimmed = new StringBuffer();
        int ix = 0;
        while (ix < inp.length) {
            if (inp[ix] != ' ') {
                trimmed.append(inp[ix]);
            }
            ++ix;
        }
        return trimmed.toString();
    }

    public void ignore_testCompile1() {
        this.compileExpr(this.expr1);
        int ip = 0;
        ScalarVMTest.assertEquals((int)4, (int)this.scalarVM.codeTape[ip]);
        ScalarVMTest.assertEquals((double)0.0, (double)this.scalarVM.dOper[ip], (double)1.0E-10);
        ScalarVMTest.assertEquals((int)0, (int)this.scalarVM.iOper[ip]);
        ScalarVMTest.assertEquals((int)2, (int)this.scalarVM.codeTape[++ip]);
        ScalarVMTest.assertEquals((double)0.7, (double)this.scalarVM.dOper[ip], (double)1.0E-10);
        ScalarVMTest.assertEquals((int)0, (int)this.scalarVM.iOper[ip]);
        ScalarVMTest.assertEquals((int)16, (int)this.scalarVM.codeTape[++ip]);
        ScalarVMTest.assertEquals((double)0.0, (double)this.scalarVM.dOper[ip], (double)1.0E-10);
        ScalarVMTest.assertEquals((int)2, (int)this.scalarVM.iOper[ip]);
        ScalarVMTest.assertEquals((int)0, (int)this.scalarVM.codeTape[++ip]);
        ScalarVMTest.assertEquals((double)0.0, (double)this.scalarVM.dOper[ip], (double)1.0E-10);
        ScalarVMTest.assertEquals((int)0, (int)this.scalarVM.iOper[ip]);
    }

    public void ignore_testExecute1() {
        this.ignore_testCompile1();
        ScalarVMTest.assertEquals((double)-0.3, (double)this.scalarVM.execute(1.0, -1.0, 1.0E-10), (double)1.0E-10);
    }

    public void ignore_testExecute2() {
        this.compileExpr(this.expr2);
        ScalarVMTest.assertEquals((double)0.75, (double)this.scalarVM.execute(2.0, 1.0, 1.0E-10), (double)1.0E-10);
    }

    public void ignore_testCompileIfPositive() {
        this.compileExpr(this.exprIfPositive);
    }

    public void ignore_testExecuteIfPositive() {
        this.compileExpr(this.exprIfPositive);
        ScalarVMTest.assertEquals((double)0.3, (double)this.scalarVM.execute(0.2, 1.0E-10, 1.0E-10), (double)1.0E-10);
    }

    public void ignore_testExecuteNoise() {
        this.compileExpr(this.exprNoise);
        ScalarVMTest.assertEquals((double)0.18026221874439646, (double)this.scalarVM.execute(0.2, 0.1, 1.0E-10), (double)1.0E-10);
    }

    public void testGetAsXML() {
        ScalarVMTest.assertEquals((String)this.trimLines(this.expr1), (String)this.trimLines(new ScalarLisp().getAsXML("(sub 0.7 x)")));
        ScalarVMTest.assertEquals((String)this.trimLines(this.expr2), (String)this.trimLines(new ScalarLisp().getAsXML("(div (mult y 3 x) 4 x)")));
        ScalarVMTest.assertEquals((String)this.trimLines(this.exprIfPositive), (String)this.trimLines(new ScalarLisp().getAsXML("(ifPositive y 0.3 x)")));
        ScalarVMTest.assertEquals((String)this.trimLines(this.exprNoise), (String)this.trimLines(new ScalarLisp().getAsXML("(noise 0.1 x y)")));
    }

    public void ignore_testExecuteOpr() {
        ScalarVMTest.assertEquals((double)Double.POSITIVE_INFINITY, (double)this.executeLispExpr("(div x y)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(ifPositive x 1 2)", Double.POSITIVE_INFINITY, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)Double.NEGATIVE_INFINITY, (double)this.executeLispExpr("(sub 0 x)", Double.POSITIVE_INFINITY, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.5462180318903666, (double)this.executeLispExpr("(turbulence 0.1 0.2 0.3 x)", Double.POSITIVE_INFINITY, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((long)Double.doubleToLongBits(Double.NaN), (long)Double.doubleToLongBits(this.executeLispExpr("(sub 1 x)", Double.NaN, 0.0)));
        ScalarVMTest.assertEquals((long)Double.doubleToLongBits(Double.NaN), (long)Double.doubleToLongBits(this.executeLispExpr("(turbulence x 0.2 0.3 x)", Double.POSITIVE_INFINITY, 0.0)));
        ScalarVMTest.assertEquals((double)-1.0, (double)this.executeLispExpr("(add 0 xi)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)-1.0, (double)this.executeLispExpr("(add 0 yi)", 0.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(add 0 r)", 0.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)Math.sqrt(2.0), (double)this.executeLispExpr("(add 0 r)", 1.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(add 0 r)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(add 0 ri)", 0.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.0, (double)this.executeLispExpr("(add 0 ri)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)(1.0 - Math.sqrt(2.0)), (double)this.executeLispExpr("(add 0 ri)", 1.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.20674118994423063, (double)this.executeLispExpr("(noise 0.1 0.2 0.3)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.18026221874439646, (double)this.executeLispExpr("(noise 0.1 0.2 0.1)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.18026221874439646, (double)this.executeLispExpr("(noise 0.1 0.2)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.17876534473210404, (double)this.executeLispExpr("(noise 0.1 0.1 0.1)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.17876534473210404, (double)this.executeLispExpr("(noise 0.1)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.5462180318903666, (double)this.executeLispExpr("(turbulence 0.1 0.2 0.3 3000)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.9280194981689174, (double)this.executeLispExpr("(turbulence -3000)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.20674118994423063, (double)this.executeLispExpr("(snoise 0.1 0.2 0.3 1.0)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.2484739865777904, (double)this.executeLispExpr("(snoise 0.1)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.2484739865777904, (double)this.executeLispExpr("(sturbulence 0.1)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(ifPositive 0 1 2 3)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(ifPositive 0 1 2)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)-4.0, (double)this.executeLispExpr("(ifPositive (ifPositive -1 2 -3) 1 -4)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)5.0, (double)this.executeLispExpr("(ifPositive (ifPositive -1 2 -3) 1 (ifPositive 1 5 -3))", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)-10.0, (double)this.executeLispExpr("(ifPositive (ifPositive -1 2 -3) 1 (ifPositive -10 5))", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)-10.0, (double)this.executeLispExpr("(ifPositive (ifPositive -1 2 -3) 1 (ifPositive -10))", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)8.0, (double)this.executeLispExpr("(pow 2 3)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.125, (double)this.executeLispExpr("(pow 2 -3)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(log x)", Math.E, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.7, (double)this.executeLispExpr("(add 0.7 x)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)10.0, (double)this.executeLispExpr("(add 1 2 x y)", 3.0, 4.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)120.0, (double)this.executeLispExpr("(mult 1 2 x y 5)", 3.0, 4.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)120.0, (double)this.executeLispExpr("(mult (add 0 1) (add 1 1) (div x 1 1 2) (mult (add 1 1) y) (sub 15 5 3 2))", 6.0, 2.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)-0.3, (double)this.executeLispExpr("(sub 0.7 x)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)-1.0, (double)this.executeLispExpr("(sub 0.7 x y (div 2 10))", 1.0, 0.5), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)-1.0, (double)this.executeLispExpr("(sub 0.7 x y (div 2 10))", 1.0, 0.5), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.99, (double)this.executeLispExpr("(mix x y 0.99)", 0.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.0, (double)this.executeLispExpr("(mix -1 1 0.5)", 0.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.0, (double)this.executeLispExpr("(step 1 1)", 0.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(step y -0.99)", 0.0, -1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(puls -1 1 x)", 0.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.0, (double)this.executeLispExpr("(puls 0 0.1 x)", -1.0E-10, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.0, (double)this.executeLispExpr("(puls 0 0.1 x)", 0.0, 0.1000000001), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(clamp -1 1 x)", 10.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)-1.0, (double)this.executeLispExpr("(clamp -1 1 x)", -1.0000000001, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.55, (double)this.executeLispExpr("(clamp 0.5 0.6 x)", 0.55, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.1, (double)this.executeLispExpr("(min x y)", 0.1, 1.2), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.1, (double)this.executeLispExpr("(min y x)", 0.1, 1.2), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.1, (double)this.executeLispExpr("(min y x 0)", 0.1, 1.2), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)-0.1, (double)this.executeLispExpr("(min y x 0)", -0.1, Double.POSITIVE_INFINITY), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.2, (double)this.executeLispExpr("(max x y)", 0.1, 1.2), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)-0.1, (double)this.executeLispExpr("(max y x)", -0.1, -1.2), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.2, (double)this.executeLispExpr("(max y x 10)", 0.1, 1.2), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.7, (double)this.executeLispExpr("(abs 0.7)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(abs x)", -1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(smoothstep -1 1 x)", 1.0000000001, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.0, (double)this.executeLispExpr("(smoothstep -1 1 x)", -1.0000000001, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.5, (double)this.executeLispExpr("(smoothstep -1 1 x)", 0.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(boxstep -1 1 x)", 1.0000000001, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.0, (double)this.executeLispExpr("(boxstep -1 1 x)", -1.0000000001, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.5, (double)this.executeLispExpr("(boxstep -1 1 x)", 0.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)2.0, (double)this.executeLispExpr("(mod 11 3)", 0.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(mod -11 3)", 0.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)2.0, (double)this.executeLispExpr("(sqrt x)", 4.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)2.0, (double)this.executeLispExpr("(sqrt x)", -4.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.0, (double)this.executeLispExpr("(sqrt 0)", 0.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.5, (double)this.executeLispExpr("(sin x)", 0.5235987755982988, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.5, (double)this.executeLispExpr("(cos y)", 0.0, 1.0471975511965976), (double)1.0E-10);
        ScalarVMTest.assertTrue((this.executeLispExpr("(tan y)", 0.0, 1.5707963267948966) > 1.0E10 ? 1 : 0) != 0);
        ScalarVMTest.assertEquals((double)-1.5707963267948966, (double)this.executeLispExpr("(atan y)", 0.0, Double.NEGATIVE_INFINITY), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.7853981633974483, (double)this.executeLispExpr("(atanq x y)", 1.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)-1.5707963267948966, (double)this.executeLispExpr("(atanq x y)", -1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(floor x)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)3.0, (double)this.executeLispExpr("(floor x)", Math.PI, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(ceil x)", 1.0, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)4.0, (double)this.executeLispExpr("(ceil x)", Math.PI, 0.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)38.832975677895, (double)this.executeLispExpr("(euclide 11 12 x y)", 33.0, 44.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)54.0, (double)this.executeLispExpr("(absolute 11 12 x y)", 33.0, 44.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.0, (double)this.executeLispExpr("(gamma 0.7 x)", 0.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(gamma 0.7 y)", 0.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.0, (double)this.executeLispExpr("(gamma 1.7 x)", 0.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(gamma 1.7 y)", 0.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.5, (double)this.executeLispExpr("(gamma 1.0 0.5)", 0.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.0, (double)this.executeLispExpr("(bias 0.7 x)", 0.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(bias 0.7 y)", 0.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.0, (double)this.executeLispExpr("(gain 0.7 x)", 0.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)1.0, (double)this.executeLispExpr("(gain 0.7 y)", 0.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.5, (double)this.executeLispExpr("(gain 0.8 0.5)", 0.0, 1.0), (double)1.0E-10);
        ScalarVMTest.assertEquals((double)0.0, (double)this.executeLispExpr("(gain 1.7 x)", 0.0, 1.0), (double)1.0E-10);
    }

    public void ignore_testExecute1M() {
        EntityType entity = (EntityType)this.soupFactory.unmarshalFromString(this.expr1);
        ScalarExprGene scalarExprGene = entity.getScalarExpression().getChromosome().getScalarExpression();
        this.scalarVM.compile(scalarExprGene);
        int i = 0;
        while (i < 100) {
            ScalarVMTest.assertEquals((double)-0.3, (double)this.scalarVM.execute(1.0, 2.0, 1.0E-10), (double)1.0E-10);
            ++i;
        }
        long start = System.currentTimeMillis();
        int rounds = 1000000;
        int ix = 0;
        while (ix < 1000000) {
            this.scalarVM.execute(1.0, 2.0, 1.0E-10);
            ++ix;
        }
        long done = System.currentTimeMillis() - start;
        System.out.println(1000.0 / (double)done + " mips");
    }
}

