/*
 * Decompiled with CFR 0.152.
 */
package kandid.calculation.lsys;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.util.List;
import kandid.calculation.VectorCalculation;
import kandid.colorator.ColorF32;
import kandid.colorator.Colorator;
import kandid.colorator.GrayColorator;
import kandid.colorator.TransparentLookUpTableColorator;
import kandid.soup.ChromosomeType;
import kandid.soup.Lsys0LChromosome;
import kandid.soup.LsysChromosome;
import kandid.soup.LsysD0LChromosome;
import kandid.soup.LsysILChromosome;
import kandid.soup.LsysProductionGene;
import kandid.util.Debug;
import kandid.util.TextureRandomizer;

public class LsysMashine {
    private static final int maxDepthBranchStack = 1000;
    private static final int maxRules = 64;
    private static final int maxSuccessorCharacters = 32;
    private static final int maxCharacters = 127;
    private static final int maxDirections = 72;
    static int maxString;
    static int noTurtleDirections;
    static byte[][][] rule;
    static byte[][] lContext;
    static byte[][] rContext;
    static int[][] sizeofRules;
    static int[] noRules;
    static boolean[] ignorCharacter;
    static final int sys0 = 0;
    public static final int sysDOL = 1;
    public static final int sysOL = 2;
    public static final int sysIL = 3;
    public static final int sys2L = 4;
    static int typeOfLSystem;
    static int depth;
    static double turtleX;
    static double turtleY;
    static int turtleDirection;
    static int startDirection;
    static double[] COS;
    static double[] SIN;
    static TextureRandomizer ZVarJitter;
    static int jitter;
    static TextureRandomizer ZVarSelect;
    static long seed;
    static byte[] string;
    static int length;
    static byte[] newString;
    static int newLength;
    static int turtleIndex;
    private static final int maxDepthLeafStack = 100;
    static int leafTOS;
    static final int maxPolyPoints = 100;
    static int[][] xPolyPoints;
    static int[][] yPolyPoints;
    static int branchTOS;
    static double[] turtleStackX;
    static double[] turtleStackY;
    static int[] turtleStackDir;
    static int[] turtleStackColor;
    static int[] turtleStackAlpha;
    static boolean stackMessageSend;
    static final int stateAbort = -1;
    static final int stateReady = 0;
    static int calculationState;
    static Object sync;
    static LsysChromosome lsysChromosome;
    static VectorCalculation vectorCalculation;
    static Colorator colorator;
    static boolean transparenceEnabled;
    private static int baseIndex;
    private static int numberOfDiscretColors;
    private static ColorF32 realizedColor;
    private static int colorIndex;
    private static int realizedAlphaIndex;
    private static int alphaIndex;

    static {
        calculationState = -2;
        sync = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(ChromosomeType chromosome, Colorator setColorator, VectorCalculation setVectorCalculation) {
        Object object = sync;
        synchronized (object) {
            block10: {
                try {
                    try {
                        lsysChromosome = (LsysChromosome)chromosome;
                        vectorCalculation = setVectorCalculation;
                        colorator = setColorator;
                        transparenceEnabled = colorator instanceof TransparentLookUpTableColorator || colorator instanceof GrayColorator;
                        numberOfDiscretColors = colorator.getNumberOfDiscretColors();
                        if (!vectorCalculation.isAborted()) {
                            LsysMashine.allocate1();
                            LsysMashine.initCalculation();
                            LsysMashine.allocate2();
                            do {
                                LsysMashine.calculate();
                                if (!vectorCalculation.isAborted()) continue;
                                calculationState = -1;
                            } while (calculationState > 0 && !vectorCalculation.isAborted());
                        }
                    }
                    catch (RuntimeException exc) {
                        Debug.stackTrace(exc);
                        LsysMashine.free();
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    LsysMashine.free();
                    throw throwable;
                }
                LsysMashine.free();
            }
        }
    }

    private static void allocate1() {
        rule = new byte[127][64][32];
        lContext = new byte[127][64];
        rContext = new byte[127][64];
        sizeofRules = new int[127][64];
        noRules = new int[127];
        ignorCharacter = new boolean[127];
        COS = new double[72];
        SIN = new double[72];
    }

    private static void allocate2() {
        maxString = 0x2000000;
        string = new byte[maxString];
        assert (string[0] == 0);
        assert (string[maxString - 1] == 0);
        newString = new byte[maxString];
        assert (newString[0] == 0);
        assert (newString[maxString - 1] == 0);
        xPolyPoints = new int[100][100];
        yPolyPoints = new int[100][100];
        turtleStackX = new double[1000];
        turtleStackY = new double[1000];
        turtleStackDir = new int[1000];
        turtleStackColor = new int[1000];
        turtleStackAlpha = new int[1000];
    }

    private static void free() {
        rule = null;
        lContext = null;
        rContext = null;
        sizeofRules = null;
        noRules = null;
        ignorCharacter = null;
        COS = null;
        SIN = null;
        string = null;
        newString = null;
        xPolyPoints = null;
        yPolyPoints = null;
        turtleStackX = null;
        turtleStackY = null;
        turtleStackDir = null;
        turtleStackColor = null;
        turtleStackAlpha = null;
    }

    static void testInitCalculation(ChromosomeType chromosome) {
        lsysChromosome = (LsysChromosome)chromosome;
        LsysMashine.allocate1();
        LsysMashine.initCalculation();
        LsysMashine.allocate2();
    }

    private static byte mapChar(char ch) {
        assert (ch > ' ');
        assert (ch < '\u007f');
        return (byte)ch;
    }

    private static void initCalculation() {
        try {
            String ignor = "";
            if (lsysChromosome instanceof LsysD0LChromosome) {
                jitter = 0;
                seed = 1512L;
                depth = ((LsysD0LChromosome)lsysChromosome).getDepth().getValue();
                ignor = "";
            } else if (lsysChromosome instanceof Lsys0LChromosome) {
                jitter = ((Lsys0LChromosome)lsysChromosome).getJitter().getValue();
                seed = ((Lsys0LChromosome)lsysChromosome).getNoiseSeed().getValue();
                depth = ((Lsys0LChromosome)lsysChromosome).getDepth().getValue();
                ignor = "";
            } else if (lsysChromosome instanceof LsysILChromosome) {
                jitter = ((LsysILChromosome)lsysChromosome).getJitter().getValue();
                seed = ((LsysILChromosome)lsysChromosome).getNoiseSeed().getValue();
                depth = ((LsysILChromosome)lsysChromosome).getDepth().getValue();
                ignor = ((LsysILChromosome)lsysChromosome).getIgnore().getValue();
            }
            baseIndex = lsysChromosome.getBaseIndex().getValue();
            ZVarJitter = new TextureRandomizer(seed);
            ZVarSelect = new TextureRandomizer(seed);
            noTurtleDirections = 2 * lsysChromosome.getDirections().getValue();
            startDirection = noTurtleDirections / 2;
            if (noTurtleDirections > 72 || noTurtleDirections < 1) {
                calculationState = -1;
                return;
            }
            int direction = 0;
            while (direction < noTurtleDirections) {
                LsysMashine.COS[direction] = Math.cos((double)direction * 2.0 * Math.PI / (double)noTurtleDirections);
                LsysMashine.SIN[direction] = Math.sin((double)direction * 2.0 * Math.PI / (double)noTurtleDirections);
                ++direction;
            }
            LsysMashine.initIgnore(ignor);
            typeOfLSystem = 0;
            int index = 127;
            while (index-- > 0) {
                LsysMashine.noRules[index] = 0;
            }
            List<LsysProductionGene> productions = lsysChromosome.getProduction();
            for (LsysProductionGene production : productions) {
                String predecessor = production.getPredecessor().getValue();
                String successor = production.getSuccessor().getValue();
                byte pred = 0;
                if (predecessor.length() == 1) {
                    pred = LsysMashine.mapChar(predecessor.charAt(0));
                    LsysMashine.sizeofRules[pred][LsysMashine.noRules[pred]] = index = successor.length();
                    while (index-- > 0) {
                        LsysMashine.rule[pred][LsysMashine.noRules[pred]][index] = LsysMashine.mapChar(successor.charAt(index));
                    }
                } else {
                    System.out.println("invalid rule");
                }
                LsysMashine.lContext[pred][LsysMashine.noRules[pred]] = 0;
                LsysMashine.rContext[pred][LsysMashine.noRules[pred]] = 0;
                if (lsysChromosome instanceof LsysILChromosome) {
                    String leftContext = production.getLeftContext().getValue();
                    String rightContext = production.getRightContext().getValue();
                    if (leftContext.length() > 0 && rightContext.length() > 0) {
                        typeOfLSystem = 4;
                        LsysMashine.lContext[pred][LsysMashine.noRules[pred]] = LsysMashine.mapChar(leftContext.charAt(0));
                        LsysMashine.rContext[pred][LsysMashine.noRules[pred]] = LsysMashine.mapChar(rightContext.charAt(0));
                    } else if (leftContext.length() > 0 && rightContext.length() == 0) {
                        typeOfLSystem = 3;
                        LsysMashine.lContext[pred][LsysMashine.noRules[pred]] = LsysMashine.mapChar(leftContext.charAt(0));
                    } else if (leftContext.length() == 0 && rightContext.length() > 0) {
                        typeOfLSystem = 3;
                        LsysMashine.rContext[pred][LsysMashine.noRules[pred]] = LsysMashine.mapChar(rightContext.charAt(0));
                    }
                }
                byte by = pred;
                noRules[by] = noRules[by] + 1;
            }
            if (typeOfLSystem < 2) {
                int rx = 127;
                while (rx-- != 0) {
                    if (noRules[rx] <= 1) continue;
                    typeOfLSystem = 2;
                    break;
                }
            }
            if (typeOfLSystem < 1) {
                typeOfLSystem = 1;
            }
            calculationState = 1;
        }
        catch (Exception exc) {
            Debug.stackTrace(exc);
            calculationState = -1;
        }
    }

    static void initIgnore(String ignor) {
        int ix = 127;
        while (ix-- > 0) {
            LsysMashine.ignorCharacter[ix] = false;
        }
        ix = ignor.length();
        while (ix-- > 0) {
            LsysMashine.ignorCharacter[ignor.charAt((int)ix)] = true;
        }
    }

    private static void calculate() {
        switch (calculationState) {
            case 1: {
                stackMessageSend = false;
                turtleX = 0.0;
                turtleY = 0.0;
                turtleDirection = startDirection;
                LsysMashine.expand(depth);
                ++calculationState;
                return;
            }
            case 2: {
                ZVarJitter.setSaat(seed);
                LsysMashine.postProcess();
                newString = null;
                ++calculationState;
                return;
            }
            case 3: {
                LsysMashine.filter();
                ++calculationState;
                return;
            }
            case 4: {
                ColorF32 cout = new ColorF32();
                colorator.getDiscretColor((baseIndex + 1) % numberOfDiscretColors, cout);
                LsysMashine.vectorCalculation.g2d.setColor(new Color(cout.r, cout.r, cout.r));
                LsysMashine.vectorCalculation.g2d.fillRect(0, 0, LsysMashine.vectorCalculation.canvasSize.width, LsysMashine.vectorCalculation.canvasSize.height);
                ++calculationState;
                return;
            }
            case 5: {
                ZVarJitter.setSaat(seed);
                LsysMashine.turtleInterpretation();
                ++calculationState;
                return;
            }
        }
        string = null;
        calculationState = 0;
    }

    static void expand(int maxDepth) {
        int[] hits = new int[64];
        String ax = lsysChromosome.getAxiom().getValue();
        int Index = length = ax.length();
        while (Index-- > 0) {
            LsysMashine.string[Index] = LsysMashine.mapChar(ax.charAt(Index));
        }
        int actDepth = 1;
        while (actDepth <= maxDepth) {
            if (vectorCalculation != null && vectorCalculation.isAborted()) break;
            newLength = 0;
            switch (typeOfLSystem) {
                case 1: {
                    int sizeofRule;
                    byte character;
                    int actPos = 0;
                    while (actPos < length) {
                        character = string[actPos];
                        if (noRules[character] != 0) {
                            sizeofRule = sizeofRules[character][0];
                            if (newLength + sizeofRule >= maxString) {
                                System.out.println("production overflow: depth " + actDepth + ", size " + newLength);
                                return;
                            }
                            System.arraycopy(rule[character][0], 0, newString, newLength, sizeofRule);
                            newLength += sizeofRule;
                        } else {
                            if (length + newLength + 1 >= maxString) {
                                System.out.println("production overflow: depth " + actDepth + ", size " + newLength);
                                return;
                            }
                            LsysMashine.newString[LsysMashine.newLength] = character;
                            ++newLength;
                        }
                        ++actPos;
                    }
                    break;
                }
                case 2: {
                    int selection;
                    int sizeofRule;
                    byte character;
                    int actPos = 0;
                    while (actPos < length) {
                        character = string[actPos];
                        if (noRules[character] != 0) {
                            selection = ZVarSelect.wuerfeln() % noRules[character];
                            sizeofRule = sizeofRules[character][selection];
                            if (newLength + sizeofRule >= maxString) {
                                System.out.println("production overflow: depth " + actDepth + ", size " + newLength);
                                return;
                            }
                            System.arraycopy(rule[character][selection], 0, newString, newLength, sizeofRule);
                            newLength += sizeofRule;
                        } else {
                            if (length + newLength + 1 >= maxString) {
                                System.out.println("production overflow: depth " + actDepth + ", size " + newLength);
                                return;
                            }
                            LsysMashine.newString[LsysMashine.newLength] = character;
                            ++newLength;
                        }
                        ++actPos;
                    }
                    break;
                }
                case 3: 
                case 4: {
                    int selection;
                    int sizeofRule;
                    byte character;
                    int actPos = 0;
                    while (actPos < length) {
                        character = string[actPos];
                        int AnzTreffer = 0;
                        int rx = 0;
                        while (rx < noRules[character]) {
                            boolean contextFound = true;
                            if (lContext[character][rx] != 0) {
                                contextFound = LsysMashine.testLeftContext(actPos, lContext[character][rx]);
                            }
                            if (contextFound && rContext[character][rx] != 0) {
                                contextFound = LsysMashine.testRightContext(actPos, rContext[character][rx]);
                            }
                            if (contextFound) {
                                hits[AnzTreffer] = rx;
                                ++AnzTreffer;
                            }
                            ++rx;
                        }
                        if (AnzTreffer == 0) {
                            rx = 0;
                            while (rx < noRules[character]) {
                                if (rContext[character][rx] == 0 && lContext[character][rx] == 0) {
                                    hits[AnzTreffer] = rx;
                                    ++AnzTreffer;
                                }
                                ++rx;
                            }
                        }
                        if (AnzTreffer != 0) {
                            selection = hits[ZVarSelect.wuerfeln() % AnzTreffer];
                            sizeofRule = sizeofRules[character][selection];
                            if (length + newLength + sizeofRule >= maxString) {
                                System.out.println("production overflow: depth " + actDepth + ", size " + newLength);
                                return;
                            }
                            System.arraycopy(rule[character][selection], 0, newString, newLength, sizeofRule);
                            newLength += sizeofRule;
                        } else {
                            if (length + newLength + 1 >= maxString) {
                                System.out.println("production overflow: depth " + actDepth + ", size " + newLength);
                                return;
                            }
                            LsysMashine.newString[LsysMashine.newLength] = character;
                            ++newLength;
                        }
                        ++actPos;
                    }
                    break;
                }
            }
            System.arraycopy(newString, 0, string, 0, newLength);
            length = newLength;
            ++actDepth;
        }
    }

    static boolean testLeftContext(int actPos, byte testCharacter) {
        int branchCount = 0;
        byte character = 0;
        --actPos;
        while (actPos >= 0 && ignorCharacter[string[actPos]]) {
            --actPos;
        }
        if (actPos >= 0) {
            character = string[actPos];
            while (branchCount > 0 || character == 91 || character == 93) {
                if (character == 91) {
                    if (branchCount > 0) {
                        --branchCount;
                    }
                } else if (character == 93) {
                    ++branchCount;
                }
                --actPos;
                while (actPos >= 0 && ignorCharacter[string[actPos]]) {
                    --actPos;
                }
                if (actPos >= 0) {
                    character = string[actPos];
                    continue;
                }
                return false;
            }
            return character == testCharacter;
        }
        return false;
    }

    static boolean testRightContext(int actPos, byte testCharacter) {
        int branchCount = 0;
        ++actPos;
        while (actPos < length && ignorCharacter[string[actPos]]) {
            ++actPos;
        }
        if (actPos < length) {
            byte character = string[actPos];
            while (branchCount != 0 || character == 91 || character == 93) {
                if (character == 91) {
                    ++branchCount;
                } else if (character == 93) {
                    --branchCount;
                }
                if (branchCount < 0) {
                    return false;
                }
                ++actPos;
                while (actPos < length && ignorCharacter[string[actPos]]) {
                    ++actPos;
                }
                if (actPos < length) {
                    character = string[actPos];
                    continue;
                }
                return false;
            }
            return character == testCharacter;
        }
        return false;
    }

    private static void turtleInterpretation() {
        byte character = string[0];
        turtleIndex = 0;
        int[] nPoints = new int[100];
        ColorF32[] lut = new ColorF32[numberOfDiscretColors];
        int lx = 0;
        while (lx < lut.length) {
            lut[lx] = new ColorF32();
            colorator.getDiscretColor(lx, lut[lx]);
            ++lx;
        }
        vectorCalculation.initTransformation(0.05);
        branchTOS = 0;
        leafTOS = 0;
        colorIndex = 0;
        realizedColor = null;
        alphaIndex = 0;
        realizedAlphaIndex = Integer.MAX_VALUE;
        turtleDirection = startDirection;
        turtleY = 0.0;
        turtleX = 0.0;
        double turtlePosOldY = 0.0;
        double turtlePosOldX = 0.0;
        nPoints[LsysMashine.leafTOS] = 0;
        turtleIndex = 0;
        while (turtleIndex < length) {
            if (turtleIndex % 10000 == 0) {
                if (vectorCalculation.isAborted()) break;
                vectorCalculation.getViewComponent().repaint();
            }
            LsysMashine.nextState(character);
            if (character == 70) {
                vectorCalculation.transform(turtleX, turtleY);
                int newX = LsysMashine.vectorCalculation.xp;
                int newY = LsysMashine.vectorCalculation.yp;
                if (leafTOS > 0 && leafTOS < 100 && nPoints[leafTOS] > 0) {
                    if (nPoints[leafTOS] < 100) {
                        LsysMashine.xPolyPoints[LsysMashine.leafTOS][nPoints[LsysMashine.leafTOS]] = newX;
                        LsysMashine.yPolyPoints[LsysMashine.leafTOS][nPoints[LsysMashine.leafTOS]] = newY;
                        int n = leafTOS;
                        nPoints[n] = nPoints[n] + 1;
                    }
                } else {
                    vectorCalculation.transform(turtlePosOldX, turtlePosOldY);
                    oldX = LsysMashine.vectorCalculation.xp;
                    oldY = LsysMashine.vectorCalculation.yp;
                    LsysMashine.setColor(lut);
                    if (transparenceEnabled) {
                        LsysMashine.setAlpha();
                    }
                    LsysMashine.vectorCalculation.g2d.drawLine(oldX, oldY, newX, newY);
                }
                turtlePosOldX = turtleX;
                turtlePosOldY = turtleY;
            } else if (character == 102 || character == 93) {
                turtlePosOldX = turtleX;
                turtlePosOldY = turtleY;
            } else if (character == 123) {
                ++colorIndex;
                vectorCalculation.transform(turtlePosOldX, turtlePosOldY);
                oldX = LsysMashine.vectorCalculation.xp;
                oldY = LsysMashine.vectorCalculation.yp;
                if (++leafTOS < 100) {
                    LsysMashine.xPolyPoints[LsysMashine.leafTOS][0] = LsysMashine.vectorCalculation.xp;
                    LsysMashine.yPolyPoints[LsysMashine.leafTOS][0] = LsysMashine.vectorCalculation.yp;
                    nPoints[LsysMashine.leafTOS] = 1;
                }
            } else if (character == 125) {
                if (leafTOS > 0 && leafTOS < 100) {
                    vectorCalculation.transform(turtleX, turtleY);
                    if (nPoints[leafTOS] < 100) {
                        LsysMashine.xPolyPoints[LsysMashine.leafTOS][nPoints[LsysMashine.leafTOS]] = LsysMashine.vectorCalculation.xp;
                        LsysMashine.yPolyPoints[LsysMashine.leafTOS][nPoints[LsysMashine.leafTOS]] = LsysMashine.vectorCalculation.xp;
                        int n = leafTOS;
                        nPoints[n] = nPoints[n] + 1;
                    }
                    if (nPoints[leafTOS] > 2) {
                        LsysMashine.setColor(lut);
                        if (transparenceEnabled) {
                            LsysMashine.setAlpha();
                        }
                        LsysMashine.vectorCalculation.g2d.fillPolygon(xPolyPoints[leafTOS], yPolyPoints[leafTOS], nPoints[leafTOS]);
                        nPoints[LsysMashine.leafTOS] = 0;
                    }
                }
                --leafTOS;
                --colorIndex;
            } else if (character == 46 && leafTOS > 0 && leafTOS < 100 && nPoints[leafTOS] > 0 && nPoints[leafTOS] < 100) {
                vectorCalculation.transform(turtleX, turtleY);
                if (leafTOS < 100) {
                    LsysMashine.xPolyPoints[LsysMashine.leafTOS][nPoints[LsysMashine.leafTOS]] = LsysMashine.vectorCalculation.xp;
                    LsysMashine.yPolyPoints[LsysMashine.leafTOS][nPoints[LsysMashine.leafTOS]] = LsysMashine.vectorCalculation.xp;
                    int n = leafTOS;
                    nPoints[n] = nPoints[n] + 1;
                }
            }
            character = string[++turtleIndex];
        }
    }

    private static void setColor(ColorF32[] lut) {
        int n;
        int n1 = baseIndex + colorIndex;
        int n2 = numberOfDiscretColors;
        if ((n1 -= (n = n1 / n2) * n2) < 0) {
            n1 += n2;
        }
        ColorF32 newColor = lut[n1];
        if (realizedColor == null || !realizedColor.equals(newColor)) {
            LsysMashine.vectorCalculation.g2d.setColor(new Color(newColor.r, newColor.g, newColor.b));
            realizedColor = newColor;
        }
    }

    private static void setAlpha() {
        if (alphaIndex != realizedAlphaIndex) {
            float newAlpha = LsysMashine.toAlpha(alphaIndex);
            AlphaComposite ac = AlphaComposite.getInstance(3, newAlpha);
            LsysMashine.vectorCalculation.g2d.setComposite(ac);
            realizedAlphaIndex = alphaIndex;
        }
    }

    public static float toAlpha(int rawValue) {
        float alpha = (float)((1.5707963267948966 + Math.atan((double)rawValue / 10.0)) / Math.PI);
        if ((double)alpha < 0.01) {
            return 0.0f;
        }
        if ((double)alpha > 0.99) {
            return 1.0f;
        }
        return alpha;
    }

    private static void postProcess() {
        byte character = string[0];
        int destination = 0;
        int source = 0;
        int newLength = 0;
        while (source < length) {
            if (character == 70 || character == 102 || character == 91 || character == 93 || character == 43 || character == 45 || character == 124 || character == 123 || character == 125 || character == 46 || character == 39 || character == 44 || character == 58 || character == 59) {
                LsysMashine.string[destination++] = character;
                ++newLength;
                LsysMashine.nextState(character);
                if (character == 70 || character == 102) {
                    LsysMashine.vectorCalculation.xmax = Math.max(turtleX, LsysMashine.vectorCalculation.xmax);
                    LsysMashine.vectorCalculation.ymax = Math.max(turtleY, LsysMashine.vectorCalculation.ymax);
                    LsysMashine.vectorCalculation.xmin = Math.min(turtleX, LsysMashine.vectorCalculation.xmin);
                    LsysMashine.vectorCalculation.ymin = Math.min(turtleY, LsysMashine.vectorCalculation.ymin);
                }
            }
            character = string[++source];
        }
        length = newLength;
    }

    private static void filter() {
        int newLength = 0;
        int oldLength = length;
        do {
            byte character = string[0];
            byte character2 = string[1];
            int destination = 0;
            int source = 0;
            oldLength = newLength;
            newLength = 0;
            while (source < length) {
                if (character == 45 && character2 == 93) {
                    int n = destination++;
                    int n2 = ++source;
                    ++source;
                    LsysMashine.string[n] = string[n2];
                    ++newLength;
                } else if (character == 43 && character2 == 93) {
                    int n = destination++;
                    int n3 = ++source;
                    ++source;
                    LsysMashine.string[n] = string[n3];
                    ++newLength;
                } else if (character == 91 && character2 == 93) {
                    source += 2;
                } else if (character == 123 && character2 == 125) {
                    source += 2;
                } else {
                    LsysMashine.string[destination++] = string[source++];
                    ++newLength;
                }
                character = string[source];
                character2 = string[source + 1];
            }
        } while (newLength != 0 && newLength < oldLength && !vectorCalculation.isAborted());
        length = newLength;
    }

    private static void nextState(int character) {
        switch (character) {
            case 70: 
            case 102: {
                if (jitter != 0) {
                    turtleX += (double)jitter / 100.0 * ZVarJitter.GaussVerteilt() + (double)(100 - jitter) / 100.0 * SIN[turtleDirection];
                    turtleY += (double)jitter / 100.0 * ZVarJitter.GaussVerteilt() + (double)(100 - jitter) / 100.0 * COS[turtleDirection];
                    break;
                }
                turtleX += SIN[turtleDirection];
                turtleY += COS[turtleDirection];
                break;
            }
            case 43: {
                if (++turtleDirection < noTurtleDirections) break;
                turtleDirection = 0;
                break;
            }
            case 45: {
                if (--turtleDirection >= 0) break;
                turtleDirection = noTurtleDirections - 1;
                break;
            }
            case 124: {
                if ((turtleDirection += noTurtleDirections / 2) < noTurtleDirections) break;
                turtleDirection -= noTurtleDirections;
                break;
            }
            case 91: {
                if (branchTOS >= 1000) {
                    if (stackMessageSend) break;
                    System.out.println("stack overflow");
                    stackMessageSend = true;
                    break;
                }
                LsysMashine.turtleStackX[LsysMashine.branchTOS] = (float)turtleX;
                LsysMashine.turtleStackY[LsysMashine.branchTOS] = (float)turtleY;
                LsysMashine.turtleStackDir[LsysMashine.branchTOS] = turtleDirection;
                LsysMashine.turtleStackColor[LsysMashine.branchTOS] = colorIndex;
                LsysMashine.turtleStackAlpha[LsysMashine.branchTOS] = alphaIndex;
                ++branchTOS;
                break;
            }
            case 93: {
                if (branchTOS == 0) {
                    if (!stackMessageSend) {
                        System.out.println("stack underflow");
                        stackMessageSend = true;
                    }
                } else {
                    --branchTOS;
                }
                turtleX = turtleStackX[branchTOS];
                turtleY = turtleStackY[branchTOS];
                turtleDirection = turtleStackDir[branchTOS];
                colorIndex = turtleStackColor[branchTOS];
                alphaIndex = turtleStackAlpha[branchTOS];
                break;
            }
            case 39: {
                if (leafTOS != 0) break;
                ++colorIndex;
                break;
            }
            case 44: {
                if (leafTOS != 0) break;
                --colorIndex;
                break;
            }
            case 58: {
                if (leafTOS != 0) break;
                ++alphaIndex;
                break;
            }
            case 59: {
                if (leafTOS != 0) break;
                --alphaIndex;
            }
        }
    }

    public static int getTypeOfLSystem() {
        return typeOfLSystem;
    }
}

